---
UID: NE:strmif.tagPhysicalConnectorType
title: PhysicalConnectorType (strmif.h)
description: Specifies the physical type of pin (audio or video).
old-location: dshow\physicalconnectortype.htm
tech.root: DirectShow
ms.assetid: 00635c01-f068-43b0-b7b6-d26f27886f71
ms.date: 12/05/2018
ms.keywords: PhysConn_Audio_1394, PhysConn_Audio_AESDigital, PhysConn_Audio_AUX, PhysConn_Audio_AudioDecoder, PhysConn_Audio_Line, PhysConn_Audio_Mic, PhysConn_Audio_SCSI, PhysConn_Audio_SPDIFDigital, PhysConn_Audio_Tuner, PhysConn_Audio_USB, PhysConn_Video_1394, PhysConn_Video_AUX, PhysConn_Video_Black, PhysConn_Video_Composite, PhysConn_Video_ParallelDigital, PhysConn_Video_RGB, PhysConn_Video_SCART, PhysConn_Video_SCSI, PhysConn_Video_SVideo, PhysConn_Video_SerialDigital, PhysConn_Video_Tuner, PhysConn_Video_USB, PhysConn_Video_VideoDecoder, PhysConn_Video_VideoEncoder, PhysConn_Video_YRYBY, PhysicalConnectorType, PhysicalConnectorType enumeration [DirectShow], PhysicalConnectorTypeEnumeration, dshow.physicalconnectortype, strmif/PhysConn_Audio_1394, strmif/PhysConn_Audio_AESDigital, strmif/PhysConn_Audio_AUX, strmif/PhysConn_Audio_AudioDecoder, strmif/PhysConn_Audio_Line, strmif/PhysConn_Audio_Mic, strmif/PhysConn_Audio_SCSI, strmif/PhysConn_Audio_SPDIFDigital, strmif/PhysConn_Audio_Tuner, strmif/PhysConn_Audio_USB, strmif/PhysConn_Video_1394, strmif/PhysConn_Video_AUX, strmif/PhysConn_Video_Black, strmif/PhysConn_Video_Composite, strmif/PhysConn_Video_ParallelDigital, strmif/PhysConn_Video_RGB, strmif/PhysConn_Video_SCART, strmif/PhysConn_Video_SCSI, strmif/PhysConn_Video_SVideo, strmif/PhysConn_Video_SerialDigital, strmif/PhysConn_Video_Tuner, strmif/PhysConn_Video_USB, strmif/PhysConn_Video_VideoDecoder, strmif/PhysConn_Video_VideoEncoder, strmif/PhysConn_Video_YRYBY, strmif/PhysicalConnectorType
f1_keywords:
- strmif/PhysicalConnectorType
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- strmif.h
api_name:
- PhysicalConnectorType
targetos: Windows
req.typenames: PhysicalConnectorType
req.redist: 
ms.custom: 19H1
---

# PhysicalConnectorType enumeration


## -description



Specifies the physical type of pin (audio or video).




## -enum-fields




### -field PhysConn_Video_Tuner

Specifies a tuner pin for video.


### -field PhysConn_Video_Composite

Specifies a composite pin for video.


### -field PhysConn_Video_SVideo

Specifies an S-Video (Y/C video) pin.


### -field PhysConn_Video_RGB

Specifies an RGB pin for video.


### -field PhysConn_Video_YRYBY

Specifies a YRYBY (Y, R–Y, B–Y) pin for video.


### -field PhysConn_Video_SerialDigital

Specifies a serial digital pin for video.


### -field PhysConn_Video_ParallelDigital

Specifies a parallel digital pin for video.


### -field PhysConn_Video_SCSI

Specifies a SCSI (Small Computer System Interface) pin for video.


### -field PhysConn_Video_AUX

Specifies an AUX (auxiliary) pin for video.


### -field PhysConn_Video_1394

Specifies an IEEE 1394 pin for video.


### -field PhysConn_Video_USB

Specifies a USB (Universal Serial Bus) pin for video.


### -field PhysConn_Video_VideoDecoder

Specifies a video decoder pin.


### -field PhysConn_Video_VideoEncoder

Specifies a video encoder pin.


### -field PhysConn_Video_SCART

Specifies a SCART (Peritel) pin for video.


### -field PhysConn_Video_Black

Not used.


### -field PhysConn_Audio_Tuner

Specifies a tuner pin for audio.


### -field PhysConn_Audio_Line

Specifies a line pin for audio.


### -field PhysConn_Audio_Mic

Specifies a microphone pin.


### -field PhysConn_Audio_AESDigital

Specifies an AES/EBU (Audio Engineering Society/European Broadcast Union) digital pin for audio.


### -field PhysConn_Audio_SPDIFDigital

Specifies an S/PDIF (Sony/Philips Digital Interface Format) digital pin for audio.


### -field PhysConn_Audio_SCSI

Specifies a SCSI pin for audio.


### -field PhysConn_Audio_AUX

Specifies an AUX pin for audio.


### -field PhysConn_Audio_1394

Specifies an IEEE 1394 pin for audio.


### -field PhysConn_Audio_USB

Specifies a USB pin for audio.


### -field PhysConn_Audio_AudioDecoder

Specifies an audio decoder pin.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>
 

 

