---
UID: NF:strmif.IAMCertifiedOutputProtection.KeyExchange
title: IAMCertifiedOutputProtection::KeyExchange (strmif.h)
description: The KeyExchange method returns the graphics driver's certificate.
old-location: dshow\iamcertifiedoutputprotection_keyexchange.htm
tech.root: DirectShow
ms.assetid: 163164a2-e2a2-447d-b443-f92972197aff
ms.date: 12/05/2018
ms.keywords: IAMCertifiedOutputProtection interface [DirectShow],KeyExchange method, IAMCertifiedOutputProtection.KeyExchange, IAMCertifiedOutputProtection::KeyExchange, IAMCertifiedOutputProtectionKeyExchange, KeyExchange, KeyExchange method [DirectShow], KeyExchange method [DirectShow],IAMCertifiedOutputProtection interface, dshow.iamcertifiedoutputprotection_keyexchange, strmif/IAMCertifiedOutputProtection::KeyExchange
f1_keywords:
- strmif/IAMCertifiedOutputProtection.KeyExchange
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Strmiids.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Strmiids.lib
- Strmiids.dll
api_name:
- IAMCertifiedOutputProtection.KeyExchange
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAMCertifiedOutputProtection::KeyExchange


## -description


The <b>KeyExchange</b> method returns the graphics driver's certificate.


## -parameters




### -param pRandom [out]

Receives a 128-bit random number, generated by the graphics driver. Use this value in the <a href="https://docs.microsoft.com/windows/desktop/api/strmif/nf-strmif-iamcertifiedoutputprotection-sessionsequencestart">IAMCertifiedOutputProtection::SessionSequenceStart</a> method.
          


### -param VarLenCertGH [out]

Receives a pointer to a buffer containing the graphics driver's certificate. The method allocates the memory for the buffer. The caller must release the memory by calling <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cotaskmemfree">CoTaskMemFree</a>.
          


### -param pdwLengthCertGH [out]

Receives the length of the buffer returned in <i>VarLenCertGH</i>.


## -returns



Returns an HRESULT value. Possible values include the following.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Success.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_UNEXPECTED</b></dt>
</dl>
</td>
<td width="60%">
Invalid state. Possibly the application passed unexpected data, or called <a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-iamcertifiedoutputprotection">IAMCertifiedOutputProtection</a> methods in the wrong order. If this error occurs, the application should release the current instance of the VMR.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>VFW_E_NO_COPP_HW</b></dt>
</dl>
</td>
<td width="60%">
The display device does not support COPP; or the VMR has not connected to a display device yet.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE</b></dt>
</dl>
</td>
<td width="60%">
No monitors correspond to the display device. This error can occur if the display mode changes; or the user turns off a monitor or removes a monitor.

</td>
</tr>
</table>
 




## -remarks



The graphics driver's certificate contains the driver's public encryption key.

If this method returns E_UNEXPECTED, the application should create a new COPP session by releasing the VMR, creating a new instance of the VMR, and calling <code>KeyExchange</code> again on the new instance.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-iamcertifiedoutputprotection">IAMCertifiedOutputProtection Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/DirectShow/using-certified-output-protection-protocol--copp">Using Certified Output Protection Protocol (COPP)</a>
 

 

