---
UID: NF:strmif.IAMPushSource.SetStreamOffset
title: IAMPushSource::SetStreamOffset (strmif.h)
description: The SetStreamOffset method sets the offset for time stamps generated by this filter.
old-location: dshow\iampushsource_setstreamoffset.htm
tech.root: DirectShow
ms.assetid: a80d9f2e-6552-4bbb-9593-c1bef892548a
ms.date: 12/05/2018
ms.keywords: IAMPushSource interface [DirectShow],SetStreamOffset method, IAMPushSource.SetStreamOffset, IAMPushSource::SetStreamOffset, IAMPushSourceSetStreamOffset, SetStreamOffset, SetStreamOffset method [DirectShow], SetStreamOffset method [DirectShow],IAMPushSource interface, dshow.iampushsource_setstreamoffset, strmif/IAMPushSource::SetStreamOffset
f1_keywords:
- strmif/IAMPushSource.SetStreamOffset
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Strmiids.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Strmiids.lib
- Strmiids.dll
api_name:
- IAMPushSource.SetStreamOffset
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IAMPushSource::SetStreamOffset


## -description



The <code>SetStreamOffset</code> method sets the offset for time stamps generated by this filter.




## -parameters




### -param rtOffset [in]

New stream offset for the filter.


## -returns



Returns S_FALSE if the specified offset is larger than the filter's maximum preferred offset. Otherwise, returns S_OK if successful or an <b>HRESULT</b> value indicating the cause of the error.




## -remarks



The filter graph calls this method to adjust a filter's stream offset, in order to synchronize streams with different latency values.

If the return value is S_FALSE, the filter might not support a buffer large enough for the requested offset. Unless there is another buffer downstream, data might be lost. To retrieve the filter's maximum preferred offset, call the <a href="https://docs.microsoft.com/windows/desktop/api/strmif/nf-strmif-iampushsource-getmaxstreamoffset">IAMPushSource::GetMaxStreamOffset</a> method.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/error-and-success-codes">Error and Success Codes</a>



<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-iampushsource">IAMPushSource Interface</a>
 

 

