---
UID: NN:strmif.IOverlayNotify2
title: IOverlayNotify2 (strmif.h)
description: The IOverlayNotify2 interface derives from the IOverlayNotify interface.
old-location: dshow\ioverlaynotify2.htm
tech.root: DirectShow
ms.assetid: 439b3939-84da-48f5-b2a5-47f68fedef06
ms.date: 12/05/2018
ms.keywords: IOverlayNotify2, IOverlayNotify2 interface [DirectShow], IOverlayNotify2 interface [DirectShow],described, IOverlayNotify2Interface, dshow.ioverlaynotify2, strmif/IOverlayNotify2
f1_keywords:
- strmif/IOverlayNotify2
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Strmiids.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Strmiids.lib
- Strmiids.dll
api_name:
- IOverlayNotify2
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOverlayNotify2 interface


## -description



The <code>IOverlayNotify2</code> interface derives from the <a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-ioverlaynotify">IOverlayNotify</a> interface. <code>IOverlayNotify2</code> gives asynchronous notifications of changes to the rendering window, identifying changes to the exposed window area. The advise link optionally supports this for the purpose of accepting <a href="https://docs.microsoft.com/windows/desktop/api/strmif/nf-strmif-ioverlaynotify2-ondisplaychange">IOverlayNotify2::OnDisplayChange</a> notification.

To get notifications that the exposed window area has changed, decoders that do their own drawing should implement an <code>IOverlayNotify2</code> interface.

The video renderer is the only filter that calls the method on this interface. This is done automatically by the default video renderer.




## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IOverlayNotify2</b> interface inherits from <a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-ioverlaynotify">IOverlayNotify</a>. <b>IOverlayNotify2</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IOverlayNotify2</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nf-strmif-ioverlaynotify2-ondisplaychange">OnDisplayChange</a>
</td>
<td align="left" width="63%">
Provides notification that the exposed window area has changed.

</td>
</tr>
</table> 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-ioverlaynotify">IOverlayNotify</a>
 

 

