---
UID: NF:structuredquery.IConditionGenerator.GenerateForLeaf
title: IConditionGenerator::GenerateForLeaf (structuredquery.h)
description: Generates a special query expression for what would otherwise become a leaf query expression.
old-location: search\_search_IConditionGenerator_GenerateForLeaf.htm
tech.root: search
ms.assetid: VS|search|~\search\wds3x\reference\ifaces\querying\iconditiongenerator\generateforleaf.htm
ms.date: 12/05/2018
ms.keywords: GenerateForLeaf, GenerateForLeaf method [search], GenerateForLeaf method [search],IConditionGenerator interface, IConditionGenerator interface [search],GenerateForLeaf method, IConditionGenerator.GenerateForLeaf, IConditionGenerator::GenerateForLeaf, _search_IConditionGenerator_GenerateForLeaf, search._search_IConditionGenerator_GenerateForLeaf, structuredquery/IConditionGenerator::GenerateForLeaf
f1_keywords:
- structuredquery/IConditionGenerator.GenerateForLeaf
dev_langs:
- c++
req.header: structuredquery.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2, Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 with SP1 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Structuredquery.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Structuredquery.h
api_name:
- IConditionGenerator.GenerateForLeaf
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IConditionGenerator::GenerateForLeaf


## -description


Generates a special query expression for what would otherwise become a leaf query expression.
        


## -parameters




### -param pConditionFactory [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nn-structuredquery-iconditionfactory">IConditionFactory</a>*</b>

An <a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nn-structuredquery-iconditionfactory">IConditionFactory</a> object that can be used to create the necessary nodes.
            


### -param pszPropertyName [in]

Type: <b>LPCWSTR</b>

Property name, or <b>NULL</b> if there is no property name.
            


### -param cop [in]

Type: <b><a href="https://docs.microsoft.com/windows/win32/api/structuredquerycondition/ne-structuredquerycondition-condition_operation">CONDITION_OPERATION</a></b>

A <a href="https://docs.microsoft.com/windows/win32/api/structuredquerycondition/ne-structuredquerycondition-condition_operation">CONDITION_OPERATION</a> enumerated type identifying the operation.
            


### -param pszValueType [in]

Type: <b>LPCWSTR</b>

Semantic type describing the values in <i>pszValue</i> and <i>pszValue2</i>.
            


### -param pszValue [in]

Type: <b>LPCWSTR</b>

A string generated by <a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nf-structuredquery-iconditiongenerator-recognizenamedentities">IConditionGenerator::RecognizeNamedEntities</a> that represents the value. If <i>pszValue2</i> is not <b>NULL</b>, then this represents the beginning of the value's range.
            


### -param pszValue2 [in]

Type: <b>LPCWSTR</b>

If not <b>NULL</b>, a string generated by <a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nf-structuredquery-iconditiongenerator-recognizenamedentities">IConditionGenerator::RecognizeNamedEntities</a> that represents the end of the value's range. If <b>NULL</b>, then <i>pszValue</i> represents a discrete value.
            


### -param pPropertyNameTerm [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-irichchunk">IRichChunk</a>*</b>

Pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-irichchunk">IRichChunk</a> object containing information about what part of an input string produced the property name.
            


### -param pOperationTerm [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-irichchunk">IRichChunk</a>*</b>

Pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-irichchunk">IRichChunk</a> object containing information about what part of an input string produced the operation.
            


### -param pValueTerm [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-irichchunk">IRichChunk</a>*</b>

Pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-irichchunk">IRichChunk</a> object containing information about what part of an input string produced the value.
            


### -param automaticWildcard [in]

Type: <b>BOOL</b>

<b>TRUE</b> if the generated condition should return results that begin with the specified value, if meaningful. <b>FALSE </b> if the generated condition should return results matching the specified value exactly.
            


### -param pNoStringQuery [out]

Type: <b>BOOL*</b>

<b>VARIANT_TRUE</b> if the condition tree in <i>ppQueryExpression</i> should be the full query, or <b>VARIANT_FALSE</b> if the full query should be a disjunction of the condition tree in <i>ppQueryExpression</i> and the condition tree that would have been used if this method had returned S_FALSE.
            


### -param ppQueryExpression [out, retval]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-icondition">ICondition</a>**</b>

Receives a pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-icondition">ICondition</a> condition tree.
            


## -returns



Type: <b>HRESULT</b>

Returns one of the following, or an error value otherwise. 
            

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Successfully generated a condition.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_FALSE</b></dt>
</dl>
</td>
<td width="60%">
A condition was not generated, and the query parser must produce one in some other way.

</td>
</tr>
</table>
 




## -remarks



If this method returns S_FALSE, the calling query parser should generate a leaf node N with this property name, operation, and value. If this method returns S_FALSE and <i>pNoStringQuery</i> contains <b>VARIANT_FALSE</b>, the full generated query is a disjunction (OR) with the leaf node N and the condition tree in <i>ppQueryExpression</i> as subconditions.

If this method returns S_OK and <i>pNoStringQuery</i> contains <b>VARIANT_TRUE</b>, the condition tree in <i>ppQueryExpression</i> is the full query.

The value of <i>pszValue2</i> is non-<b>NULL</b> only for a range query, such as <code>date:1/2/2003..1/30/2006</code>, where <i>pszValue</i> contains the value for 1/2/2003 and <i>pszValue2</i> contains the value for 1/30/2006. A condition generator can elect to refuse ranges by always returning S_OK when <i>pszValue2</i> is not <b>NULL</b>.

A condition generator can safely ignore the arguments <i>pPropertyNameTerm</i>, <i>pOperationTerm</i>, and <i>pValueTerm</i>. However, it would use them to produce a leaf node that has correct information about the origins in the query string of the property name, the operator, and the value, by passing them on to <a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nf-structuredquery-iconditionfactory-makeleaf">MakeLeaf</a>.

In many cases, a condition generator can ignore the argument <i>automaticWildcard</i> because it would not apply. However, if the generated condition tree does some form of string search, where both a prefix search (<a href="https://docs.microsoft.com/windows/win32/api/structuredquerycondition/ne-structuredquerycondition-condition_operation">COP_VALUE_STARTSWITH</a> from <b>CONDITION_OPERATION</b>) and a search for the exact string (<b>COP_EQUAL</b> from <b>CONDITION_OPERATION</b>) are meaningful, then the former should be generated when <i>automaticWildcard</i> is <b>VARIANT_TRUE</b>, and the latter when <i>automaticWildcard</i> is <b>VARIANT_FALSE</b>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/ne-structuredquery-condition_creation_options">CONDITION_CREATION_OPTIONS</a>



<a href="https://docs.microsoft.com/windows/win32/api/structuredquerycondition/ne-structuredquerycondition-condition_operation">CONDITION_OPERATION</a>



<a href="https://docs.microsoft.com/windows/win32/api/structuredquerycondition/ne-structuredquerycondition-condition_type">CONDITION_TYPE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-icondition">ICondition</a>



<a href="https://docs.microsoft.com/windows/desktop/api/structuredquerycondition/nn-structuredquerycondition-icondition2">ICondition2</a>



<a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nn-structuredquery-iconditionfactory">IConditionFactory</a>



<a href="https://docs.microsoft.com/windows/desktop/api/structuredquery/nn-structuredquery-iconditiongenerator">IConditionGenerator</a>



<b>Reference</b>
 

 

