---
UID: NF:synchapi.WakeAllConditionVariable
title: WakeAllConditionVariable function (synchapi.h)
description: Wake all threads waiting on the specified condition variable.
old-location: base\wakeallconditionvariable.htm
tech.root: Sync
ms.assetid: 1a57562a-fbbc-4a5f-910c-7a52a8dccbe3
ms.date: 12/05/2018
ms.keywords: WakeAllConditionVariable, WakeAllConditionVariable function, base.wakeallconditionvariable, synchapi/WakeAllConditionVariable, winbase/WakeAllConditionVariable
f1_keywords:
- synchapi/WakeAllConditionVariable
dev_langs:
- c++
req.header: synchapi.h
req.include-header: Windows 7, Windows Server 2008  Windows Server 2008 R2, Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Kernel32.lib
req.dll: Kernel32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Kernel32.dll
- API-MS-Win-Core-Synch-l1-2-0.dll
- KernelBase.dll
- API-MS-Win-Core-Synch-l1-2-1.dll
- API-MS-Win-DownLevel-Kernel32-l1-1-0.dll
- MinKernelBase.dll
- vertdll.dll
api_name:
- WakeAllConditionVariable
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# WakeAllConditionVariable function


## -description


Wake all threads waiting on the specified condition variable.


## -parameters




### -param ConditionVariable [in, out]

A pointer to the condition variable.


## -returns



This function does not return a value.




## -remarks



The <b>WakeAllConditionVariable</b> wakes all 
    waiting threads while the <a href="https://docs.microsoft.com/windows/desktop/api/synchapi/nf-synchapi-wakeconditionvariable">WakeConditionVariable</a> 
    wakes only a single thread. Waking one thread is similar to setting an auto-reset event, while waking all threads 
    is similar to pulsing a manual reset event but more reliable (see 
    <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-pulseevent">PulseEvent</a> for details).




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Sync/condition-variables">Condition Variables</a>



<a href="https://docs.microsoft.com/windows/desktop/Sync/synchronization-functions">Synchronization Functions</a>
 

 

