---
UID: NF:tapi.lineProxyMessage
title: lineProxyMessage function (tapi.h)
description: The lineProxyMessage function is used by a registered proxy request handler to generate TAPI messages related to its role.
old-location: tapi2\lineproxymessage.htm
tech.root: Tapi
ms.assetid: 624a13f4-4be7-441b-abc0-e1fad8f01bdf
ms.date: 12/05/2018
ms.keywords: _tapi2_lineproxymessage, lineProxyMessage, lineProxyMessage function [TAPI 2.2], tapi/lineProxyMessage, tapi2.lineproxymessage
f1_keywords:
- tapi/lineProxyMessage
dev_langs:
- c++
req.header: tapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Tapi32.lib
req.dll: Tapi32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Tapi32.dll
api_name:
- lineProxyMessage
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# lineProxyMessage function


## -description


The 
<b>lineProxyMessage</b> function is used by a registered proxy request handler to generate TAPI messages related to its role. For example, an ACD agent handler can use this function to generate 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/line-agentstatus">LINE_AGENTSTATUS</a> messages that are received by all applications that have the specified line open. TAPI suppresses generation of the message on the <i>hLine</i> specified in the function parameters.


## -parameters




### -param hLine

Handle to the open line device. This is converted by TAPI into the correct <i>hLine</i> for each application that receives the message.


### -param hCall

If the message is related to a specific call (which it is not, in the case of LINE_AGENTSTATUS), specifies the proxy handler's handle to that call; shall be set to <b>NULL</b> for messages not related to a specific call. This is converted by TAPI into the correct <i>hCall</i> for each application that receives the message.


### -param dwMsg

The TAPI message to generate. This must be a message that is permitted to be generated by proxy handlers.


### -param dwParam1

Parameter associated with the message to be sent.


### -param dwParam2

Parameter associated with the message to be sent.


### -param dwParam3

Parameter associated with the message to be sent.


## -returns



Returns zero if the function succeeds or one of these negative error values:

LINEERR_INVALLINEHANDLE, LINEERR_INVALCALLHANDLE, LINEERR_INVALPARAM, LINEERR_NOMEM, LINEERR_NOTREGISTERED, LINEERR_OPERATIONFAILED, LINEERR_OPERATIONUNAVAIL, LINEERR_RESOURCEUNAVAIL, LINEERR_UNINITIALIZED.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Tapi/line-agentstatus">LINE_AGENTSTATUS</a>



<a href="https://docs.microsoft.com/windows/desktop/Tapi/supplementary-line-service-functions">Supplementary Line Service Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/Tapi/tapi-2-2-reference">TAPI 2.2 Reference Overview</a>
 

 

