---
UID: NF:tapi.lineSetCallTreatment
title: lineSetCallTreatment function (tapi.h)
description: The lineSetCallTreatment function sets the sounds a party on a call that is unanswered or on hold hears. Except for basic parameter validation, it is a straight pass-through by TAPI to the service provider.
old-location: tapi2\linesetcalltreatment.htm
tech.root: Tapi
ms.assetid: 0f1a3303-f6c3-4a5f-99bd-35e107c9b0b0
ms.date: 12/05/2018
ms.keywords: _tapi2_linesetcalltreatment, lineSetCallTreatment, lineSetCallTreatment function [TAPI 2.2], tapi/lineSetCallTreatment, tapi2.linesetcalltreatment
f1_keywords:
- tapi/lineSetCallTreatment
dev_langs:
- c++
req.header: tapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Tapi32.lib
req.dll: Tapi32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Tapi32.dll
api_name:
- lineSetCallTreatment
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# lineSetCallTreatment function


## -description


The 
<b>lineSetCallTreatment</b> function sets the sounds a party on a call that is unanswered or on hold hears. Except for basic parameter validation, it is a straight pass-through by TAPI to the service provider.


## -parameters




### -param hCall

Handle to the call. The application must have OWNER privilege.


### -param dwTreatment

One of the call treatments supported on the address on which the call appears, as indicated by 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi/ns-tapi-lineaddresscaps">LINEADDRESSCAPS</a>. LINEERR_INVALPARAM is returned if the specified treatment is not supported.


## -returns



Returns a positive request identifier if the asynchronous operation starts; otherwise, the function returns one of these negative error values:

LINEERR_INVALCALLHANDLE, LINEERR_INVALCALLSTATE, LINEERR_INVALPARAM, LINEERR_NOMEM, LINEERR_NOTOWNER, LINEERR_OPERATIONFAILED, LINEERR_OPERATIONUNAVAIL, LINEERR_RESOURCEUNAVAIL, LINEERR_UNINITIALIZED.




## -remarks



The use of call treatment functionality should be limited to controlling of legacy equipment. New equipment is generally designed so that instead of call treatments being generated by external switching equipment, calls would be connected to PC-based audio sources and signals generated using standard functions such as the multimedia Wave API.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/tapi/ns-tapi-lineaddresscaps">LINEADDRESSCAPS</a>



<a href="https://docs.microsoft.com/windows/desktop/Tapi/supplementary-line-service-functions">Supplementary Line Service Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/Tapi/tapi-2-2-reference">TAPI 2.2 Reference Overview</a>
 

 

