---
UID: NE:tapi3if.ADDRESS_CAPABILITY
title: ADDRESS_CAPABILITY (tapi3if.h)
description: A member of the ADDRESS_CAPABILITY enum is used by the ITAddressCapabilities::get_AddressCapability method to indicate the address capability required.
old-location: tapi3\address_capability.htm
tech.root: Tapi
ms.assetid: 47ddd1fb-dc47-4822-87b8-9944491f8b3e
ms.date: 12/05/2018
ms.keywords: AC_ADDRESSCAPFLAGS, AC_ADDRESSFEATURES, AC_ADDRESSID, AC_ADDRESSTYPES, AC_ANSWERMODES, AC_BEARERMODES, AC_CALLCOMPLETIONCONDITIONS, AC_CALLCOMPLETIONMODES, AC_CALLEDIDSUPPORT, AC_CALLERIDSUPPORT, AC_CALLFEATURES1, AC_CALLFEATURES2, AC_CONNECTEDIDSUPPORT, AC_DEVCAPFLAGS, AC_FORWARDMODES, AC_GENERATEDIGITSUPPORT, AC_GENERATETONEMAXNUMFREQ, AC_GENERATETONEMODES, AC_LINEFEATURES, AC_LINEID, AC_MAXACTIVECALLS, AC_MAXCALLCOMPLETIONS, AC_MAXCALLDATASIZE, AC_MAXFORWARDENTRIES, AC_MAXFWDNUMRINGS, AC_MAXNUMCONFERENCE, AC_MAXNUMTRANSCONF, AC_MAXONHOLDCALLS, AC_MAXONHOLDPENDINGCALLS, AC_MAXSPECIFICENTRIES, AC_MINFWDNUMRINGS, AC_MONITORDIGITSUPPORT, AC_MONITORTONEMAXNUMENTRIES, AC_MONITORTONEMAXNUMFREQ, AC_PARKSUPPORT, AC_PERMANENTDEVICEID, AC_PREDICTIVEAUTOTRANSFERSTATES, AC_REDIRECTINGIDSUPPORT, AC_REDIRECTIONIDSUPPORT, AC_REMOVEFROMCONFCAPS, AC_REMOVEFROMCONFSTATE, AC_SETTABLEDEVSTATUS, AC_TRANSFERMODES, ADDRESS_CAPABILITY, ADDRESS_CAPABILITY enumeration [TAPI 2.2], _tapi3_address_capability, tapi3.address_capability, tapi3if/AC_ADDRESSCAPFLAGS, tapi3if/AC_ADDRESSFEATURES, tapi3if/AC_ADDRESSID, tapi3if/AC_ADDRESSTYPES, tapi3if/AC_ANSWERMODES, tapi3if/AC_BEARERMODES, tapi3if/AC_CALLCOMPLETIONCONDITIONS, tapi3if/AC_CALLCOMPLETIONMODES, tapi3if/AC_CALLEDIDSUPPORT, tapi3if/AC_CALLERIDSUPPORT, tapi3if/AC_CALLFEATURES1, tapi3if/AC_CALLFEATURES2, tapi3if/AC_CONNECTEDIDSUPPORT, tapi3if/AC_DEVCAPFLAGS, tapi3if/AC_FORWARDMODES, tapi3if/AC_GENERATEDIGITSUPPORT, tapi3if/AC_GENERATETONEMAXNUMFREQ, tapi3if/AC_GENERATETONEMODES, tapi3if/AC_LINEFEATURES, tapi3if/AC_LINEID, tapi3if/AC_MAXACTIVECALLS, tapi3if/AC_MAXCALLCOMPLETIONS, tapi3if/AC_MAXCALLDATASIZE, tapi3if/AC_MAXFORWARDENTRIES, tapi3if/AC_MAXFWDNUMRINGS, tapi3if/AC_MAXNUMCONFERENCE, tapi3if/AC_MAXNUMTRANSCONF, tapi3if/AC_MAXONHOLDCALLS, tapi3if/AC_MAXONHOLDPENDINGCALLS, tapi3if/AC_MAXSPECIFICENTRIES, tapi3if/AC_MINFWDNUMRINGS, tapi3if/AC_MONITORDIGITSUPPORT, tapi3if/AC_MONITORTONEMAXNUMENTRIES, tapi3if/AC_MONITORTONEMAXNUMFREQ, tapi3if/AC_PARKSUPPORT, tapi3if/AC_PERMANENTDEVICEID, tapi3if/AC_PREDICTIVEAUTOTRANSFERSTATES, tapi3if/AC_REDIRECTINGIDSUPPORT, tapi3if/AC_REDIRECTIONIDSUPPORT, tapi3if/AC_REMOVEFROMCONFCAPS, tapi3if/AC_REMOVEFROMCONFSTATE, tapi3if/AC_SETTABLEDEVSTATUS, tapi3if/AC_TRANSFERMODES, tapi3if/ADDRESS_CAPABILITY
f1_keywords:
- tapi3if/ADDRESS_CAPABILITY
dev_langs:
- c++
req.header: tapi3if.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Tapi3if.h
api_name:
- ADDRESS_CAPABILITY
targetos: Windows
req.typenames: ADDRESS_CAPABILITY
req.redist: 
ms.custom: 19H1
---

# ADDRESS_CAPABILITY enumeration


## -description


A member of the 
<b>ADDRESS_CAPABILITY</b> enum is used by the 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itaddresscapabilities-get_addresscapability">ITAddressCapabilities::get_AddressCapability</a> method to indicate the address capability required.


## -enum-fields




### -field AC_ADDRESSTYPES

An address may support more than one 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineaddresstype--constants">address type</a>, but please note that one may be used during 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itaddress-createcall">ITAddress::CreateCall</a>.


### -field AC_BEARERMODES


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linebearermode--constants">Bearer modes</a>.


### -field AC_MAXACTIVECALLS

The maximum number of (minimum bandwidth) calls that can be active (connected) on the line at any one time. The actual number of active calls can be lower if higher bandwidth calls are established on the line.


### -field AC_MAXONHOLDCALLS

Maximum number of calls that can be on hold at once.


### -field AC_MAXONHOLDPENDINGCALLS

Maximum number of calls that can be simultaneously pending transfer or conference.


### -field AC_MAXNUMCONFERENCE

Contains the maximum number of parties that can join a single conference call on this address.


### -field AC_MAXNUMTRANSCONF

Specifies the number of parties (including "self") that can be added in a conference call that is initiated as a generic consultation call using 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itbasiccallcontrol-transfer">ITBasicCallControl::Transfer</a> and 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itbasiccallcontrol-finish">ITBasicCallControl::Finish</a> (FM_ASCONFERENCE).


### -field AC_MONITORDIGITSUPPORT

Specifies digit modes detectable on this address using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linedigitmode--constants">LINEDIGITMODE_</a> flags. If no flag is set, digit monitoring is not supported.


### -field AC_GENERATEDIGITSUPPORT

Specifies digit modes that can be generated on this address using a subset of the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linedigitmode--constants">LINEDIGITMODE_</a> flags: LINEDIGITMODE_PULSE indicates digits can be generated as pulse/rotary tones, and LINEDIGITMODE_DTMF indicates digits can be generated as DTMF tones. If no flag is set, digit generation is not supported.


### -field AC_GENERATETONEMODES

Specifies the different kinds of tones that can be generated on this line, of type 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linetonemode--constants">LINETONEMODE_</a>.


### -field AC_GENERATETONEMAXNUMFREQ

Contains the maximum number of frequencies that can be specified in describing a general tone.


### -field AC_MONITORTONEMAXNUMFREQ

Contains the maximum number of frequencies that can be specified when monitoring a general tone. A value of 0 indicates that tone monitor is not available.


### -field AC_MONITORTONEMAXNUMENTRIES

Contains the maximum number of entries that can be specified in a tone list.


### -field AC_DEVCAPFLAGS


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linedevcapflags--constants">Device capability flags</a>.


### -field AC_ANSWERMODES


<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineanswermode--constants">Answer modes</a>.


### -field AC_LINEFEATURES

Specifies the features available for this line using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linefeature--constants">LINEFEATURE_ constants</a>. Invoking a supported feature requires the line to be in the proper state and the underlying line device to be opened in a compatible mode. A zero in a bit position indicates that the corresponding feature is never available. A one indicates that the corresponding feature may be available if the line is in the appropriate state for the operation to be meaningful. This member allows an application to discover which line features can be (and which can never be) supported by the device.


### -field AC_SETTABLEDEVSTATUS

Indicates 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi/ns-tapi-linedevstatus">LINEDEVSTATUS_</a> values that can be modified.


### -field AC_PARKSUPPORT

Indicates whether park is supported using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineparkmode--constants">LINEPARKMODE_</a> flags.


### -field AC_CALLERIDSUPPORT

Identifies support for caller number identification using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallpartyid--constants">LINECALLPARTYID_</a> flags.


### -field AC_CALLEDIDSUPPORT

Identifies support for called number identification using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallpartyid--constants">LINECALLPARTYID_</a> flags.


### -field AC_CONNECTEDIDSUPPORT

Indicates whether connected ID is supported using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallpartyid--constants">LINECALLPARTYID_</a> flags.


### -field AC_REDIRECTIONIDSUPPORT

Indicates whether redirection ID is supported using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallpartyid--constants">LINECALLPARTYID_</a> flags.


### -field AC_REDIRECTINGIDSUPPORT

Indicates whether redirecting ID is supported using the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallpartyid--constants">LINECALLPARTYID_</a> flags.


### -field AC_ADDRESSCAPFLAGS

The address 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineaddrcapflags--constants">capability flags</a> describe various Boolean address capabilities. For example, LINEADDRCAPFLAGS_FWDNUMRINGS indicates whether the number of rings for a no-answer can be specified when forwarding on a no-answer.


### -field AC_CALLFEATURES1


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallfeature--constants">Call feature set one</a>.


### -field AC_CALLFEATURES2


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallfeature2--constants">Supplemental call features</a> for conferencing, transferring, and parking calls.


### -field AC_REMOVEFROMCONFCAPS

Specifies the address's capabilities for removing calls from a conference call. This member uses the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineremovefromconf--constants">LINEREMOVEFROMCONF_ constants</a>.


### -field AC_REMOVEFROMCONFSTATE

Uses the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallstate--constants">LINECALLSTATE_ constants</a> to specify the state of the call after it has been removed from a conference call.


### -field AC_TRANSFERMODES


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linetransfermode--constants">Transfer modes</a>.


### -field AC_ADDRESSFEATURES

The 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineaddrfeature--constants">line address features</a> describe operations that can be invoked on an address. For example, if LINEADDRFEATURE_FORWARD is set, the address can be forwarded.


### -field AC_PREDICTIVEAUTOTRANSFERSTATES

The call state or states upon which a call made by a predictive dialer can be set to automatically transfer the call to another address; one or more of the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallstate--constants">LINECALLSTATE_ constants</a>. The value 0 indicates automatic transfer based on call state is unavailable.


### -field AC_MAXCALLDATASIZE

Maximum data block size allowed.


### -field AC_LINEID

Returns the device identifier of the line device with which this address is associated. TAPI 2.1 cross-reference: 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi/ns-tapi-lineaddresscaps">LINEADDRESSCAPS</a>.


### -field AC_ADDRESSID

Address identifier. An address identifier is permanently associated with an address; the identifier remains constant across operating system upgrades.


### -field AC_FORWARDMODES


<a href="https://docs.microsoft.com/windows/desktop/Tapi/lineforwardmode--constants">Forwarding modes</a>.


### -field AC_MAXFORWARDENTRIES

The maximum number of different forwarding entries that can be supported by the current address.


### -field AC_MAXSPECIFICENTRIES

Specifies the maximum number of entries that can be set using 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itforwardinformation-setforwardtype">ITForwardInformation::SetForwardType</a> that can contain forwarding instructions based on a specific caller (selective call forwarding). This member is zero if selective call forwarding is not supported.


### -field AC_MINFWDNUMRINGS

Specifies the minimum number of rings that can be set to determine when a call is officially considered "no answer."


### -field AC_MAXFWDNUMRINGS

Specifies the maximum number of rings that can be set to determine when a call is officially considered "no answer."


### -field AC_MAXCALLCOMPLETIONS

The maximum number of concurrent call completion requests that can be outstanding on this address. Zero implies that call completion is not available.


### -field AC_CALLCOMPLETIONCONDITIONS


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallcomplcond--constants">Call completion conditions</a>.


### -field AC_CALLCOMPLETIONMODES


<a href="https://docs.microsoft.com/windows/desktop/Tapi/linecallcomplmode--constants">Call completion modes</a>.


### -field AC_PERMANENTDEVICEID

The permanent identifier by which the line device is known in the system's configuration. This value does not change as lines are added and removed from the system. It can therefore be used to link line-specific information in the registry or other files in a way that is not affected by changes in other lines. If a line has more than one address, all addresses will have the same permanent device identifier. TSP writers should note that this value must be preserved across operating system upgrades.


### -field AC_GATHERDIGITSMINTIMEOUT


### -field AC_GATHERDIGITSMAXTIMEOUT


### -field AC_GENERATEDIGITMINDURATION


### -field AC_GENERATEDIGITMAXDURATION


### -field AC_GENERATEDIGITDEFAULTDURATION




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Tapi/address-object">Address object</a>



<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nn-tapi3if-itaddress">ITAddress</a>



<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itaddresscapabilities-get_addresscapability">ITAddressCapabilities::get_AddressCapability</a>
 

 

