---
UID: NE:tapi3if.PHONE_BUTTON_FUNCTION
title: PHONE_BUTTON_FUNCTION (tapi3if.h)
description: The PHONE_BUTTON_FUNCTION enum provides detailed information on a button's function.
old-location: tapi3\phone_button_function.htm
tech.root: Tapi
ms.assetid: 2200b9aa-37fb-483f-9bfa-928348a4bc51
ms.date: 12/05/2018
ms.keywords: PBF_ABBREVDIAL, PBF_BRIDGEDAPP, PBF_BUSY, PBF_CALLAPP, PBF_CALLID, PBF_CAMPON, PBF_CONFERENCE, PBF_CONNECT, PBF_COVER, PBF_DATAOFF, PBF_DATAON, PBF_DATETIME, PBF_DIRECTORY, PBF_DISCONNECT, PBF_DONOTDISTURB, PBF_DROP, PBF_FLASH, PBF_FORWARD, PBF_HOLD, PBF_INTERCOM, PBF_LASTNUM, PBF_MSGINDICATOR, PBF_MSGWAITOFF, PBF_MSGWAITON, PBF_MUTE, PBF_NIGHTSRV, PBF_NONE, PBF_PARK, PBF_PICKUP, PBF_QUEUECALL, PBF_RECALL, PBF_REDIRECT, PBF_REJECT, PBF_REPDIAL, PBF_RINGAGAIN, PBF_SAVEREPEAT, PBF_SELECTRING, PBF_SEND, PBF_SENDCALLS, PBF_SETREPDIAL, PBF_SPEAKEROFF, PBF_SPEAKERON, PBF_STATIONSPEED, PBF_SYSTEMSPEED, PBF_TRANSFER, PBF_UNKNOWN, PBF_VOLUMEDOWN, PBF_VOLUMEUP, PHONE_BUTTON_FUNCTION, PHONE_BUTTON_FUNCTION enumeration [TAPI 2.2], _tapi3_phone_button_function, tapi3.phone_button_function, tapi3if/PBF_ABBREVDIAL, tapi3if/PBF_BRIDGEDAPP, tapi3if/PBF_BUSY, tapi3if/PBF_CALLAPP, tapi3if/PBF_CALLID, tapi3if/PBF_CAMPON, tapi3if/PBF_CONFERENCE, tapi3if/PBF_CONNECT, tapi3if/PBF_COVER, tapi3if/PBF_DATAOFF, tapi3if/PBF_DATAON, tapi3if/PBF_DATETIME, tapi3if/PBF_DIRECTORY, tapi3if/PBF_DISCONNECT, tapi3if/PBF_DONOTDISTURB, tapi3if/PBF_DROP, tapi3if/PBF_FLASH, tapi3if/PBF_FORWARD, tapi3if/PBF_HOLD, tapi3if/PBF_INTERCOM, tapi3if/PBF_LASTNUM, tapi3if/PBF_MSGINDICATOR, tapi3if/PBF_MSGWAITOFF, tapi3if/PBF_MSGWAITON, tapi3if/PBF_MUTE, tapi3if/PBF_NIGHTSRV, tapi3if/PBF_NONE, tapi3if/PBF_PARK, tapi3if/PBF_PICKUP, tapi3if/PBF_QUEUECALL, tapi3if/PBF_RECALL, tapi3if/PBF_REDIRECT, tapi3if/PBF_REJECT, tapi3if/PBF_REPDIAL, tapi3if/PBF_RINGAGAIN, tapi3if/PBF_SAVEREPEAT, tapi3if/PBF_SELECTRING, tapi3if/PBF_SEND, tapi3if/PBF_SENDCALLS, tapi3if/PBF_SETREPDIAL, tapi3if/PBF_SPEAKEROFF, tapi3if/PBF_SPEAKERON, tapi3if/PBF_STATIONSPEED, tapi3if/PBF_SYSTEMSPEED, tapi3if/PBF_TRANSFER, tapi3if/PBF_UNKNOWN, tapi3if/PBF_VOLUMEDOWN, tapi3if/PBF_VOLUMEUP, tapi3if/PHONE_BUTTON_FUNCTION
f1_keywords:
- tapi3if/PHONE_BUTTON_FUNCTION
dev_langs:
- c++
req.header: tapi3if.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Tapi3if.h
api_name:
- PHONE_BUTTON_FUNCTION
targetos: Windows
req.typenames: PHONE_BUTTON_FUNCTION
req.redist: 
ms.custom: 19H1
---

# PHONE_BUTTON_FUNCTION enumeration


## -description


The 
<b>PHONE_BUTTON_FUNCTION</b> enum provides detailed information on a button's function.


## -enum-fields




### -field PBF_UNKNOWN

A "dummy" function assignment that indicates that the exact function of the button is unknown or has not been assigned.


### -field PBF_CONFERENCE

Initiates a conference call or adds a call to a conference call.


### -field PBF_TRANSFER

Initiates a call transfer or completes the transfer of a call.


### -field PBF_DROP

Drops the active call.


### -field PBF_HOLD

Places the active call on hold.


### -field PBF_RECALL

Takes a call off hold.


### -field PBF_DISCONNECT

Disconnects a call, such as after initiating a transfer.


### -field PBF_CONNECT

Reconnects a call that is on consultation hold.


### -field PBF_MSGWAITON

Turns on a message waiting lamp.


### -field PBF_MSGWAITOFF

Turns off a message waiting lamp.


### -field PBF_SELECTRING

Allows the user to select the ring pattern of the phone.


### -field PBF_ABBREVDIAL

Indicates that the number to be dialed will be a short, abbreviated number consisting of one digit or a few digits.


### -field PBF_FORWARD

Initiates or changes call forwarding to this phone.


### -field PBF_PICKUP

Picks up a call ringing on another phone.


### -field PBF_RINGAGAIN

Initiates a request to be notified if a call cannot be completed normally because of a busy signal or no answer.


### -field PBF_PARK

Parks the active call on another phone, placing it on hold there.


### -field PBF_REJECT

Rejects an incoming call before the call has been answered.


### -field PBF_REDIRECT

Redirects an incoming call to another extension before the call has been answered.


### -field PBF_MUTE

Mutes the phone's microphone device.


### -field PBF_VOLUMEUP

Increases the volume of audio through the phone's handset speaker or speakerphone.


### -field PBF_VOLUMEDOWN

Decreases the volume of audio through the phone's handset speaker or speakerphone.


### -field PBF_SPEAKERON

Turns the phone's external speaker on.


### -field PBF_SPEAKEROFF

Turns the phone's external speaker off.


### -field PBF_FLASH

Generates the equivalent of an onhook/offhook sequence. A flash typically indicates that any digits typed next are to be understood as commands to the switch. On many switches, places an active call on consultation hold.


### -field PBF_DATAON

Indicates that the next call is a data call.


### -field PBF_DATAOFF

Indicates that the next call is not a data call.


### -field PBF_DONOTDISTURB

Places the phone in "do not disturb" mode; incoming calls receive a busy signal or are forwarded to an operator or voicemail system.


### -field PBF_INTERCOM

Connects to the intercom to broadcast a page.


### -field PBF_BRIDGEDAPP

Selects a particular appearance of a bridged address.


### -field PBF_BUSY

Makes the phone appear "busy" to incoming calls.


### -field PBF_CALLAPP

Selects a particular call appearance.


### -field PBF_DATETIME

Causes the phone to display the current date and time; this information would be sent by the switch.


### -field PBF_DIRECTORY

Calls up directory service from the switch.


### -field PBF_COVER

Forwards all calls destined for this phone to another phone used for coverage.


### -field PBF_CALLID

Requests display of the caller ID on the phone's display.


### -field PBF_LASTNUM

Redials the last number dialed.


### -field PBF_NIGHTSRV

Places the phone in the mode it is configured for during night hours.


### -field PBF_SENDCALLS

Sends all calls to another phone used for coverage; same as the 
<a href="https://docs.microsoft.com/windows/desktop/Tapi/phonebuttonfunction--constants">PHONEBUTTONFUNCTION_COVER constant</a>.


### -field PBF_MSGINDICATOR

Controls the message indicator lamp.


### -field PBF_REPDIAL

Repertory dialing—the number to be dialed is provided as a shorthand following the pressing of this button.


### -field PBF_SETREPDIAL

Programs the shorthand-to-phone number mappings accessible by means of repertory dialing (the "REPDIAL" button).


### -field PBF_SYSTEMSPEED

The number to be dialed is provided as a shorthand following the pressing of this button. The mappings for system speed dialing are configured inside the switch.


### -field PBF_STATIONSPEED

The number to be dialed is provided as a shorthand following pressing of this button. The mappings for station speed dialing are specific to this station (phone).


### -field PBF_CAMPON

Camps on an extension that returns a busy indication. When the remote station returns to idle, the phone will be rung with a distinctive pattern. Picking up the local phone reinitiates the call.


### -field PBF_SAVEREPEAT

When pressed while a call or call attempt is active, it will remember that call's number or command. When pressed while no call is active (such as during dial tone), it repeats the most recently saved command.


### -field PBF_QUEUECALL

Queues a call to an outside number after it encounters a trunk-busy indication. When a trunk becomes available later, the phone will be rung with a distinctive pattern. Picking up the local phone reinitiates the call.


### -field PBF_NONE

A "dummy" function assignment that indicates that the button does not have a function.


### -field PBF_SEND

Sends a request for a communications session.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itphone-get_buttonfunction">ITPhone::get_ButtonFunction</a>



<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itphone-put_buttonfunction">ITPhone::put_ButtonFunction</a>
 

 

