---
UID: NN:tapi3if.ITPrivateEvent
title: ITPrivateEvent (tapi3if.h)
description: The ITPrivateEvent interface exposes methods that allows an application to process events generated by a private object.
old-location: tapi3\itprivateevent.htm
tech.root: Tapi
ms.assetid: 75a711e4-21b2-40a4-81f0-a210829178b9
ms.date: 12/05/2018
ms.keywords: ITPrivateEvent, ITPrivateEvent interface [TAPI 2.2], ITPrivateEvent interface [TAPI 2.2],described, _tapi3_itprivateevent, tapi3.itprivateevent, tapi3if/ITPrivateEvent
f1_keywords:
- tapi3if/ITPrivateEvent
dev_langs:
- c++
req.header: tapi3if.h
req.include-header: Tapi3.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Uuid.lib
req.dll: Tapi3.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Tapi3.dll
api_name:
- ITPrivateEvent
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ITPrivateEvent interface


## -description


The 
<b>ITPrivateEvent</b> interface exposes methods that allows an application to process events generated by a private object.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">ITPrivateEvent</b> interface inherits from the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/oaidl/nn-oaidl-idispatch">IDispatch</a> interface. <b>ITPrivateEvent</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>ITPrivateEvent</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itprivateevent-get_address">get_Address</a>
</td>
<td align="left" width="63%">
Gets the 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nn-tapi3if-itaddress">ITAddress</a> interface pointer to the private object involved in the event.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itprivateevent-get_call">get_Call</a>
</td>
<td align="left" width="63%">
Gets the 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nn-tapi3if-itcallinfo">ITCallInfo</a> interface pointer to the private object involved in the event.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itprivateevent-get_callhub">get_CallHub</a>
</td>
<td align="left" width="63%">
Gets the 
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nn-tapi3if-itcallhub">ITCallHub</a> interface pointer to the private object involved in the event.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itprivateevent-get_eventcode">get_EventCode</a>
</td>
<td align="left" width="63%">
Gets a provider-specific event descriptor.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/tapi3if/nf-tapi3if-itprivateevent-get_eventinterface">get_EventInterface</a>
</td>
<td align="left" width="63%">
Gets a pointer to the <b>IDispatch</b> interface of the private object's event handler.

</td>
</tr>
</table> 

