---
UID: NF:taskschd.ITaskDefinition.get_XmlText
title: ITaskDefinition::get_XmlText (taskschd.h)
description: Gets or sets the XML-formatted definition of the task.
old-location: taskschd\itaskdefinition_xmltext.htm
tech.root: taskschd
ms.assetid: 1bdafec0-634f-4977-8f41-60dcacc23dec
ms.date: 12/05/2018
ms.keywords: ITaskDefinition interface [Task Scheduler],XmlText property, ITaskDefinition.XmlText, ITaskDefinition.get_XmlText, ITaskDefinition::XmlText, ITaskDefinition::get_XmlText, ITaskDefinition::put_XmlText, XmlText property [Task Scheduler], XmlText property [Task Scheduler],ITaskDefinition interface, get_XmlText, taskschd.itaskdefinition_xmltext, taskschd/ITaskDefinition::XmlText, taskschd/ITaskDefinition::get_XmlText, taskschd/ITaskDefinition::put_XmlText
f1_keywords:
- taskschd/ITaskDefinition.XmlText
dev_langs:
- c++
req.header: taskschd.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Taskschd.lib
req.dll: Taskschd.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- taskschd.dll
api_name:
- ITaskDefinition.XmlText
- ITaskDefinition.get_XmlText
- ITaskDefinition.put_XmlText
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ITaskDefinition::get_XmlText


## -description


Gets or sets the XML-formatted definition of the task.

This property is read/write.


## -parameters


## -remarks



The XML for a task is defined by the <a href="https://docs.microsoft.com/windows/desktop/TaskSchd/task-scheduler-schema">Task Scheduler Schema</a>. For an example of task XML, see <a href="https://docs.microsoft.com/windows/desktop/TaskSchd/daily-trigger-example--xml-">Daily Trigger Example (XML)</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/taskschd/nn-taskschd-itaskdefinition">ITaskDefinition</a>
 

 

