---
UID: NE:textstor.__MIDL_IAnchor_0001
title: TsGravity (textstor.h)
description: Elements of the TsGravity enumeration specify the gravity type associated with an IAnchor object.
old-location: tsf\tsgravity.htm
tech.root: TSF
ms.assetid: 12ec85b9-e65f-485d-8e42-164d2a988356
ms.date: 12/05/2018
ms.keywords: TS_GR_BACKWARD, TS_GR_FORWARD, TsGravity, TsGravity enumeration [Text Services Framework], _tsf_tsgravity_ref, textstor/TS_GR_BACKWARD, textstor/TS_GR_FORWARD, textstor/TsGravity, tsf.tsgravity
f1_keywords:
- textstor/TsGravity
dev_langs:
- c++
req.header: textstor.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Textstor.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Textstor.h
api_name:
- TsGravity
targetos: Windows
req.typenames: TsGravity
req.redist: TSF 1.0 on Windows 2000 Professional
ms.custom: 19H1
---

# TsGravity enumeration


## -description


Elements of the <b>TsGravity</b> enumeration specify the gravity type associated with an <a href="https://docs.microsoft.com/windows/desktop/api/textstor/nn-textstor-ianchor">IAnchor</a> object.


## -enum-fields




### -field TS_GR_BACKWARD

The anchor has backward gravity. For more information about anchor gravity, see <a href="https://docs.microsoft.com/windows/desktop/TSF/ranges">Ranges</a>.


### -field TS_GR_FORWARD

The anchor has forward gravity. For more information about anchor gravity, see <a href="https://docs.microsoft.com/windows/desktop/TSF/ranges">Ranges</a>.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/TSF/ranges">Anchor Gravity</a>



<a href="https://docs.microsoft.com/windows/desktop/api/textstor/nn-textstor-ianchor">IAnchor</a>
 

 

