---
UID: NE:tom.__MIDL___MIDL_itf_tom_0000_0000_0001
title: tomConstants (tom.h)
description: Defines values that are used with the Text Object Model (TOM)&#32;API.
old-location: controls\tomconstants.htm
tech.root: Controls
ms.assetid: 041b0f07-3a7c-4ed9-9d1c-8373eacfb2ec
ms.date: 12/05/2018
ms.keywords: controls.tomconstants, tom/tomAboriginal, tom/tomAdjustCRLF, tom/tomAlignBar, tom/tomAlignCenter, tom/tomAlignDecimal, tom/tomAlignDefault, tom/tomAlignInterLetter, tom/tomAlignInterWord, tom/tomAlignJustify, tom/tomAlignLeft, tom/tomAlignMatchAscentDescent, tom/tomAlignNewspaper, tom/tomAlignRight, tom/tomAlignScaled, tom/tomAllCaps, tom/tomAllowFinalEOP, tom/tomAllowMathBold, tom/tomAllowOffClient, tom/tomAnimationMax, tom/tomAnsi, tom/tomApplyLater, tom/tomApplyNow, tom/tomApplyRtfDocProps, tom/tomApplyTmp, tom/tomArabic, tom/tomArmenian, tom/tomAtEnd, tom/tomAutoBackColor, tom/tomAutoColor, tom/tomAutoLinkEmail, tom/tomAutoLinkPath, tom/tomAutoLinkPhone, tom/tomAutoLinkURL, tom/tomAutoSpaceAlpha, tom/tomAutoSpaceNumeric, tom/tomAutoSpaceParens, tom/tomAutoTextColor, tom/tomBIG5, tom/tomBackward, tom/tomBaltic, tom/tomBengali, tom/tomBlinkingBackground, tom/tomBold, tom/tomBoxAlignCenter, tom/tomBoxHideBottom, tom/tomBoxHideLeft, tom/tomBoxHideRight, tom/tomBoxHideTop, tom/tomBoxStrikeBLTR, tom/tomBoxStrikeH, tom/tomBoxStrikeTLBR, tom/tomBoxStrikeV, tom/tomBraille, tom/tomCacheParms, tom/tomCanCopy, tom/tomCanRedo, tom/tomCanUndo, tom/tomCell, tom/tomCellStructureChangeOnly, tom/tomCharFormat, tom/tomCharRepFromLcid, tom/tomCharRepMax, tom/tomCharacter, tom/tomCharset, tom/tomCheckTextLimit, tom/tomChemicalFormula, tom/tomCherokee, tom/tomClientCoord, tom/tomClientLink, tom/tomCluster, tom/tomCollapseEnd, tom/tomCollapseStart, tom/tomColumn, tom/tomCommentsStory, tom/tomCompressMax, tom/tomCompressNone, tom/tomCompressPunctuation, tom/tomCompressPunctuationAndKana, tom/tomConstants, tom/tomConvertMathChar, tom/tomConvertRTF, tom/tomCreateAlways, tom/tomCreateNew, tom/tomCyrillic, tom/tomDash, tom/tomDashDot, tom/tomDashDotDot, tom/tomDashes, tom/tomDecDecSize, tom/tomDecSize, tom/tomDefault, tom/tomDefaultCharRep, tom/tomDefaultTab, tom/tomDeseret, tom/tomDevanagari, tom/tomDisableSmartFont, tom/tomDisabled, tom/tomDocAutoLink, tom/tomDocMathBuild, tom/tomDontGrowWithContent, tom/tomDots, tom/tomDotted, tom/tomDouble, tom/tomDoubleWave, tom/tomDoublestrike, tom/tomEastEurope, tom/tomEllipsisEnd, tom/tomEllipsisMode, tom/tomEllipsisNone, tom/tomEllipsisPresent, tom/tomEllipsisState, tom/tomEllipsisWord, tom/tomEmbeddedFont, tom/tomEmboss, tom/tomEmoji, tom/tomEnableSmartFont, tom/tomEnd, tom/tomEndnotesStory, tom/tomEqArrayAlignBottomRow, tom/tomEqArrayAlignCenter, tom/tomEqArrayAlignMask, tom/tomEqArrayAlignTopRow, tom/tomEqArrayLayoutWidth, tom/tomEquals, tom/tomEthiopic, tom/tomEvenPagesFooterStory, tom/tomEvenPagesHeaderStory, tom/tomExtend, tom/tomExtendedChar, tom/tomFalse, tom/tomFindStory, tom/tomFirstPageFooterStory, tom/tomFirstPageHeaderStory, tom/tomFoldMathAlpha, tom/tomFontAlignmentAuto, tom/tomFontAlignmentBaseline, tom/tomFontAlignmentBottom, tom/tomFontAlignmentCenter, tom/tomFontAlignmentMax, tom/tomFontAlignmentTop, tom/tomFontBound, tom/tomFontPropAlign, tom/tomFontPropTeXStyle, tom/tomFontStretch, tom/tomFontStretchCondensed, tom/tomFontStretchDefault, tom/tomFontStretchExpanded, tom/tomFontStretchExtraCondensed, tom/tomFontStretchExtraExpanded, tom/tomFontStretchNormal, tom/tomFontStretchSemiCondensed, tom/tomFontStretchSemiExpanded, tom/tomFontStretchUltraCondensed, tom/tomFontStretchUltraExpanded, tom/tomFontStyle, tom/tomFontStyleItalic, tom/tomFontStyleOblique, tom/tomFontStyleUpright, tom/tomFontWeightBlack, tom/tomFontWeightBold, tom/tomFontWeightDefault, tom/tomFontWeightExtraBlack, tom/tomFontWeightExtraBold, tom/tomFontWeightExtraLight, tom/tomFontWeightHeavy, tom/tomFontWeightLight, tom/tomFontWeightMedium, tom/tomFontWeightNormal, tom/tomFontWeightRegular, tom/tomFontWeightSemiBold, tom/tomFontWeightThin, tom/tomFootnotesStory, tom/tomForward, tom/tomFriendlyLinkAddress, tom/tomFriendlyLinkName, tom/tomFunctionTypeIsLim, tom/tomFunctionTypeNone, tom/tomFunctionTypeTakesArg, tom/tomFunctionTypeTakesLim, tom/tomFunctionTypeTakesLim2, tom/tomGB2312, tom/tomGeorgian, tom/tomGetHeightOnly, tom/tomGlagolitic, tom/tomGothic, tom/tomGravityBack, tom/tomGravityFore, tom/tomGravityIn, tom/tomGravityOut, tom/tomGravityUI, tom/tomGreek, tom/tomGrowWithContent, tom/tomGujarati, tom/tomGurmukhi, tom/tomHContCell, tom/tomHStartCell, tom/tomHTML, tom/tomHair, tom/tomHangul, tom/tomHardParagraph, tom/tomHaveDelimiter, tom/tomHeavyWave, tom/tomHebrew, tom/tomHidden, tom/tomHstring, tom/tomIgnoreCurrentFont, tom/tomIgnoreNumberStyle, tom/tomImprint, tom/tomIncIncSize, tom/tomIncSize, tom/tomIncludeInset, tom/tomIncludeNumbering, tom/tomInlineObject, tom/tomInlineObjectArg, tom/tomInlineObjectStart, tom/tomItalic, tom/tomJamo, tom/tomKannada, tom/tomKayahli, tom/tomKharoshthi, tom/tomKhmer, tom/tomKoreanBlockCaret, tom/tomLanguageTag, tom/tomLao, tom/tomLasVegasLights, tom/tomLayoutColumn, tom/tomLeafLine, tom/tomLimbu, tom/tomLimitAlignCenter, tom/tomLimitAlignLeft, tom/tomLimitAlignMask, tom/tomLimitAlignRight, tom/tomLimitsDefault, tom/tomLimitsOpposite, tom/tomLimitsSubSup, tom/tomLimitsUnderOver, tom/tomLine, tom/tomLineSpace1pt5, tom/tomLineSpaceAtLeast, tom/tomLineSpaceDouble, tom/tomLineSpaceExactly, tom/tomLineSpaceMultiple, tom/tomLineSpacePercent, tom/tomLineSpaceSingle, tom/tomLines, tom/tomLink, tom/tomLinkProtected, tom/tomListBullet, tom/tomListMinus, tom/tomListNoNumber, tom/tomListNone, tom/tomListNumberAsArabic, tom/tomListNumberAsLCLetter, tom/tomListNumberAsLCRoman, tom/tomListNumberAsSequence, tom/tomListNumberAsUCLetter, tom/tomListNumberAsUCRoman, tom/tomListNumberedArabic1, tom/tomListNumberedArabic2, tom/tomListNumberedArabicWide, tom/tomListNumberedBlackCircleWingding, tom/tomListNumberedChS, tom/tomListNumberedChT, tom/tomListNumberedCircle, tom/tomListNumberedHebrew, tom/tomListNumberedHindiAlpha, tom/tomListNumberedHindiAlpha1, tom/tomListNumberedHindiNum, tom/tomListNumberedJpnChS, tom/tomListNumberedJpnKor, tom/tomListNumberedThaiAlpha, tom/tomListNumberedThaiNum, tom/tomListNumberedWhiteCircleWingding, tom/tomListParentheses, tom/tomListPeriod, tom/tomListPlain, tom/tomLisu, tom/tomLongDash, tom/tomLowerCase, tom/tomMac, tom/tomMainTextStory, tom/tomMalayalam, tom/tomMarchingBlackAnts, tom/tomMarchingRedAnts, tom/tomMatchAscii, tom/tomMatchCase, tom/tomMatchCharRep, tom/tomMatchFontSignature, tom/tomMatchMathFont, tom/tomMatchPattern, tom/tomMatchWord, tom/tomMathAlignBreakCenter, tom/tomMathAlignBreakLeft, tom/tomMathAlignBreakRight, tom/tomMathAlphabetics, tom/tomMathApplyTemplate, tom/tomMathArabicAlphabetics, tom/tomMathArgShadingEnd, tom/tomMathArgShadingStart, tom/tomMathAutoComplete, tom/tomMathAutoCorrect, tom/tomMathAutoCorrectExt, tom/tomMathAutoCorrectOpPairs, tom/tomMathBackspace, tom/tomMathBreakCenter, tom/tomMathBreakLeft, tom/tomMathBreakRight, tom/tomMathBrkBinAfter, tom/tomMathBrkBinBefore, tom/tomMathBrkBinDup, tom/tomMathBrkBinMask, tom/tomMathBrkBinSubMM, tom/tomMathBrkBinSubMP, tom/tomMathBrkBinSubMask, tom/tomMathBrkBinSubPM, tom/tomMathBuildDown, tom/tomMathBuildDownOutermost, tom/tomMathBuildUpArgOrZone, tom/tomMathBuildUpRecurse, tom/tomMathCFCheck, tom/tomMathChangeMask, tom/tomMathCollapseSel, tom/tomMathDeleteArg, tom/tomMathDeleteArg1, tom/tomMathDeleteArg2, tom/tomMathDeleteCol, tom/tomMathDeleteRow, tom/tomMathDispAlignCenter, tom/tomMathDispAlignCenterGroup, tom/tomMathDispAlignLeft, tom/tomMathDispAlignMask, tom/tomMathDispAlignRight, tom/tomMathDispDef, tom/tomMathDispFracTeX, tom/tomMathDispIntUnderOver, tom/tomMathDispNaryGrow, tom/tomMathDispNarySubSup, tom/tomMathDocDiffDefault, tom/tomMathDocDiffItalic, tom/tomMathDocDiffMask, tom/tomMathDocDiffOpenItalic, tom/tomMathDocDiffUpright, tom/tomMathDocEmptyArgAlways, tom/tomMathDocEmptyArgAuto, tom/tomMathDocEmptyArgMask, tom/tomMathDocEmptyArgNever, tom/tomMathDocSbSpOpUnchanged, tom/tomMathEnableRtl, tom/tomMathEnter, tom/tomMathEqAlign, tom/tomMathInsColAfter, tom/tomMathInsColBefore, tom/tomMathInsRowAfter, tom/tomMathInsRowBefore, tom/tomMathInterSpace, tom/tomMathIntraSpace, tom/tomMathLMargin, tom/tomMathMakeFracLinear, tom/tomMathMakeFracSlashed, tom/tomMathMakeFracStacked, tom/tomMathMakeLeftSubSup, tom/tomMathMakeSubSup, tom/tomMathManualBreakMask, tom/tomMathObjShadingEnd, tom/tomMathObjShadingStart, tom/tomMathParaAlignCenter, tom/tomMathParaAlignCenterGroup, tom/tomMathParaAlignDefault, tom/tomMathParaAlignLeft, tom/tomMathParaAlignRight, tom/tomMathPostSpace, tom/tomMathPreSpace, tom/tomMathRMargin, tom/tomMathRelSize, tom/tomMathRemoveOutermost, tom/tomMathRichEdit, tom/tomMathShiftTab, tom/tomMathSingleChar, tom/tomMathSubscript, tom/tomMathSuperscript, tom/tomMathTab, tom/tomMathVariant, tom/tomMathWrapIndent, tom/tomMathWrapRight, tom/tomMathZone, tom/tomMathZoneDisplay, tom/tomMathZoneNoBuildUp, tom/tomMathZoneOrdinary, tom/tomMatrixAlignBottomRow, tom/tomMatrixAlignCenter, tom/tomMatrixAlignMask, tom/tomMatrixAlignTopRow, tom/tomModWidthPairs, tom/tomModWidthSpace, tom/tomMongolian, tom/tomMove, tom/tomMyanmar, tom/tomNKo, tom/tomNeedTermOp, tom/tomNewTaiLue, tom/tomNoAnimation, tom/tomNoBreak, tom/tomNoHidden, tom/tomNoIME, tom/tomNoLink, tom/tomNoMathZoneBrackets, tom/tomNoSelection, tom/tomNoUCGreekItalic, tom/tomNoUpScroll, tom/tomNoVpScroll, tom/tomNone, tom/tomNormalCaret, tom/tomNullCaret, tom/tomOEM, tom/tomObject, tom/tomObjectArg, tom/tomOgham, tom/tomOpenAlways, tom/tomOpenExisting, tom/tomOriya, tom/tomOsmanya, tom/tomOutline, tom/tomOverlapping, tom/tomPC437, tom/tomPage, tom/tomParaEffectBox, tom/tomParaEffectCollapsed, tom/tomParaEffectDoNotHyphen, tom/tomParaEffectKeep, tom/tomParaEffectKeepNext, tom/tomParaEffectNoLineNumber, tom/tomParaEffectNoWidowControl, tom/tomParaEffectOutlineLevel, tom/tomParaEffectPageBreakBefore, tom/tomParaEffectRTL, tom/tomParaEffectSideBySide, tom/tomParaEffectTable, tom/tomParaEffectTableRowDelimiter, tom/tomParaFormat, tom/tomParaPropMathAlign, tom/tomParaStyleHeading1, tom/tomParaStyleHeading2, tom/tomParaStyleHeading3, tom/tomParaStyleHeading4, tom/tomParaStyleHeading5, tom/tomParaStyleHeading6, tom/tomParaStyleHeading7, tom/tomParaStyleHeading8, tom/tomParaStyleHeading9, tom/tomParaStyleNormal, tom/tomParagraph, tom/tomPasteFile, tom/tomPhagsPa, tom/tomPhantomASmash, tom/tomPhantomDSmash, tom/tomPhantomHSmash, tom/tomPhantomHorz, tom/tomPhantomShow, tom/tomPhantomSmash, tom/tomPhantomTransparent, tom/tomPhantomVert, tom/tomPhantomZeroAscent, tom/tomPhantomZeroDescent, tom/tomPhantomZeroWidth, tom/tomPlain, tom/tomPrimaryFooterStory, tom/tomPrimaryHeaderStory, tom/tomProcessId, tom/tomProtected, tom/tomRE10Mode, tom/tomRTF, tom/tomReadOnly, tom/tomReplaceStory, tom/tomResume, tom/tomRevised, tom/tomRow, tom/tomRowHeightActual, tom/tomRowUpdate, tom/tomRunic, tom/tomScratchStory, tom/tomScreen, tom/tomSection, tom/tomSelActive, tom/tomSelAtEOL, tom/tomSelOvertype, tom/tomSelRange, tom/tomSelReplace, tom/tomSelStartActive, tom/tomSelectionBlock, tom/tomSelectionColumn, tom/tomSelectionFrame, tom/tomSelectionIP, tom/tomSelectionInlineShape, tom/tomSelectionNormal, tom/tomSelectionRow, tom/tomSelectionShape, tom/tomSelfIME, tom/tomSentence, tom/tomSentenceCase, tom/tomShadow, tom/tomShareDenyRead, tom/tomShareDenyWrite, tom/tomShiftJIS, tom/tomShimmer, tom/tomShowDegPlaceHldr, tom/tomShowEmptyArgPlaceholders, tom/tomShowLLimPlaceHldr, tom/tomShowMatPlaceHldr, tom/tomShowULimPlaceHldr, tom/tomSingle, tom/tomSinhala, tom/tomSizeScript, tom/tomSizeScriptScript, tom/tomSizeText, tom/tomSmallCaps, tom/tomSpaceBinary, tom/tomSpaceDefault, tom/tomSpaceDifferential, tom/tomSpaceMask, tom/tomSpaceOrd, tom/tomSpaceRelational, tom/tomSpaceSkip, tom/tomSpaceUnary, tom/tomSpaces, tom/tomSparkleText, tom/tomSpecialChar, tom/tomStart, tom/tomStory, tom/tomStoryActiveDisplay, tom/tomStoryActiveDisplayUI, tom/tomStoryActiveUI, tom/tomStoryInactive, tom/tomStretchBaseAbove, tom/tomStretchBaseBelow, tom/tomStretchCharAbove, tom/tomStretchCharBelow, tom/tomStrikeout, tom/tomStyleDefault, tom/tomStyleDisplay, tom/tomStyleDisplayCramped, tom/tomStyleScript, tom/tomStyleScriptCramped, tom/tomStyleScriptScript, tom/tomStyleScriptScriptCramped, tom/tomStyleText, tom/tomStyleTextCramped, tom/tomSubSupAlign, tom/tomSubscriptCF, tom/tomSuperscriptCF, tom/tomSuspend, tom/tomSylotiNagri, tom/tomSymbol, tom/tomSyriac, tom/tomTabBack, tom/tomTabHere, tom/tomTabNext, tom/tomTable, tom/tomTableColumn, tom/tomTaiLe, tom/tomTamil, tom/tomTeX, tom/tomTelugu, tom/tomText, tom/tomTextFlowES, tom/tomTextFlowMask, tom/tomTextFlowNE, tom/tomTextFlowSW, tom/tomTextFlowWN, tom/tomTextFrameStory, tom/tomTextize, tom/tomThaana, tom/tomThai, tom/tomThick, tom/tomThickDash, tom/tomThickDashDot, tom/tomThickDashDotDot, tom/tomThickDotted, tom/tomThickLines, tom/tomThickLongDash, tom/tomTibetan, tom/tomTifinagh, tom/tomTitleCase, tom/tomToggle, tom/tomToggleCase, tom/tomTrackParms, tom/tomTransform, tom/tomTranslateTableCell, tom/tomTransparentForPositioning, tom/tomTransparentForSpacing, tom/tomTrue, tom/tomTruncateExisting, tom/tomTurkish, tom/tomUndefined, tom/tomUnderline, tom/tomUnderlinePositionAbove, tom/tomUnderlinePositionAuto, tom/tomUnderlinePositionBelow, tom/tomUnderlinePositionMax, tom/tomUndoLimit, tom/tomUnhide, tom/tomUnicodeBiDi, tom/tomUnknownStory, tom/tomUnlink, tom/tomUpperCase, tom/tomUpperLimitAsSuperScript, tom/tomUseAtFont, tom/tomUseCRLF, tom/tomUseOperandPrec, tom/tomUsePoints, tom/tomUseTwips, tom/tomUsymbol, tom/tomVLowCell, tom/tomVTopCell, tom/tomVai, tom/tomVietnamese, tom/tomWave, tom/tomWindow, tom/tomWipeDown, tom/tomWipeRight, tom/tomWord, tom/tomWordDocument, tom/tomWords, tom/tomYi, tomAboriginal, tomAdjustCRLF, tomAlignBar, tomAlignCenter, tomAlignDecimal, tomAlignDefault, tomAlignInterLetter, tomAlignInterWord, tomAlignJustify, tomAlignLeft, tomAlignMatchAscentDescent, tomAlignNewspaper, tomAlignRight, tomAlignScaled, tomAllCaps, tomAllowFinalEOP, tomAllowMathBold, tomAllowOffClient, tomAnimationMax, tomAnsi, tomApplyLater, tomApplyNow, tomApplyRtfDocProps, tomApplyTmp, tomArabic, tomArmenian, tomAtEnd, tomAutoBackColor, tomAutoColor, tomAutoLinkEmail, tomAutoLinkPath, tomAutoLinkPhone, tomAutoLinkURL, tomAutoSpaceAlpha, tomAutoSpaceNumeric, tomAutoSpaceParens, tomAutoTextColor, tomBIG5, tomBackward, tomBaltic, tomBengali, tomBlinkingBackground, tomBold, tomBoxAlignCenter, tomBoxHideBottom, tomBoxHideLeft, tomBoxHideRight, tomBoxHideTop, tomBoxStrikeBLTR, tomBoxStrikeH, tomBoxStrikeTLBR, tomBoxStrikeV, tomBraille, tomCacheParms, tomCanCopy, tomCanRedo, tomCanUndo, tomCell, tomCellStructureChangeOnly, tomCharFormat, tomCharRepFromLcid, tomCharRepMax, tomCharacter, tomCharset, tomCheckTextLimit, tomChemicalFormula, tomCherokee, tomClientCoord, tomClientLink, tomCluster, tomCollapseEnd, tomCollapseStart, tomColumn, tomCommentsStory, tomCompressMax, tomCompressNone, tomCompressPunctuation, tomCompressPunctuationAndKana, tomConstants, tomConstants enumeration [Windows Controls], tomConvertMathChar, tomConvertRTF, tomCreateAlways, tomCreateNew, tomCyrillic, tomDash, tomDashDot, tomDashDotDot, tomDashes, tomDecDecSize, tomDecSize, tomDefault, tomDefaultCharRep, tomDefaultTab, tomDeseret, tomDevanagari, tomDisableSmartFont, tomDisabled, tomDocAutoLink, tomDocMathBuild, tomDontGrowWithContent, tomDots, tomDotted, tomDouble, tomDoubleWave, tomDoublestrike, tomEastEurope, tomEllipsisEnd, tomEllipsisMode, tomEllipsisNone, tomEllipsisPresent, tomEllipsisState, tomEllipsisWord, tomEmbeddedFont, tomEmboss, tomEmoji, tomEnableSmartFont, tomEnd, tomEndnotesStory, tomEqArrayAlignBottomRow, tomEqArrayAlignCenter, tomEqArrayAlignMask, tomEqArrayAlignTopRow, tomEqArrayLayoutWidth, tomEquals, tomEthiopic, tomEvenPagesFooterStory, tomEvenPagesHeaderStory, tomExtend, tomExtendedChar, tomFalse, tomFindStory, tomFirstPageFooterStory, tomFirstPageHeaderStory, tomFoldMathAlpha, tomFontAlignmentAuto, tomFontAlignmentBaseline, tomFontAlignmentBottom, tomFontAlignmentCenter, tomFontAlignmentMax, tomFontAlignmentTop, tomFontBound, tomFontPropAlign, tomFontPropTeXStyle, tomFontStretch, tomFontStretchCondensed, tomFontStretchDefault, tomFontStretchExpanded, tomFontStretchExtraCondensed, tomFontStretchExtraExpanded, tomFontStretchNormal, tomFontStretchSemiCondensed, tomFontStretchSemiExpanded, tomFontStretchUltraCondensed, tomFontStretchUltraExpanded, tomFontStyle, tomFontStyleItalic, tomFontStyleOblique, tomFontStyleUpright, tomFontWeightBlack, tomFontWeightBold, tomFontWeightDefault, tomFontWeightExtraBlack, tomFontWeightExtraBold, tomFontWeightExtraLight, tomFontWeightHeavy, tomFontWeightLight, tomFontWeightMedium, tomFontWeightNormal, tomFontWeightRegular, tomFontWeightSemiBold, tomFontWeightThin, tomFootnotesStory, tomForward, tomFriendlyLinkAddress, tomFriendlyLinkName, tomFunctionTypeIsLim, tomFunctionTypeNone, tomFunctionTypeTakesArg, tomFunctionTypeTakesLim, tomFunctionTypeTakesLim2, tomGB2312, tomGeorgian, tomGetHeightOnly, tomGlagolitic, tomGothic, tomGravityBack, tomGravityFore, tomGravityIn, tomGravityOut, tomGravityUI, tomGreek, tomGrowWithContent, tomGujarati, tomGurmukhi, tomHContCell, tomHStartCell, tomHTML, tomHair, tomHangul, tomHardParagraph, tomHaveDelimiter, tomHeavyWave, tomHebrew, tomHidden, tomHstring, tomIgnoreCurrentFont, tomIgnoreNumberStyle, tomImprint, tomIncIncSize, tomIncSize, tomIncludeInset, tomIncludeNumbering, tomInlineObject, tomInlineObjectArg, tomInlineObjectStart, tomItalic, tomJamo, tomKannada, tomKayahli, tomKharoshthi, tomKhmer, tomKoreanBlockCaret, tomLanguageTag, tomLao, tomLasVegasLights, tomLayoutColumn, tomLeafLine, tomLimbu, tomLimitAlignCenter, tomLimitAlignLeft, tomLimitAlignMask, tomLimitAlignRight, tomLimitsDefault, tomLimitsOpposite, tomLimitsSubSup, tomLimitsUnderOver, tomLine, tomLineSpace1pt5, tomLineSpaceAtLeast, tomLineSpaceDouble, tomLineSpaceExactly, tomLineSpaceMultiple, tomLineSpacePercent, tomLineSpaceSingle, tomLines, tomLink, tomLinkProtected, tomListBullet, tomListMinus, tomListNoNumber, tomListNone, tomListNumberAsArabic, tomListNumberAsLCLetter, tomListNumberAsLCRoman, tomListNumberAsSequence, tomListNumberAsUCLetter, tomListNumberAsUCRoman, tomListNumberedArabic1, tomListNumberedArabic2, tomListNumberedArabicWide, tomListNumberedBlackCircleWingding, tomListNumberedChS, tomListNumberedChT, tomListNumberedCircle, tomListNumberedHebrew, tomListNumberedHindiAlpha, tomListNumberedHindiAlpha1, tomListNumberedHindiNum, tomListNumberedJpnChS, tomListNumberedJpnKor, tomListNumberedThaiAlpha, tomListNumberedThaiNum, tomListNumberedWhiteCircleWingding, tomListParentheses, tomListPeriod, tomListPlain, tomLisu, tomLongDash, tomLowerCase, tomMac, tomMainTextStory, tomMalayalam, tomMarchingBlackAnts, tomMarchingRedAnts, tomMatchAscii, tomMatchCase, tomMatchCharRep, tomMatchFontSignature, tomMatchMathFont, tomMatchPattern, tomMatchWord, tomMathAlignBreakCenter, tomMathAlignBreakLeft, tomMathAlignBreakRight, tomMathAlphabetics, tomMathApplyTemplate, tomMathArabicAlphabetics, tomMathArgShadingEnd, tomMathArgShadingStart, tomMathAutoComplete, tomMathAutoCorrect, tomMathAutoCorrectExt, tomMathAutoCorrectOpPairs, tomMathBackspace, tomMathBreakCenter, tomMathBreakLeft, tomMathBreakRight, tomMathBrkBinAfter, tomMathBrkBinBefore, tomMathBrkBinDup, tomMathBrkBinMask, tomMathBrkBinSubMM, tomMathBrkBinSubMP, tomMathBrkBinSubMask, tomMathBrkBinSubPM, tomMathBuildDown, tomMathBuildDownOutermost, tomMathBuildUpArgOrZone, tomMathBuildUpRecurse, tomMathCFCheck, tomMathChangeMask, tomMathCollapseSel, tomMathDeleteArg, tomMathDeleteArg1, tomMathDeleteArg2, tomMathDeleteCol, tomMathDeleteRow, tomMathDispAlignCenter, tomMathDispAlignCenterGroup, tomMathDispAlignLeft, tomMathDispAlignMask, tomMathDispAlignRight, tomMathDispDef, tomMathDispFracTeX, tomMathDispIntUnderOver, tomMathDispNaryGrow, tomMathDispNarySubSup, tomMathDocDiffDefault, tomMathDocDiffItalic, tomMathDocDiffMask, tomMathDocDiffOpenItalic, tomMathDocDiffUpright, tomMathDocEmptyArgAlways, tomMathDocEmptyArgAuto, tomMathDocEmptyArgMask, tomMathDocEmptyArgNever, tomMathDocSbSpOpUnchanged, tomMathEnableRtl, tomMathEnter, tomMathEqAlign, tomMathInsColAfter, tomMathInsColBefore, tomMathInsRowAfter, tomMathInsRowBefore, tomMathInterSpace, tomMathIntraSpace, tomMathLMargin, tomMathMakeFracLinear, tomMathMakeFracSlashed, tomMathMakeFracStacked, tomMathMakeLeftSubSup, tomMathMakeSubSup, tomMathManualBreakMask, tomMathObjShadingEnd, tomMathObjShadingStart, tomMathParaAlignCenter, tomMathParaAlignCenterGroup, tomMathParaAlignDefault, tomMathParaAlignLeft, tomMathParaAlignRight, tomMathPostSpace, tomMathPreSpace, tomMathRMargin, tomMathRelSize, tomMathRemoveOutermost, tomMathRichEdit, tomMathShiftTab, tomMathSingleChar, tomMathSubscript, tomMathSuperscript, tomMathTab, tomMathVariant, tomMathWrapIndent, tomMathWrapRight, tomMathZone, tomMathZoneDisplay, tomMathZoneNoBuildUp, tomMathZoneOrdinary, tomMatrixAlignBottomRow, tomMatrixAlignCenter, tomMatrixAlignMask, tomMatrixAlignTopRow, tomModWidthPairs, tomModWidthSpace, tomMongolian, tomMove, tomMyanmar, tomNKo, tomNeedTermOp, tomNewTaiLue, tomNoAnimation, tomNoBreak, tomNoHidden, tomNoIME, tomNoLink, tomNoMathZoneBrackets, tomNoSelection, tomNoUCGreekItalic, tomNoUpScroll, tomNoVpScroll, tomNone, tomNormalCaret, tomNullCaret, tomOEM, tomObject, tomObjectArg, tomOgham, tomOpenAlways, tomOpenExisting, tomOriya, tomOsmanya, tomOutline, tomOverlapping, tomPC437, tomPage, tomParaEffectBox, tomParaEffectCollapsed, tomParaEffectDoNotHyphen, tomParaEffectKeep, tomParaEffectKeepNext, tomParaEffectNoLineNumber, tomParaEffectNoWidowControl, tomParaEffectOutlineLevel, tomParaEffectPageBreakBefore, tomParaEffectRTL, tomParaEffectSideBySide, tomParaEffectTable, tomParaEffectTableRowDelimiter, tomParaFormat, tomParaPropMathAlign, tomParaStyleHeading1, tomParaStyleHeading2, tomParaStyleHeading3, tomParaStyleHeading4, tomParaStyleHeading5, tomParaStyleHeading6, tomParaStyleHeading7, tomParaStyleHeading8, tomParaStyleHeading9, tomParaStyleNormal, tomParagraph, tomPasteFile, tomPhagsPa, tomPhantomASmash, tomPhantomDSmash, tomPhantomHSmash, tomPhantomHorz, tomPhantomShow, tomPhantomSmash, tomPhantomTransparent, tomPhantomVert, tomPhantomZeroAscent, tomPhantomZeroDescent, tomPhantomZeroWidth, tomPlain, tomPrimaryFooterStory, tomPrimaryHeaderStory, tomProcessId, tomProtected, tomRE10Mode, tomRTF, tomReadOnly, tomReplaceStory, tomResume, tomRevised, tomRow, tomRowHeightActual, tomRowUpdate, tomRunic, tomScratchStory, tomScreen, tomSection, tomSelActive, tomSelAtEOL, tomSelOvertype, tomSelRange, tomSelReplace, tomSelStartActive, tomSelectionBlock, tomSelectionColumn, tomSelectionFrame, tomSelectionIP, tomSelectionInlineShape, tomSelectionNormal, tomSelectionRow, tomSelectionShape, tomSelfIME, tomSentence, tomSentenceCase, tomShadow, tomShareDenyRead, tomShareDenyWrite, tomShiftJIS, tomShimmer, tomShowDegPlaceHldr, tomShowEmptyArgPlaceholders, tomShowLLimPlaceHldr, tomShowMatPlaceHldr, tomShowULimPlaceHldr, tomSingle, tomSinhala, tomSizeScript, tomSizeScriptScript, tomSizeText, tomSmallCaps, tomSpaceBinary, tomSpaceDefault, tomSpaceDifferential, tomSpaceMask, tomSpaceOrd, tomSpaceRelational, tomSpaceSkip, tomSpaceUnary, tomSpaces, tomSparkleText, tomSpecialChar, tomStart, tomStory, tomStoryActiveDisplay, tomStoryActiveDisplayUI, tomStoryActiveUI, tomStoryInactive, tomStretchBaseAbove, tomStretchBaseBelow, tomStretchCharAbove, tomStretchCharBelow, tomStrikeout, tomStyleDefault, tomStyleDisplay, tomStyleDisplayCramped, tomStyleScript, tomStyleScriptCramped, tomStyleScriptScript, tomStyleScriptScriptCramped, tomStyleText, tomStyleTextCramped, tomSubSupAlign, tomSubscriptCF, tomSuperscriptCF, tomSuspend, tomSylotiNagri, tomSymbol, tomSyriac, tomTabBack, tomTabHere, tomTabNext, tomTable, tomTableColumn, tomTaiLe, tomTamil, tomTeX, tomTelugu, tomText, tomTextFlowES, tomTextFlowMask, tomTextFlowNE, tomTextFlowSW, tomTextFlowWN, tomTextFrameStory, tomTextize, tomThaana, tomThai, tomThick, tomThickDash, tomThickDashDot, tomThickDashDotDot, tomThickDotted, tomThickLines, tomThickLongDash, tomTibetan, tomTifinagh, tomTitleCase, tomToggle, tomToggleCase, tomTrackParms, tomTransform, tomTranslateTableCell, tomTransparentForPositioning, tomTransparentForSpacing, tomTrue, tomTruncateExisting, tomTurkish, tomUndefined, tomUnderline, tomUnderlinePositionAbove, tomUnderlinePositionAuto, tomUnderlinePositionBelow, tomUnderlinePositionMax, tomUndoLimit, tomUnhide, tomUnicodeBiDi, tomUnknownStory, tomUnlink, tomUpperCase, tomUpperLimitAsSuperScript, tomUseAtFont, tomUseCRLF, tomUseOperandPrec, tomUsePoints, tomUseTwips, tomUsymbol, tomVLowCell, tomVTopCell, tomVai, tomVietnamese, tomWave, tomWindow, tomWipeDown, tomWipeRight, tomWord, tomWordDocument, tomWords, tomYi
f1_keywords:
- tom/tomConstants
dev_langs:
- c++
req.header: tom.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Tom.h
api_name:
- tomConstants
targetos: Windows
req.typenames: tomConstants
req.redist: 
ms.custom: 19H1
---

# tomConstants enumeration


## -description


Defines values that are used with the Text Object Model (TOM) API.


## -enum-fields




### -field tomFalse

A <a href="https://docs.microsoft.com/windows/desktop/Controls/about-text-object-model">tomBool</a> value that indicates false.


### -field tomTrue

A <a href="https://docs.microsoft.com/windows/desktop/Controls/about-text-object-model">tomBool</a> value that indicates true.


### -field tomUndefined

A <a href="https://docs.microsoft.com/windows/desktop/Controls/about-text-object-model">tomBool</a> value that indicates a no-input, no-change value that works with <b>long</b>, <b>float</b>, and <a href="https://docs.microsoft.com/windows/desktop/gdi/colorref">COLORREF</a> parameters. For strings, <b>tomUndefined</b> (or NINCH) is represented by the null string. For Set operations, using <b>tomUndefined</b> does not change the target property. For Get operations, <b>tomUndefined</b> means that the characters in the range have different values (it gives the grayed check box in property dialog boxes).


### -field tomToggle

A <a href="https://docs.microsoft.com/windows/desktop/Controls/about-text-object-model">tomBool</a> value that toggles the state of a property.


### -field tomAutoColor

Allow the rich edit control to select the appropriate color.


### -field tomDefault

Set to the document default format for objects that are attached to a range, or to the basic TOM engine default for objects that are not attached to a range.


### -field tomSuspend

Suspend an operation.


### -field tomResume

Resume an operation.


### -field tomApplyNow

Apply the current properties to the attached range.


### -field tomApplyLater

Allow setting property definitions, but don’t apply them to a range yet.


### -field tomTrackParms

Update the current font with the attached range properties.


### -field tomCacheParms

Don’t update the current font with the attached range properties.


### -field tomApplyTmp

Apply temporary formatting.


### -field tomDisableSmartFont

Do not apply smart fonts.


### -field tomEnableSmartFont

Do apply smart fonts.


### -field tomUsePoints

Use points for floating-point measurements.


### -field tomUseTwips

Use twips for floating-point measurements.


### -field tomBackward

Move backward toward the start of a story.


### -field tomForward

Move foreward toward the end of a story.


### -field tomMove

Collapse the selection or range to an insertion point and then move the insertion point.


### -field tomExtend

Extend a selection or range by moving one of the endpoints.


### -field tomNoSelection

There is no selection and no insertion point.


### -field tomSelectionIP

The selection insertion point.


### -field tomSelectionNormal

The selection is a single, nondegenerate text range.


### -field tomSelectionFrame

A frame is selected.


### -field tomSelectionColumn

One or more table columns is selected.


### -field tomSelectionRow

 One or more table rows is selected.


### -field tomSelectionBlock

A block is selected.


### -field tomSelectionInlineShape

The selection is a picture.


### -field tomSelectionShape

A shape is selected.


### -field tomSelStartActive

The starting position of the selection is active.


### -field tomSelAtEOL

For degenerate selections, the ambiguous character position corresponding to both the beginning of a line and the end of the preceding line should have the caret displayed at the end of the preceding line.


### -field tomSelOvertype

Insert/overtype mode is set to overtype. 


### -field tomSelActive

Selection is active.


### -field tomSelReplace

Typing and pasting replaces the selection.


### -field tomEnd

The end of a text range.


### -field tomStart

The start of range.


### -field tomCollapseEnd

Collapse to the end position of a range or selection.


### -field tomCollapseStart

Collapse to the start position of a range or selection.


### -field tomClientCoord

Use client coordinates instead of screen coordinates.


### -field tomAllowOffClient

Allow points outside of the client area.


### -field tomTransform

Transform coordinates using a world transform (XFORM) supplied by the host application.


### -field tomObjectArg

Get  a point inside an inline object argument; for example, inside the numerator of a fraction.


### -field tomAtEnd

The end of the specified unit.


### -field tomNone

No underlining.


### -field tomSingle

Single underline.


### -field tomWords

Underline words only.


### -field tomDouble

Double underline.


### -field tomDotted

Dotted underline.


### -field tomDash

Dash underline.


### -field tomDashDot

Dash dot underline.


### -field tomDashDotDot

Dash dot dot underline.


### -field tomWave

Wave underline.


### -field tomThick

Thick underline.


### -field tomHair

Hair underline.


### -field tomDoubleWave

Double wave underline.


### -field tomHeavyWave

Heavy wave underline.


### -field tomLongDash

Long dash underline.


### -field tomThickDash

Thick dash underline.


### -field tomThickDashDot

Thick dash dot underline.


### -field tomThickDashDotDot

Thick dash dot dot underline.


### -field tomThickDotted

Thick dotted underline.


### -field tomThickLongDash

Thick long dash underline.


### -field tomLineSpaceSingle

Single space. The line-spacing value is ignored.


### -field tomLineSpace1pt5

One-and-a-half line spacing. The line-spacing value is ignored.


### -field tomLineSpaceDouble

Double line spacing. The line-spacing value is ignored.


### -field tomLineSpaceAtLeast

The line-spacing value specifies the spacing from one line to the next. However, if the value is less than single spacing, text is single-spaced.


### -field tomLineSpaceExactly

The line-spacing value specifies the exact spacing from one line to the next, even if the value is less than single spacing.


### -field tomLineSpaceMultiple

The line-spacing value specifies the line spacing, in lines.


### -field tomLineSpacePercent

The line-spacing value specifies the line spacing by percent of line height.


### -field tomAlignLeft

Text aligns with the left margin.


### -field tomAlignCenter

Text is centered between the margins.


### -field tomAlignRight

Text aligns with the right margin.


### -field tomAlignJustify

Text starts at the left margin and, if the line extends beyond the right margin, all the spaces in the line are adjusted to be even. 


### -field tomAlignDecimal

The decimal point is set at the tab position. This is useful for aligning a column of decimal numbers.



### -field tomAlignBar

A vertical bar is positioned at the tab position. Text is not affected. Alignment bars on nearby lines at the same position form a continuous vertical line.



### -field tomDefaultTab

Position at a default tab stop.


### -field tomAlignInterWord

Same as  <b>tomAlignJustify</b>.


### -field tomAlignNewspaper

Same as <b>tomAlignInterLetter</b>, but uses East Asian metrics.


### -field tomAlignInterLetter

The first and last characters of each line (except the last line) are aligned to the left and right margins, and lines are filled by adding or subtracting the same amount from each character.


### -field tomAlignScaled

Same as <b>tomAlignInterLetter</b>, but uses East Asian metrics, and scales the spacing by the width of characters.


### -field tomSpaces

Use spaces to fill the spaces taken by a tab character.


### -field tomDots

Use dots to fill the spaces taken by a tab character.


### -field tomDashes

Use dashes to fill the spaces taken by a tab character.


### -field tomLines

Use solid lines to fill the spaces taken by a tab character.


### -field tomThickLines

Use thick solid lines to fill the spaces taken by a tab character.


### -field tomEquals

Use equal signs to fill the spaces taken by a tab character.


### -field tomTabBack

The tab preceding the specified location.


### -field tomTabNext

The next tab following the specified location.


### -field tomTabHere

The tab at the specified location.


### -field tomListNone

Not a list paragraph.


### -field tomListBullet

List uses bullets (0x2022); other bullets are given by &gt; 32.


### -field tomListNumberAsArabic

List is numbered with Arabic numerals (0, 1, 2, ...).


### -field tomListNumberAsLCLetter

List is ordered with lowercase letters (a, b, c, ...).


### -field tomListNumberAsUCLetter

List is ordered with uppercase Arabic letters (A, B, C, ...).


### -field tomListNumberAsLCRoman

List is ordered with lowercase Roman letters (i, ii, iii, ...).


### -field tomListNumberAsUCRoman

List is ordered with uppercase Roman letters (I, II, III, ...).


### -field tomListNumberAsSequence

The value returned by <a href="https://docs.microsoft.com/windows/desktop/api/tom/nf-tom-itextpara-getliststart">ITextPara::GetListStart</a> is treated as the first code in a Unicode sequence.


### -field tomListNumberedCircle

List is ordered with Unicode circled numbers 

<img alt="Unicode numbers in a circle." src="images/unicodecirclednumbers.png"/>

### -field tomListNumberedBlackCircleWingding

List is ordered with Wingdings black circled digits 

<img alt="Circled black digits." src="images/wingdingblackcircleddigits.png"/>

### -field tomListNumberedWhiteCircleWingding

List is ordered with Wingdings white circled digits:

<img alt="White digits in a black circle." src="images/wingdingwhitecircleddigits.png"/>

### -field tomListNumberedArabicWide

Full-width ASCII (０, １, ２, ３, …).


### -field tomListNumberedChS

Chinese with 十 only in items 10 through 99 (一, 二, 三, 四…).


### -field tomListNumberedChT

Chinese with 十 only in items 10 through 19.


### -field tomListNumberedJpnChS

Chinese with a full-width period, no 十.


### -field tomListNumberedJpnKor

Chinese with no 十.


### -field tomListNumberedArabic1

Arabic alphabetic ( أ ,ب ,ت ,ث ,…).


### -field tomListNumberedArabic2

Arabic abjadi ( أ ,ب ,ج ,د ,…).


### -field tomListNumberedHebrew

Hebrew alphabet (א, ב, ג, ד, …).


### -field tomListNumberedThaiAlpha

Thai alphabetic (ก, ข,ค, ง, …).


### -field tomListNumberedThaiNum

Thai numbers (๑, ๒,๓, ๔…).


### -field tomListNumberedHindiAlpha

Hindi vowels (अ, आ, इ, ई, …).


### -field tomListNumberedHindiAlpha1

Hindi consonants (क, ख, ग, घ, …).


### -field tomListNumberedHindiNum

Hindi numbers (१, २, ३, ४, …).


### -field tomListParentheses

Encloses the number in parentheses, as in: (1).


### -field tomListPeriod

Follows the number with a period.


### -field tomListPlain

Uses the number alone.


### -field tomListNoNumber

Uses no numbers.


### -field tomListMinus

Follows the number with a hyphen (-).


### -field tomIgnoreNumberStyle

Suppress the numbering style for list items. 


### -field tomParaStyleNormal

The normal paragraph style.


### -field tomParaStyleHeading1

The style for level 1 paragraph headings.


### -field tomParaStyleHeading2

The style for level 2 paragraph headings.


### -field tomParaStyleHeading3

The style for level 3 paragraph headings.


### -field tomParaStyleHeading4

The style for level 4 paragraph headings.


### -field tomParaStyleHeading5

The style for level 5 paragraph headings.


### -field tomParaStyleHeading6

The style for level 6 paragraph headings.


### -field tomParaStyleHeading7

The style for level 7 paragraph headings.


### -field tomParaStyleHeading8

The style for level 8 paragraph headings.


### -field tomParaStyleHeading9

The style for level 9 paragraph headings.


### -field tomCharacter

The unit is a single character.


### -field tomWord

The unit is a word.


### -field tomSentence

The unit is a sentence.


### -field tomParagraph

The unit is a paragraph.


### -field tomLine

The unit is a line.


### -field tomStory

The unit is a story; that is, a contiguous range of text that represent a part of a document, such as the main text of the document, headers and footers, footnotes, annotations, and so on.


### -field tomScreen

The unit is a screenful.


### -field tomSection

The unit is a section.


### -field tomTableColumn

The unit is a table column.


### -field tomColumn

The unit is a text column.


### -field tomRow

The unit is a table row


### -field tomWindow

The unit is a window. 


### -field tomCell

The unit is a spreadsheet cell.


### -field tomCharFormat

The unit is a run of constant character formatting.


### -field tomParaFormat

The unit is a run of constant paragraph formatting.


### -field tomTable

The unit is a table.


### -field tomObject

The unit is an embedded object.


### -field tomPage

The unit is a page.


### -field tomHardParagraph

The unit is a hard paragraph. 


### -field tomCluster

The unit is a cluster of characters. 


### -field tomInlineObject

The unit is an inline object.


### -field tomInlineObjectArg

The unit is an inline object argument.  



### -field tomLeafLine

The unit is a leaf-level line. 


### -field tomLayoutColumn

A layout column.


### -field tomProcessId

The identifier of the current process.


### -field tomMatchWord

Match on whole words when doing a text search.


### -field tomMatchCase

A case-sensitive a text search.


### -field tomMatchPattern

Match regular expressions when doing a text search.


### -field tomUnknownStory

No special type.


### -field tomMainTextStory

The main story always exists for a rich edit control.


### -field tomFootnotesStory

The story used for footnotes.


### -field tomEndnotesStory

The story used for endnotes.


### -field tomCommentsStory

The story used for comments.


### -field tomTextFrameStory

The story used for a text box.


### -field tomEvenPagesHeaderStory

The story containing headers for even pages.


### -field tomPrimaryHeaderStory

The story containing headers for odd pages.


### -field tomEvenPagesFooterStory

The story containing footers for even pages.


### -field tomPrimaryFooterStory

The story containing footers for odd pages.


### -field tomFirstPageHeaderStory

The story containing the header for the first page.


### -field tomFirstPageFooterStory

The story containing the footer for the first page.


### -field tomScratchStory

The scratch story.


### -field tomFindStory

The story used for a Find dialog.


### -field tomReplaceStory

The story used for a Replace dialog.


### -field tomStoryInactive

Story is inactive.


### -field tomStoryActiveDisplay

Story has display, but no UI.


### -field tomStoryActiveUI

Story is UI active; that is, it receives keyboard and mouse input.


### -field tomStoryActiveDisplayUI

Story has display and UI activity.


### -field tomNoAnimation

Do not apply text animation.


### -field tomLasVegasLights

Text is bordered by marquee lights that blink between the colors red, yellow, green, and blue.


### -field tomBlinkingBackground

Text has a black background that blinks on and off.


### -field tomSparkleText

Text is overlaid with multicolored stars that blink on and off at regular intervals


### -field tomMarchingBlackAnts

Text is surrounded by a black dashed-line border. The border is animated so that the individual dashes appear to move clockwise around the text.


### -field tomMarchingRedAnts

Text is surrounded by a red dashed-line border that is animated to appear to move clockwise around the text.


### -field tomShimmer

Text is alternately blurred and unblurred at regular intervals, to give the appearance of shimmering.


### -field tomWipeDown

Text appears gradually from the top down.


### -field tomWipeRight

Text appears gradually from the bottom up.


### -field tomAnimationMax

Defines the maximum animation flag value. 


### -field tomLowerCase

Set text to lowercase.


### -field tomUpperCase

Set text to uppercase.


### -field tomTitleCase

Capitalize the first letter of each word.


### -field tomSentenceCase

Capitalize the first letter of each sentence.


### -field tomToggleCase

Toggle the case of each letter.


### -field tomReadOnly

Read only.


### -field tomShareDenyRead

Other programs cannot read.


### -field tomShareDenyWrite

Other programs cannot write.


### -field tomPasteFile

Replace the selection with a file.


### -field tomCreateNew

Create a new file. Fail if the file already exists.


### -field tomCreateAlways

Create a new file. Destroy the existing file if it exists.


### -field tomOpenExisting

Open an existing file. Fail if the file does not exist.


### -field tomOpenAlways

Open an existing file. Create a new file if the file does not exist.


### -field tomTruncateExisting

Open an existing file, but truncate it to zero length.


### -field tomRTF

Open as  RTF.


### -field tomText

Open as text ANSI or Unicode.


### -field tomHTML

Open as HTML.


### -field tomWordDocument

Open as Word document.


### -field tomBold

Boldface.


### -field tomItalic

Italic.


### -field tomUnderline

Underline.


### -field tomStrikeout

Strikeout.


### -field tomProtected

Protected.


### -field tomLink

Hyperlink.


### -field tomSmallCaps

Small caps.


### -field tomAllCaps

All caps.


### -field tomHidden

Hidden.


### -field tomOutline

Outline.


### -field tomShadow

Shadow.


### -field tomEmboss

Emboss.


### -field tomImprint

Imprint.


### -field tomDisabled

Disabled.


### -field tomRevised

Revised.


### -field tomSubscriptCF

Subscript character format.


### -field tomSuperscriptCF

Superscript character format.


### -field tomFontBound

Font bound (uses font binding).


### -field tomLinkProtected

The link is protected (friendly name link).


### -field tomInlineObjectStart

The start delimiter of an inline object.


### -field tomExtendedChar

The characters are less common members of a script. A font that supports a script should check if it has glyphs for such characters.


### -field tomAutoBackColor

Use system back color.


### -field tomMathZoneNoBuildUp

Don't build up operator.


### -field tomMathZone

Math zone.


### -field tomMathZoneOrdinary

Math zone ordinary text.


### -field tomAutoTextColor

Use system text color.


### -field tomMathZoneDisplay

Display math zone.


### -field tomParaEffectRTL

Right-to-left paragraph


### -field tomParaEffectKeep

Keep the paragraph together.


### -field tomParaEffectKeepNext

Keep with next the paragraph.


### -field tomParaEffectPageBreakBefore

Put a page break before this paragraph.


### -field tomParaEffectNoLineNumber

No line number for this paragraph.


### -field tomParaEffectNoWidowControl

No widow control.


### -field tomParaEffectDoNotHyphen

Don't hyphenate this paragraph.


### -field tomParaEffectSideBySide

Side by side.


### -field tomParaEffectCollapsed

 Heading contents are collapsed (in outline view). 



### -field tomParaEffectOutlineLevel

Outline view nested level.


### -field tomParaEffectBox

Paragraph has boxed effect (is not displayed).


### -field tomParaEffectTableRowDelimiter

At or inside table delimiter.


### -field tomParaEffectTable

Inside or at the start of a table.


### -field tomModWidthPairs

Use East Asian character-pair-width modification.


### -field tomModWidthSpace

Use East Asian space-width modification.


### -field tomAutoSpaceAlpha

Use East Asian auto spacing between alphabetics.


### -field tomAutoSpaceNumeric

Use East Asian auto spacing for digits.


### -field tomAutoSpaceParens

Use East Asian automatic spacing for parentheses or brackets.


### -field tomEmbeddedFont

Embedded font (CLIP_EMBEDDED).


### -field tomDoublestrike

Double strikeout.


### -field tomOverlapping

Run has overlapping text.


### -field tomNormalCaret

Normal caret.


### -field tomKoreanBlockCaret

The Korean block caret.


### -field tomNullCaret

NULL caret (caret suppressed).


### -field tomIncludeInset

Add left/top insets to the client rectangle, and subtract right/bottom insets from the client rectangle. 


### -field tomUnicodeBiDi

Use the Unicode bidirectional (bidi) algorithm.


### -field tomMathCFCheck

Check math-zone character formatting.


### -field tomUnlink

Don't include text as part of a hyperlink.


### -field tomUnhide

Don't insert as hidden text.


### -field tomCheckTextLimit

Obey the current text limit instead of increasing the text to fit.


### -field tomIgnoreCurrentFont

Ignore the font that is active at a particular character position.


### -field tomMatchCharRep

Match the current character repertoire. 


### -field tomMatchFontSignature

Match the current font signature.


### -field tomMatchAscii

Use the current font if its character repertoire is <b>tomAnsi</b>.


### -field tomGetHeightOnly

Gets the height.


### -field tomMatchMathFont

Match a math font.


### -field tomCharset

Set the character repertoire based on the specified character set.


### -field tomCharRepFromLcid

Set the character repertoire based on the specified LCID.


### -field tomAnsi

Latin 1


### -field tomEastEurope

From Latin 1 and 2


### -field tomCyrillic

Cyrillic


### -field tomGreek

Greek


### -field tomTurkish

Turkish (Latin 1 + dotless i, ...)


### -field tomHebrew

Hebrew


### -field tomArabic

Arabic


### -field tomBaltic

From Latin 1 and 2


### -field tomVietnamese

Latin 1 with some combining marks


### -field tomDefaultCharRep

Default character repertoire


### -field tomSymbol

Symbol character set (not Unicode)


### -field tomThai

Thai


### -field tomShiftJIS

Japanese


### -field tomGB2312

Simplified Chinese


### -field tomHangul

Hangul


### -field tomBIG5

Traditional Chinese


### -field tomPC437

PC437 character set (DOS)


### -field tomOEM

OEM character set (original PC)


### -field tomMac

Main Macintosh character repertoire


### -field tomArmenian

Armenian


### -field tomSyriac

Syriac


### -field tomThaana

Thaana


### -field tomDevanagari

Devanagari


### -field tomBengali

Bangla (formerly Bengali)


### -field tomGurmukhi

Gurmukhi


### -field tomGujarati

Gujarati


### -field tomOriya

Odia (formerly Oriya)


### -field tomTamil

Tamil


### -field tomTelugu

Telugu


### -field tomKannada

Kannada


### -field tomMalayalam

Malayalam


### -field tomSinhala

Sinhala


### -field tomLao

Lao


### -field tomTibetan

Tibetan


### -field tomMyanmar

Myanmar


### -field tomGeorgian

Georgian


### -field tomJamo

Jamo


### -field tomEthiopic

Ethiopic


### -field tomCherokee

Cherokee


### -field tomAboriginal

Aboriginal


### -field tomOgham

Ogham


### -field tomRunic

Runic


### -field tomKhmer

Khmer


### -field tomMongolian

Mongolian


### -field tomBraille

Braille


### -field tomYi

Yi


### -field tomLimbu

Limbu


### -field tomTaiLe

TaiLe


### -field tomNewTaiLue

TaiLue


### -field tomSylotiNagri

Syloti Nagri


### -field tomKharoshthi

Kharoshthi


### -field tomKayahli

Kayah Li


### -field tomUsymbol

Unicode symbol


### -field tomEmoji

Emoji


### -field tomGlagolitic

Glagolitic


### -field tomLisu

Lisu


### -field tomVai

Vai


### -field tomNKo

N'Ko


### -field tomOsmanya

Osmanya


### -field tomPhagsPa

Phags-pa 


### -field tomGothic

Gothic


### -field tomDeseret

Deseret


### -field tomTifinagh

Tifinagh


### -field tomCharRepMax

The maximum character repertoire flag value.


### -field tomRE10Mode

Use Microsoft Rich Edit 1.0 mode.


### -field tomUseAtFont

Use a font with a name that starts with @,  for CJK vertical text. When rendered vertically, the characters in such a font are rotated 90 degrees so that they look upright instead of sideways.


### -field tomTextFlowMask

Mask for the following four text orientations.


### -field tomTextFlowES

Ordinary left-to-right horizontal text.


### -field tomTextFlowSW

Ordinary East Asian vertical text.


### -field tomTextFlowWN

Alternative orientation.


### -field tomTextFlowNE

Alternative orientation.


### -field tomNoIME

Disables the IME operation (see <a href="https://docs.microsoft.com/windows/desktop/Controls/rich-edit-control-styles">ES_NOIME</a>).


### -field tomSelfIME

Directs the rich edit control to allow the application to handle all IME operations (see <a href="https://docs.microsoft.com/windows/desktop/Controls/rich-edit-control-styles">ES_SELFIME</a>).


### -field tomNoUpScroll

Horizontal scrolling is disabled.


### -field tomNoVpScroll

Vertical scrolling is disabled.


### -field tomNoLink

Not a link.


### -field tomClientLink

The URL only; that is, no friendly name.


### -field tomFriendlyLinkName

The name of friendly name link.


### -field tomFriendlyLinkAddress

The URL of a friendly name link.


### -field tomAutoLinkURL

The URL of an automatic link.


### -field tomAutoLinkEmail

An automatic link to an email address.


### -field tomAutoLinkPhone

An automatic link to a phone number.


### -field tomAutoLinkPath

An automatic link to a storage location.


### -field tomCompressNone

No compression.


### -field tomCompressPunctuation

Compress punctuation.


### -field tomCompressPunctuationAndKana

Compress punctuation and kana.


### -field tomCompressMax

The maximum compression flag value.


### -field tomUnderlinePositionAuto

Automatically set the underline position.


### -field tomUnderlinePositionBelow

Render underline below text.


### -field tomUnderlinePositionAbove

Render underline above text.


### -field tomUnderlinePositionMax

The maximum underline position flag value.


### -field tomFontAlignmentAuto

For horizontal layout, align CJK characters on the baseline. For vertical layout, center align CJK characters. 


### -field tomFontAlignmentTop

For horizontal layout, top align CJK characters. For vertical layout, right align CJK characters. 


### -field tomFontAlignmentBaseline

For horizontal or vertical layout, align CJK characters on the baseline.


### -field tomFontAlignmentBottom

For horizontal layout, bottom align CJK characters. For vertical layout, left align CJK characters.


### -field tomFontAlignmentCenter

For horizontal layout, center CJK characters vertically. For vertical layout, center align CJK characters horizontally.


### -field tomFontAlignmentMax

The maximum font alignment flag value.


### -field tomRubyBelow


### -field tomRubyAlignCenter


### -field tomRubyAlign010


### -field tomRubyAlign121


### -field tomRubyAlignLeft


### -field tomRubyAlignRight


### -field tomLimitsDefault

Limit locations use document default.


### -field tomLimitsUnderOver

Limits are placed under and over the operator.


### -field tomLimitsSubSup

Limits are operator subscript and superscript.


### -field tomUpperLimitAsSuperScript

The upper limit is a superscript.


### -field tomLimitsOpposite

Switch between <b>tomLimitsSubSup</b> and <b>tomLimitsUnderOver</b>.


### -field tomShowLLimPlaceHldr

Show empty lower limit placeholder.


### -field tomShowULimPlaceHldr

Show empty upper limit placeholder.


### -field tomDontGrowWithContent

Don't grow the <i>n</i>-ary operator with the argument.


### -field tomGrowWithContent

Grow the <i>n</i>-ary operator with the argument.


### -field tomSubSupAlign

Align subscript under superscript.


### -field tomLimitAlignMask

Mask for <b>tomLimitAlignCenter</b>, <b>tomLimitAlignLeft</b>, and <b>tomLimitAlignRight.</b>


### -field tomLimitAlignCenter

Center limit under base.


### -field tomLimitAlignLeft

Align left ends of limit and base.


### -field tomLimitAlignRight

Align right ends of limit and base.


### -field tomShowDegPlaceHldr

Show empty radical degree placeholder.


### -field tomAlignDefault

Center brackets at baseline.


### -field tomAlignMatchAscentDescent

Use brackets that match the argument ascent and descent.


### -field tomMathVariant

Bits 7, 6 can have TeX variant enumeration values:


### -field tomStyleDefault

The math handler determines the style.


### -field tomStyleScriptScriptCramped

The 2<sup>nd</sup> and higher level subscript superscript size, cramped.


### -field tomStyleScriptScript

The 2<sup>nd</sup> and higher level subscript superscript size.


### -field tomStyleScriptCramped

The 1<sup>st</sup> level subscript superscript size, cramped.


### -field tomStyleScript

The 1<sup>st</sup> level subscript superscript size.


### -field tomStyleTextCramped

Text size cramped, for example, inside a square root.


### -field tomStyleText

The standard inline text size.


### -field tomStyleDisplayCramped

Display style cramped.


### -field tomStyleDisplay

Display style.


### -field tomMathRelSize

Indicates one of these is active: <b>tomDecDecSize</b>, <b>tomDecSize</b>, <b>tomIncSize</b>, <b>tomIncIncSize</b>. Note that the maximum size is <b>tomStyleText</b> size, and the minimum size is <b>tomStyleScriptScript</b> size.


### -field tomDecDecSize

Two sizes smaller than the default.


### -field tomDecSize

One size smaller than the default.


### -field tomIncSize

One size bigger than the default.


### -field tomIncIncSize

Two sizes bigger than the default.


### -field tomGravityUI

Use selection user interface rules.


### -field tomGravityBack

Both ends have backward gravity.


### -field tomGravityFore

Both ends have forward gravity.


### -field tomGravityIn

Inward gravity; that is, the start is forward, and the end is backward.


### -field tomGravityOut

Outward gravity; that is, the start is backward, and the end is forward.


### -field tomGravityBackward


### -field tomGravityForward


### -field tomAdjustCRLF

Adjust CR/LFs at the start.


### -field tomUseCRLF

Use CR/LF in place of a carriage return or a line feed. 


### -field tomTextize

Copy up to 0xFFFC (OLE object).


### -field tomAllowFinalEOP

Allow a final end-of-paragraph (EOP) marker.


### -field tomFoldMathAlpha

Fold math alphanumerics to ASCII/Greek.


### -field tomNoHidden

Don't include hidden text.


### -field tomIncludeNumbering

Include list numbers.


### -field tomTranslateTableCell

Replace table row delimiter characters with spaces.


### -field tomNoMathZoneBrackets

Don't include math zone brackets.


### -field tomConvertMathChar

Convert to or from math italic and/or math bold according to the status of italic and bold retrieved by the <a href="https://docs.microsoft.com/windows/desktop/api/tom/nf-tom-itextfont2-geteffects">ITextFont2::GetEffects</a> method. 



### -field tomNoUCGreekItalic

Don’t use math italics for upper-case Greek letters. This value is used with  
<b>tomConvertMathChar</b>.


### -field tomAllowMathBold

Allow math bold.  This value is used with  
<b>tomConvertMathChar</b>.


### -field tomLanguageTag

Get the BCP-47 language tag for this range.


### -field tomConvertRTF

Get text in RTF.


### -field tomApplyRtfDocProps

Apply RTF document default properties.


### -field tomPhantomShow

Display the phantom object's argument.


### -field tomPhantomZeroWidth

The phantom object has zero width.


### -field tomPhantomZeroAscent

The phantom object has zero ascent.


### -field tomPhantomZeroDescent

The phantom object has zero descent.


### -field tomPhantomTransparent

Space the phantom object as if only the argument is present.


### -field tomPhantomASmash

Ascent smash.


### -field tomPhantomDSmash

Descent smash.


### -field tomPhantomHSmash

Horizontal smash.


### -field tomPhantomSmash

Full smash.


### -field tomPhantomHorz

Horizontal phantom.


### -field tomPhantomVert

Vertical phantom.


### -field tomBoxHideTop

Hide top border.


### -field tomBoxHideBottom

Hide bottom border.


### -field tomBoxHideLeft

Hide left border.


### -field tomBoxHideRight

Hide right border.


### -field tomBoxStrikeH

Display horizontal strikethrough.


### -field tomBoxStrikeV

Display vertical strikethrough.


### -field tomBoxStrikeTLBR

Display diagonal strikethrough from the top left to the lower right.


### -field tomBoxStrikeBLTR

Display diagonal strikethrough from the lower left to the top right.


### -field tomBoxAlignCenter

Vertically align with center on baseline.


### -field tomSpaceMask

Mask for <b>tomSpaceDefault</b>, <b>tomSpaceUnary</b>, <b>tomSpaceBinary</b>, <b>tomSpaceRelational</b>, <b>tomSpaceSkip</b>, <b>tomSpaceOrd</b>, and <b>tomSpaceDifferential.</b>


### -field tomSpaceDefault

Default spacing


### -field tomSpaceUnary

Space the object as if it were a unary operator.


### -field tomSpaceBinary

Space the object as if it were a binary operator.


### -field tomSpaceRelational

Space the object as if it were a relational operator.


### -field tomSpaceSkip

Space the object as if it were a unary operator.


### -field tomSpaceOrd

Space the object as if it were an ordinal operator.


### -field tomSpaceDifferential

Space the object as if it were a differential operator.


### -field tomSizeText

Treat as text size.


### -field tomSizeScript

Treat as script size (approximately 73% of text size).


### -field tomSizeScriptScript

Treat as subscript size (approximately 60% of text size).


### -field tomNoBreak

Do not break arguments across a line.


### -field tomTransparentForPositioning

Position as if only the argument appears.


### -field tomTransparentForSpacing

Space according to argument properties.


### -field tomStretchCharBelow

Stretch character below base.


### -field tomStretchCharAbove

Stretch character above base.


### -field tomStretchBaseBelow

Stretch base  below character.


### -field tomStretchBaseAbove

Stretch base  above character.


### -field tomMatrixAlignMask

Mask for <b>tomMatrixAlignCenter</b>, <b>tomMatrixAlignTopRow</b>, and <b>tomMatrixAlignBottomRow.</b>


### -field tomMatrixAlignCenter

Align the matrix center on baseline.


### -field tomMatrixAlignTopRow

Align the matrix top row on the baseline.


### -field tomMatrixAlignBottomRow

Align the matrix bottom row on the baseline.


### -field tomShowMatPlaceHldr

Show empty element placeholder (a dotted box).


### -field tomEqArrayLayoutWidth

Expand the right size to the layout width (for equation number)


### -field tomEqArrayAlignMask

Mask for <b>tomEqArrayAlignCenter</b>, <b>tomEqArrayAlignTopRow</b>, and <b>tomEqArrayBottomRow.</b>


### -field tomEqArrayAlignCenter

Align the center of the equation array on the baseline. 


### -field tomEqArrayAlignTopRow

Align the top of equations on the baseline.

Align the top row of the equation on the baseline.


### -field tomEqArrayAlignBottomRow

Align the bottom row of the equation on the baseline.


### -field tomMathManualBreakMask

Mask for <b>tomMathBreakLeft</b>, <b>tomMathBreakCenter</b>, and <b>tomMathBreakRight.</b>


### -field tomMathBreakLeft

Align text following a manual break to the left.


### -field tomMathBreakCenter

Center text following a manual break.


### -field tomMathBreakRight

Align text following a manual break to the right.


### -field tomMathEqAlign

Math equation alignment.


### -field tomMathArgShadingStart

Start shading math arguments.


### -field tomMathArgShadingEnd

End shading math arguments.


### -field tomMathObjShadingStart

Start shading math objects.


### -field tomMathObjShadingEnd

End shading math objects.


### -field tomFunctionTypeNone

Not in the function list.


### -field tomFunctionTypeTakesArg

An ordinary math function that takes arguments.


### -field tomFunctionTypeTakesLim

Use the lower limit for _, and so on.


### -field tomFunctionTypeTakesLim2

Turn the preceding FA into an NBSP.


### -field tomFunctionTypeIsLim

A "lim" function.


### -field tomMathParaAlignDefault

The default alignment for math paragraphs.


### -field tomMathParaAlignCenterGroup

Center math paragraphs as a group.


### -field tomMathParaAlignCenter

Center math paragraphs.


### -field tomMathParaAlignLeft

Left-align math paragraphs.


### -field tomMathParaAlignRight

Right-align math paragraphs.


### -field tomMathDispAlignMask

Mask for <b>tomMathDispAlignCenterGroup</b>, <b>tomMathDispAlignCenter</b>, <b>tomMathDispAlignLeft</b>, <b>tomMathDispAlignRight</b>, <b>tomMathDispIntUnderOver</b>, and <b>tomMathDispNaryGrow</b>.


### -field tomMathDispAlignCenterGroup

Center a math paragraph as a group.


### -field tomMathDispAlignCenter

Center all equations in a math paragraph.


### -field tomMathDispAlignLeft

Left justify all equations in a math paragraph.


### -field tomMathDispAlignRight

Right justify all equations in a math paragraph.


### -field tomMathDispIntUnderOver

Display-mode integral limits location.


### -field tomMathDispFracTeX

Indicates whether to use display-mode nested fraction script size.


### -field tomMathDispNaryGrow

Indicates whether to use math-paragraph n-ary grow.


### -field tomMathDocEmptyArgMask

Empty arguments display mask.


### -field tomMathDocEmptyArgAuto

Dotted square, if necessary.


### -field tomMathDocEmptyArgAlways

Dotted square, always.


### -field tomMathDocEmptyArgNever

Nothing.


### -field tomMathDocSbSpOpUnchanged

Do not display the underscore (_) as subscripted, or the caret (^) as superscripted.


### -field tomMathDocDiffMask

Style mask for the <b>tomMathDocDiffUpright</b>, <b>tomMathDocDiffItalic</b>, <b>tomMathDocDiffOpenItalic </b>options.


### -field tomMathDocDiffDefault

Use default glyphs for math differentials.


### -field tomMathDocDiffUpright

Use upright glyphs for math differentials. 


### -field tomMathDocDiffItalic

Use italic glyphs for math differentials.


### -field tomMathDocDiffOpenItalic

No glyph change.


### -field tomMathDispNarySubSup

Math-paragraph non-integral n-ary limits location. 


### -field tomMathDispDef

Math-paragraph spacing defaults. Use math paragraph offsets instead of regular paragraph offsets. 


### -field tomMathEnableRtl

Enable right-to-left (RTL) math zones in RTL paragraphs.


### -field tomMathBrkBinMask

Equation line break mask.


### -field tomMathBrkBinBefore

Break before  binary/relational operator.


### -field tomMathBrkBinAfter

Break after binary/relational operator.


### -field tomMathBrkBinDup

Duplicate binary/relational before/after.


### -field tomMathBrkBinSubMask

Duplicate mask for minus operator.


### -field tomMathBrkBinSubMM

-- (minus on both lines).


### -field tomMathBrkBinSubPM

+ -


### -field tomMathBrkBinSubMP

- +


### -field tomSelRange

Set the selection character position and character count to range values.


### -field tomHstring

Use a string handle (<b>HSTRING</b>) instead of a binary string (<b>BSTR</b>).  
  



### -field tomFontPropTeXStyle

Gets the TeX style of the font.


### -field tomFontPropAlign

Use <b>tomFontPropAlign</b> to get the <b>Align</b> property of an operator in a math zone. Here are how the values are assigned:<ul>
<li>Value 0 implies no special alignment.</li>
<li>Values 1 through 127 align the operator with the (n – 1)st operator on the first line of an equation.</li>
<li>Value 128 identifies operators to be vertically aligned with respect to one another ("Align at ="). </li>
<li>Other values are illegal.</li>
</ul>



### -field tomFontStretch

The type of font stretching. It can have one of the following values.

<b>tomFontStretchDefault</b>
<b>tomFontStretchUltraCondensed</b>
<b>tomFontStretchExtraCondensed</b>
<b>tomFontStretchCondensed</b>
<b>tomFontStretchNormal</b>
<b>tomFontStretchSemiExpanded</b>
<b>tomFontStretchExpanded</b>
<b>tomFontStretchExtraExpanded</b>
<b>tomFontStretchUltraExpanded</b>

### -field tomFontStyle

The font style. It can have one of the following values.<ul>
<li><b>tomFontStyleUpright</b></li>
<li><b>tomFontStyleItalic</b></li>
<li><b>tomFontStyleOblique</b></li>
</ul>



### -field tomFontStyleUpright

Represents the normal upright font style.



### -field tomFontStyleOblique

Represents an oblique font style.



### -field tomFontStyleItalic

Represents an italic font style. 



### -field tomFontStretchDefault

No defined font stretch.



### -field tomFontStretchUltraCondensed

An ultra-condensed font stretch (50% of normal).



### -field tomFontStretchExtraCondensed

An extra-condensed font stretch (62.5% of normal).



### -field tomFontStretchCondensed

A condensed font stretch (75% of normal).



### -field tomFontStretchSemiCondensed

A semi-condensed font stretch (87.5% of normal).


### -field tomFontStretchNormal

The normal font stretch that all other font stretch values relate to (100%).


### -field tomFontStretchSemiExpanded

A semi-expanded font stretch (112.5% of normal).


### -field tomFontStretchExpanded

An expanded font stretch (125% of normal).


### -field tomFontStretchExtraExpanded

An extra-expanded font stretch (150% of normal).


### -field tomFontStretchUltraExpanded

An ultra-expanded font stretch (200% of normal).


### -field tomFontWeightDefault

The default font weight.


### -field tomFontWeightThin

Thin font weight.


### -field tomFontWeightExtraLight

Extra light font weight.


### -field tomFontWeightLight

Light font weight.


### -field tomFontWeightNormal

Normal font weight.


### -field tomFontWeightRegular

Same as <b>tomFontWeightNormal</b>.


### -field tomFontWeightMedium

Medium font weight.


### -field tomFontWeightSemiBold

Semi bold font weight.


### -field tomFontWeightBold

Bold font weight.


### -field tomFontWeightExtraBold

Extra bold font weight.


### -field tomFontWeightBlack

Heavy font weight.


### -field tomFontWeightHeavy

Same as <b>tomFontWeightBlack</b>.


### -field tomFontWeightExtraBlack

Extra heavy font weight.


### -field tomParaPropMathAlign

Alignment properties for a math paragraph.


### -field tomDocMathBuild

Used with the <a href="https://docs.microsoft.com/windows/desktop/api/tom/nf-tom-itextdocument2-setproperty">ITextDocument2::SetProperty</a> method to set any combination of <b>tomMathAutoCorrect</b>, <b>tomTeX</b>, or <b>tomMathAlphabetics</b>.


### -field tomMathLMargin

Left margin for display math.


### -field tomMathRMargin

Right margin for display math.


### -field tomMathWrapIndent

Equation wrap indent for display math.


### -field tomMathWrapRight

Equation right wrap indent for display math (in a left-to-right (LTR) math zone).


### -field tomMathPostSpace

Space after a display math equation.


### -field tomMathPreSpace

Space before a display math equation.


### -field tomMathInterSpace

Space between equations in math paragraphs.


### -field tomMathIntraSpace

Space between lines in a display math equation.


### -field tomCanCopy

Indicates whether data can be copied to the clipboard.


### -field tomCanRedo

Indicates whether one or more redo operations exist.


### -field tomCanUndo

Indicates whether one or more undo operations exist.


### -field tomUndoLimit

The undo stack count limit.


### -field tomDocAutoLink

A document automatic link.


### -field tomEllipsisMode

The ellipsis mode.


### -field tomEllipsisState

The ellipsis state.


### -field tomEllipsisNone

Ellipsis is disabled.


### -field tomEllipsisEnd

An ellipsis forces a break anywhere in the line.


### -field tomEllipsisWord

An ellipsis forces a break between words.


### -field tomEllipsisPresent

Ellipsis is present.


### -field tomVTopCell

The top cell in vertically merged cell set.


### -field tomVLowCell

Any cell except the top cell in a vertically merged cell set.


### -field tomHStartCell

Start a cell in a horizontally merged cell set.


### -field tomHContCell

Any cell except the start in a horizontally merged cell set.


### -field tomRowUpdate

Update the row to have the properties of the table row identified by the associated text range.


### -field tomRowApplyDefault


### -field tomCellStructureChangeOnly

Changes cell width(s) or cell count (for changing column widths and inserting/deleting columns without changing cell border properties, and so forth.)


### -field tomRowHeightActual

The actual height of a table row.


#### - tomChemicalFormula

Use chemical formula conversions.


#### - tomHaveDelimiter

A delimiter follows insertion points (formula automatic buildup).


#### - tomMathAlignBreakCenter

Center text following a manual break.


#### - tomMathAlignBreakLeft

Align text following a manual break to the left.


#### - tomMathAlignBreakRight

Align text following a manual break to the right.


#### - tomMathAlphabetics

Use math alphabetics for English/Greek letters except for math function names.


#### - tomMathApplyTemplate

Apply an object template to a range.


#### - tomMathArabicAlphabetics

Use Arabic math alphabetics for variables.


#### - tomMathAutoComplete

Show a tooltip with options for math autocompletions.


#### - tomMathAutoCorrect

Internal math autocorrect standard math \ keywords.


#### - tomMathAutoCorrectExt

Invoke external autocorrect in manual build up.


#### - tomMathAutoCorrectOpPairs

Autocorrect operator pairs.


#### - tomMathBackspace

Handle the Backspace key inside a math object.


#### - tomMathBuildDown

Build down instead of up.


#### - tomMathBuildDownOutermost

Build down only outermost objects.


#### - tomMathBuildUpArgOrZone

Build up insertion points argument or zone.


#### - tomMathBuildUpRecurse

Enable recursive build up.


#### - tomMathChangeMask

Mask for specifying changes to make during math linearization (build down). It can be a combination of the following values. 

<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathInsRowBefore</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathInsRowAfter</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathInsColBefore</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathInsColAfter</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathDeleteRow</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathDeleteCol</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathDeleteArg</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathDeleteArg1</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathDeleteArg2</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathMakeFracLinear</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathMakeFracStacked</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathMakeFracSlashed</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathMakeLeftSubSup</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathMakeSubSup</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathBackspace</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathEnter</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathShiftTab</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathTab</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathSubscript</a>
<a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomMathSuperscript</a>

#### - tomMathCollapseSel

Collapse the selection after build up or build down.


#### - tomMathDeleteArg

Delete the argument at the start of the range.


#### - tomMathDeleteArg1

Delete argument 1 (0-based count).


#### - tomMathDeleteArg2

Delete argument 2 (0-based count).


#### - tomMathDeleteCol

Delete a column.


#### - tomMathDeleteRow

Delete a row.


#### - tomMathEnter

Handle the Enter key inside a math object.


#### - tomMathInsColAfter

Insert a column or separator after the current argument.


#### - tomMathInsColBefore

Insert a column or separator before the current argument.


#### - tomMathInsRowAfter

Insert a row below the insertion point.


#### - tomMathInsRowBefore

Insert a row above the insertion point.


#### - tomMathMakeFracLinear

Change to a linear fraction.


#### - tomMathMakeFracSlashed

Change to a slashed fraction.


#### - tomMathMakeFracStacked

Change to a stacked fraction.


#### - tomMathMakeLeftSubSup

Change from <b>tomSubSup</b> to <b>tomLeftSubSup</b>.


#### - tomMathMakeSubSup

Change <b>tomLeftSubSup</b> to <b>tomSubSup</b>.


#### - tomMathRemoveOutermost

Build down the outermost object without its characters.


#### - tomMathRichEdit

Handle minor differences between the rich edit control and Word.


#### - tomMathShiftTab

Handle the Shift+Tab key combination inside a math object.


#### - tomMathSingleChar

Single character typed for build up.


#### - tomMathSubscript

Handle the Ctrl+= key combination in a math zone.


#### - tomMathSuperscript

Handle the Ctrl+Shift+= key combination in a math zone.


#### - tomMathTab

Handle the Tab key inside a math object.


#### - tomNeedTermOp

A terminating operator is needed. Only used with a degenerate range for formula autobuildup.


#### - tomPlain

Build down for plain text.


#### - tomShowEmptyArgPlaceholders

Don't hide empty argument  placeholders on build-up.


#### - tomSpecialChar

The character is treated as part of the current operand.


#### - tomTeX

Enables TeX syntax for build up/down operations. The <b>tomTeX</b> style can have the following values: <dl>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleDefault</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleScriptScriptCramped</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleScriptScript</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleScriptCramped</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleScript</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleTextCramped</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleText</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleDisplayCramped</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomStyleDisplay</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomDecDecSize</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomDecSize</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomIncSize</a></dd>
<dd><a href="https://docs.microsoft.com/windows/win32/api/tom/ne-tom-tomconstants">tomIncIncSize</a></dd>
</dl>



#### - tomUseOperandPrec

Use operand precedence.

