---
UID: NE:tpcshrd._PROPERTY_UNITS
title: PROPERTY_UNITS (tpcshrd.h)
description: Defines constant values for the unit of measurement of a property.
old-location: tablet\property_units.htm
tech.root: tablet
ms.assetid: bf207b4a-5ce2-4d2d-98ed-8020d559dca7
ms.date: 12/05/2018
ms.keywords: '*PPROPERTY_UNITS, PPROPERTY_UNITS, PPROPERTY_UNITS enumeration pointer [Tablet PC], PROPERTY_UNITS, PROPERTY_UNITS enumeration [Tablet PC], PROPERTY_UNITS_CENTIMETERS, PROPERTY_UNITS_DEFAULT, PROPERTY_UNITS_DEGREES, PROPERTY_UNITS_GRAMS, PROPERTY_UNITS_INCHES, PROPERTY_UNITS_POUNDS, PROPERTY_UNITS_RADIANS, PROPERTY_UNITS_SECONDS, bf207b4a-5ce2-4d2d-98ed-8020d559dca7, tablet.property_units, tpcshrd/PPROPERTY_UNITS, tpcshrd/PROPERTY_UNITS, tpcshrd/PROPERTY_UNITS_CENTIMETERS, tpcshrd/PROPERTY_UNITS_DEFAULT, tpcshrd/PROPERTY_UNITS_DEGREES, tpcshrd/PROPERTY_UNITS_GRAMS, tpcshrd/PROPERTY_UNITS_INCHES, tpcshrd/PROPERTY_UNITS_POUNDS, tpcshrd/PROPERTY_UNITS_RADIANS, tpcshrd/PROPERTY_UNITS_SECONDS'
f1_keywords:
- tpcshrd/PROPERTY_UNITS
dev_langs:
- c++
req.header: tpcshrd.h
req.include-header: Rectypes.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- tpcshrd.h
api_name:
- PROPERTY_UNITS
targetos: Windows
req.typenames: PROPERTY_UNITS, *PPROPERTY_UNITS
req.redist: 
ms.custom: 19H1
---

# PROPERTY_UNITS enumeration


## -description



Defines constant values for the unit of measurement of a property.




## -enum-fields




### -field PROPERTY_UNITS_DEFAULT

Units are unknown.


### -field PROPERTY_UNITS_INCHES

The property value is in inches.


### -field PROPERTY_UNITS_CENTIMETERS

 The property value is in centimeters.


### -field PROPERTY_UNITS_DEGREES

The property value is in degrees.


### -field PROPERTY_UNITS_RADIANS

The property value is in radians.


### -field PROPERTY_UNITS_SECONDS

The property value is in seconds.


### -field PROPERTY_UNITS_POUNDS

 The property value is in pounds.


### -field PROPERTY_UNITS_GRAMS

The property value is in grams.


### -field PROPERTY_UNITS_SILINEAR


### -field PROPERTY_UNITS_SIROTATION


### -field PROPERTY_UNITS_ENGLINEAR


### -field PROPERTY_UNITS_ENGROTATION


### -field PROPERTY_UNITS_SLUGS


### -field PROPERTY_UNITS_KELVIN


### -field PROPERTY_UNITS_FAHRENHEIT


### -field PROPERTY_UNITS_AMPERE


### -field PROPERTY_UNITS_CANDELA




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/tpcshrd/ns-tpcshrd-property_metrics">PROPERTY_METRICS Structure</a>
 

 

