---
UID: NE:tpmvscmgr.__MIDL___MIDL_itf_tpmvscmgr_0000_0000_0002
title: TPMVSCMGR_ERROR (tpmvscmgr.h)
description: Provides predefined error codes to represent the contexts of errors from the TPM virtual smart card manager.
old-location: security\tpmvscmgr_error.htm
tech.root: SecAuthN
ms.assetid: 0B8A5703-DA7C-4FD6-A39E-BA2CE172ADF9
ms.date: 12/05/2018
ms.keywords: TPMVSCMGR_ERROR, TPMVSCMGR_ERROR enumeration [Security], TPMVSCMGR_ERROR_CARD_CREATE, TPMVSCMGR_ERROR_CARD_DESTROY, TPMVSCMGR_ERROR_GENERATE_FILESYSTEM, TPMVSCMGR_ERROR_GENERATE_LOCATE_READER, TPMVSCMGR_ERROR_IMPERSONATION, TPMVSCMGR_ERROR_PIN_COMPLEXITY, TPMVSCMGR_ERROR_READER_COUNT_LIMIT, TPMVSCMGR_ERROR_TERMINAL_SERVICES_SESSION, TPMVSCMGR_ERROR_VGIDSSIMULATOR_CREATE, TPMVSCMGR_ERROR_VGIDSSIMULATOR_DESTROY, TPMVSCMGR_ERROR_VGIDSSIMULATOR_INITIALIZE, TPMVSCMGR_ERROR_VGIDSSIMULATOR_READ_PROPERTY, TPMVSCMGR_ERROR_VGIDSSIMULATOR_WRITE_PROPERTY, TPMVSCMGR_ERROR_VREADER_CREATE, TPMVSCMGR_ERROR_VREADER_DESTROY, TPMVSCMGR_ERROR_VREADER_INITIALIZE, TPMVSCMGR_ERROR_VTPMSMARTCARD_CREATE, TPMVSCMGR_ERROR_VTPMSMARTCARD_DESTROY, TPMVSCMGR_ERROR_VTPMSMARTCARD_INITIALIZE, security.tpmvscmgr_error, tpmvscmgr/TPMVSCMGR_ERROR, tpmvscmgr/TPMVSCMGR_ERROR_CARD_CREATE, tpmvscmgr/TPMVSCMGR_ERROR_CARD_DESTROY, tpmvscmgr/TPMVSCMGR_ERROR_GENERATE_FILESYSTEM, tpmvscmgr/TPMVSCMGR_ERROR_GENERATE_LOCATE_READER, tpmvscmgr/TPMVSCMGR_ERROR_IMPERSONATION, tpmvscmgr/TPMVSCMGR_ERROR_PIN_COMPLEXITY, tpmvscmgr/TPMVSCMGR_ERROR_READER_COUNT_LIMIT, tpmvscmgr/TPMVSCMGR_ERROR_TERMINAL_SERVICES_SESSION, tpmvscmgr/TPMVSCMGR_ERROR_VGIDSSIMULATOR_CREATE, tpmvscmgr/TPMVSCMGR_ERROR_VGIDSSIMULATOR_DESTROY, tpmvscmgr/TPMVSCMGR_ERROR_VGIDSSIMULATOR_INITIALIZE, tpmvscmgr/TPMVSCMGR_ERROR_VGIDSSIMULATOR_READ_PROPERTY, tpmvscmgr/TPMVSCMGR_ERROR_VGIDSSIMULATOR_WRITE_PROPERTY, tpmvscmgr/TPMVSCMGR_ERROR_VREADER_CREATE, tpmvscmgr/TPMVSCMGR_ERROR_VREADER_DESTROY, tpmvscmgr/TPMVSCMGR_ERROR_VREADER_INITIALIZE, tpmvscmgr/TPMVSCMGR_ERROR_VTPMSMARTCARD_CREATE, tpmvscmgr/TPMVSCMGR_ERROR_VTPMSMARTCARD_DESTROY, tpmvscmgr/TPMVSCMGR_ERROR_VTPMSMARTCARD_INITIALIZE
f1_keywords:
- tpmvscmgr/TPMVSCMGR_ERROR
dev_langs:
- c++
req.header: tpmvscmgr.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Tpmvscmgr.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: Vscmgr.lib
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- LibDef
api_location:
- Vscmgr.lib
api_name:
- TPMVSCMGR_ERROR
targetos: Windows
req.typenames: TPMVSCMGR_ERROR
req.redist: 
ms.custom: 19H1
---

# TPMVSCMGR_ERROR enumeration


## -description


Provides predefined error codes to represent the contexts of errors from the TPM virtual smart card manager.


## -enum-fields




### -field TPMVSCMGR_ERROR_IMPERSONATION

Failed to impersonate the caller.


### -field TPMVSCMGR_ERROR_PIN_COMPLEXITY

Ensure that your PIN/PUK meets the length or complexity requirements of your organization.


### -field TPMVSCMGR_ERROR_READER_COUNT_LIMIT

The limit of the number of smart card readers has been reached.


### -field TPMVSCMGR_ERROR_TERMINAL_SERVICES_SESSION

TPM virtual smart card management cannot be used within a Terminal Services session.


### -field TPMVSCMGR_ERROR_VTPMSMARTCARD_INITIALIZE

Failed to initialize the virtual smart card manager.


### -field TPMVSCMGR_ERROR_VTPMSMARTCARD_CREATE

Failed to create the virtual smart card manager.


### -field TPMVSCMGR_ERROR_VTPMSMARTCARD_DESTROY

Failed to destroy the virtual smart card manager.


### -field TPMVSCMGR_ERROR_VGIDSSIMULATOR_INITIALIZE

Failed to initialize the virtual smart card simulator.


### -field TPMVSCMGR_ERROR_VGIDSSIMULATOR_CREATE

Failed to create the virtual smart card simulator.


### -field TPMVSCMGR_ERROR_VGIDSSIMULATOR_DESTROY

Failed to destroy the virtual smart card simulator.


### -field TPMVSCMGR_ERROR_VGIDSSIMULATOR_WRITE_PROPERTY

Failed to configure the virtual smart card simulator.


### -field TPMVSCMGR_ERROR_VGIDSSIMULATOR_READ_PROPERTY

Failed to find the specified virtual smart card simulator.


### -field TPMVSCMGR_ERROR_VREADER_INITIALIZE

Failed to initialize the virtual smart card reader.


### -field TPMVSCMGR_ERROR_VREADER_CREATE

Failed to create the virtual smart card reader.


### -field TPMVSCMGR_ERROR_VREADER_DESTROY

Failed to destroy the virtual smart card reader.


### -field TPMVSCMGR_ERROR_GENERATE_LOCATE_READER

Failed to connect to the TPM smart card.


### -field TPMVSCMGR_ERROR_GENERATE_FILESYSTEM

Failed to generate the file system on the TPM smart card.


### -field TPMVSCMGR_ERROR_CARD_CREATE

Unable to create the TPM smart card.


### -field TPMVSCMGR_ERROR_CARD_DESTROY

Unable to destroy the TPM smart card.


## -remarks



These error codes are sent from the TPM virtual smart card manager COM server to the caller through the status callback interface, <a href="https://docs.microsoft.com/windows/desktop/api/tpmvscmgr/nn-tpmvscmgr-itpmvirtualsmartcardmanagerstatuscallback">ITpmVirtualSmartCardManagerStatusCallback</a>. Status callback interface implementations must interpret the error codes based on their predefined meanings and, if applicable, load localized message strings and update the user interface.



