---
UID: NF:traceloggingprovider.TRACELOGGING_DEFINE_PROVIDER
title: TRACELOGGING_DEFINE_PROVIDER macro (traceloggingprovider.h)
description: Allocates storage for a TraceLogging provider and creates a handle to the provider.
old-location: tracelogging\TRACELOGGING_DEFINE_PROVIDER.htm
tech.root: tracelogging
ms.assetid: 4515652D-86B0-4274-8523-27292F5F6815
ms.date: 12/05/2018
ms.keywords: TRACELOGGING_DEFINE_PROVIDER, TRACELOGGING_DEFINE_PROVIDER macro, tracelogging.TRACELOGGING_DEFINE_PROVIDER, tracelogging.traceloggingprovider, traceloggingprovider/TRACELOGGING_DEFINE_PROVIDER
f1_keywords:
- traceloggingprovider/TRACELOGGING_DEFINE_PROVIDER
dev_langs:
- c++
req.header: traceloggingprovider.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2012 R2
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- traceloggingprovider.h
api_name:
- TRACELOGGING_DEFINE_PROVIDER
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# TRACELOGGING_DEFINE_PROVIDER macro


## -description


Allocates storage for a TraceLogging provider and creates a handle to the provider.


## -parameters




### -param handleVariable [in]

A handle to a TraceLogging provider (TraceLoggingHProvider) created using <a href="https://docs.microsoft.com/windows/desktop/api/traceloggingprovider/nf-traceloggingprovider-tracelogging_declare_provider">TRACELOGGING_DECLARE_PROVIDER</a>.


### -param providerName [in]

The name of the TraceLogging provider. This must be a string literal--do not use a variable.


### -param providerId [in]

The GUID for the provider.


#### - options [in, optional]

The GUID of the provider group that this provider is a member of.


## -remarks



Before using this macro, you need to declare your TraceLogging provider using <a href="https://docs.microsoft.com/windows/win32/api/traceloggingprovider/nf-traceloggingprovider-traceloggingregisterex">TRACELOGGING_DECLARE_PROVIDER</a>. Once the provider is created, it is in the unregistered state. Before it can respond to any write calls, you need to register the provider using  <a href="https://docs.microsoft.com/windows/desktop/api/traceloggingprovider/nf-traceloggingprovider-traceloggingregister">TraceLoggingRegister</a>.

Use the <a href="https://docs.microsoft.com/windows/desktop/api/traceloggingprovider/nf-traceloggingprovider-traceloggingoptiongroup">TraceLoggingOptionGroup</a> macro to  specify the GUID of the provider group that the provider belongs to. A provider can be a member of no
more than one group. The semantics of group membership are determined by
the ETW controllers that subscribe a session to a group.

If your provider is a part of a group, add the <i>options</i> parameter.


#### Examples


```cpp
TRACELOGGING_DEFINE_PROVIDER(
    g_hMyProvider,
    "MyProvider",
    (0xb3864c38, 0x4273, 0x58c5, 0x54, 0x5b, 0x8b, 0x36, 0x08, 0x34, 0x34, 0x71));
```

```cpp
TRACELOGGING_DEFINE_PROVIDER(
    g_hMyProvider,
    "MyProvider",
    (0xb3864c38, 0x4273, 0x58c5, 0x54, 0x5b, 0x8b, 0x36, 0x08, 0x34, 0x34, 0x71),
    TraceLoggingOptionGroup(0xfaaf2f61, 0x9b26, 0x4591, 0x9b, 0xb1, 0xb9, 0xb8, 0xba, 0xe2, 0xd3, 0x4c));
```




