---
UID: NF:tuner.IBDAComparable.HashEquivalentIncremental
title: IBDAComparable::HashEquivalentIncremental (tuner.h)
description: This topic applies to Update Rollup 2 for Microsoft Windows XP Media Center Edition 2005 and later.
old-location: mstv\ibdacomparable_hashequivalentincremental.htm
tech.root: mstv
ms.assetid: 8e5fcaf0-f160-4cff-9e9d-44766e0545c9
ms.date: 12/05/2018
ms.keywords: HashEquivalentIncremental, HashEquivalentIncremental method [Microsoft TV Technologies], HashEquivalentIncremental method [Microsoft TV Technologies],IBDAComparable interface, IBDAComparable interface [Microsoft TV Technologies],HashEquivalentIncremental method, IBDAComparable.HashEquivalentIncremental, IBDAComparable::HashEquivalentIncremental, IBDAComparableHashEquivalentIncremental, mstv.ibdacomparable_hashequivalentincremental, tuner/IBDAComparable::HashEquivalentIncremental
f1_keywords:
- tuner/IBDAComparable.HashEquivalentIncremental
dev_langs:
- c++
req.header: tuner.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Tuner.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- tuner.h
api_name:
- IBDAComparable.HashEquivalentIncremental
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IBDAComparable::HashEquivalentIncremental


## -description



This topic applies to Update Rollup 2 for Microsoft Windows XP Media Center Edition 2005 and later.
        



The <b>HashEquivalentIncremental</b> method incrementally generates a hash code for a subset of the tuning properties of an object.


## -parameters




### -param PartialResult [in]

Specifies the intermediate hash code that is to be combined with the hash code that is generated by the method. Typically, this value was generated by a previous call to either <b>HashEquivalentIncremental</b> or <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nf-tuner-ibdacomparable-hashequivalent">HashEquivalent</a>.


### -param dwFlags [in]

Specifies whether to alter the subset of properties that are to be incorporated by default into the hash code. Setting this parameter to 0 invokes the default behavior. Setting this parameter to the bitwise <b>OR</b> of one or more <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mstv/bda-comp-flags">BDA_Comp_Flags</a> enumeration values overrides the default behavior.


### -param Result [out]

Pointer to a variable that receives the result of the hash operation. This result is the hash code for the subset of the tuning properties of the object and its associated objects that are to be included in comparisons with other objects.


## -returns



If the method succeeds, it returns S_OK. If it fails, it returns an error code.




## -remarks



This method generates a hash code from a subset of the tuning properties in the object that implements the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nn-tuner-ibdacomparable">IBDAComparable</a> interface, and its associated objects.

Calling this method with a <i>PartialResult</i> value of 0 yields the same result as calling <b>HashEquivalent</b>.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nf-tuner-ibdacomparable-hashequivalent">HashEquivalent</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nn-tuner-ibdacomparable">IBDAComparable Interface</a>
 

 

