---
UID: NF:tuner.IESCloseMmiEvent.GetDialogNumber
title: IESCloseMmiEvent::GetDialogNumber (tuner.h)
description: Returns the dialog number generated by Media Sink Device (MSD) under the Protected Broadcast Driver Architecture (PBDA).
old-location: mstv\iesclosemmievent_getdialognumber.htm
tech.root: mstv
ms.assetid: b4935144-2e79-400e-9558-a387c45674c5
ms.date: 12/05/2018
ms.keywords: GetDialogNumber, GetDialogNumber method [Microsoft TV Technologies], GetDialogNumber method [Microsoft TV Technologies],IESCloseMmiEvent interface, IESCloseMmiEvent interface [Microsoft TV Technologies],GetDialogNumber method, IESCloseMmiEvent.GetDialogNumber, IESCloseMmiEvent::GetDialogNumber, mstv.iesclosemmievent_getdialognumber, tuner/IESCloseMmiEvent::GetDialogNumber
f1_keywords:
- tuner/IESCloseMmiEvent.GetDialogNumber
dev_langs:
- c++
req.header: tuner.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Tuner.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- tuner.h
api_name:
- IESCloseMmiEvent.GetDialogNumber
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IESCloseMmiEvent::GetDialogNumber


## -description


Returns the dialog number generated by Media Sink Device (MSD) under the Protected Broadcast Driver Architecture (PBDA). The MSD is the device that receives protected content from a Media Transform Device (MTD). The dialog number identifies the dialog to the MTD while the MTD is processing the <b>CloseMMI </b> event.


## -parameters




### -param pDialogNumber [out, retval]

Number generated by the MSD that is closing the dialog, which identifies the dialog.
          


## -returns



If this method succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nn-tuner-iesclosemmievent">IESCloseMmiEvent</a>
 

 

