---
UID: NF:tuner.IESOpenMmiEvent.GetDialogNumber
title: IESOpenMmiEvent::GetDialogNumber (tuner.h)
description: The GetDialogNumber method returns the dialog number generated by the sending device. The dialog number identifies the dialog to the receiver while the receiver is processing the OpenMMI event.
old-location: mstv\iesopenmmievent_getdialognumber.htm
tech.root: mstv
ms.assetid: ac96ed00-1b05-4f66-a626-a3e6655a5bb1
ms.date: 12/05/2018
ms.keywords: GetDialogNumber, GetDialogNumber method [Microsoft TV Technologies], GetDialogNumber method [Microsoft TV Technologies],IESOpenMmiEvent interface, IESOpenMmiEvent interface [Microsoft TV Technologies],GetDialogNumber method, IESOpenMmiEvent.GetDialogNumber, IESOpenMmiEvent::GetDialogNumber, mstv.iesopenmmievent_getdialognumber, tuner/IESOpenMmiEvent::GetDialogNumber
f1_keywords:
- tuner/IESOpenMmiEvent.GetDialogNumber
dev_langs:
- c++
req.header: tuner.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Tuner.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- tuner.h
api_name:
- IESOpenMmiEvent.GetDialogNumber
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IESOpenMmiEvent::GetDialogNumber


## -description


The <b>GetDialogNumber</b> method returns the dialog number generated by the sending device. The dialog number identifies the dialog to the receiver while the receiver is processing the <b>OpenMMI </b> event.


## -parameters




### -param pDialogRequest [out]

Pointer to the value of the dialog request from the operation that generated the <b>OpenMMI</b> request, for example, a call to <a href="https://docs.microsoft.com/windows/desktop/api/bdaiface/nf-bdaiface-ibda_conditionalaccessex-checkentitlementtoken">IBDA::CheckEntitlementToken</a>. 


### -param pDialogNumber [out, retval]

Gets the number generated by the device that is opening the dialog, which identifies the dialog.
          


## -returns



If this method succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/bdaiface/nf-bdaiface-ibda_conditionalaccessex-checkentitlementtoken">CheckEntitlementToken</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nn-tuner-iesopenmmievent">IESOpenMmiEvent</a>
 

 

