---
UID: NN:tuner.IDigitalLocator
title: IDigitalLocator
description: The IDigitalLocator interface serves as the base interface for Locator objects that contain tuning information about the tuning space for a digital network. This interface is used only through derived interfaces such as IATSCLocator.
old-location: mstv\idigitallocator.htm
tech.root: mstv
ms.assetid: 9af4d871-c6ed-479b-ba41-2a719d3a394d
ms.date: 12/05/2018
ms.keywords: IDigitalLocator, IDigitalLocator interface [Microsoft TV Technologies], IDigitalLocator interface [Microsoft TV Technologies],described, IDigitalLocatorInterface, mstv.idigitallocator, tuner/IDigitalLocator
f1_keywords:
- tuner/IDigitalLocator
dev_langs:
- c++
req.header: tuner.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Tuner.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- tuner.h
api_name:
- IDigitalLocator
targetos: Windows
req.typenames: 
req.redist: 
---

# IDigitalLocator interface


## -description



The <b>IDigitalLocator</b> interface serves as the base interface for <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dd695081(v=vs.85)">Locator</a> objects that contain tuning information about the tuning space for a digital network. This interface is used only through derived interfaces such as <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nn-tuner-iatsclocator">IATSCLocator</a>.




## -remarks



To declare the interface identifier (IID) for this interface, use the <b>__uuidof</b> operator: <code>__uuidof(IDigitalLocator)</code>.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nn-tuner-ilocator">ILocator</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mstv/tuning-model-interfaces">Tuning Model Interfaces</a>
 

 

