---
UID: NN:tuner.IESOpenMmiEvent
title: IESOpenMmiEvent (tuner.h)
description: Gets information from an OpenMMI event.
old-location: mstv\iesopenmmievent.htm
tech.root: mstv
ms.assetid: f54532e2-d1d1-4c6b-ae3d-9f50e0e61366
ms.date: 12/05/2018
ms.keywords: IESOpenMmiEvent, IESOpenMmiEvent interface [Microsoft TV Technologies], IESOpenMmiEvent interface [Microsoft TV Technologies],described, mstv.iesopenmmievent, tuner/IESOpenMmiEvent
f1_keywords:
- tuner/IESOpenMmiEvent
dev_langs:
- c++
req.header: tuner.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Tuner.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- tuner.h
api_name:
- IESOpenMmiEvent
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IESOpenMmiEvent interface


## -description


Gets information from an  <b>OpenMMI</b> event. A Protected Broadcast Driver Architecture (PBDA) Media Transform Device (MTD) fires an  <b>OpenMMI</b> event when the device user tries to open an on-screen display, such as a dialog box. 

For more information about PBDA, download the specification from <a href="https://developer.microsoft.com/windows/hardware">this document</a>.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IESOpenMmiEvent</b> interface inherits from <b>IESEvent</b>. <b>IESOpenMmiEvent</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IESOpenMmiEvent</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nf-tuner-iesopenmmievent-getdialogdata">GetDialogData</a>
</td>
<td align="left" width="63%">
Gets any data associated with the dialog, in byte stream format.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nf-tuner-iesopenmmievent-getdialognumber">GetDialogNumber</a>
</td>
<td align="left" width="63%">
Gets the dialog number generated by the sending device to identify this man-machine interface (MMI)  session.
          

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nf-tuner-iesopenmmievent-getdialogstringdata">GetDialogStringData</a>
</td>
<td align="left" width="63%">
Gets data associated with the dialog, in Unicode string format.
          

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/tuner/nf-tuner-iesopenmmievent-getdialogtype">GetDialogType</a>
</td>
<td align="left" width="63%">
Gets the experience type of the dialog.
          

</td>
</tr>
</table> 


## -remarks



To declare the interface identifier (IID) for this interface, use the <b>__uuidof</b> operator: <code>__uuidof(IESOpenMmiEvent)</code>.



