---
UID: NE:uiautomationclient.CoalesceEventsOptions
title: CoalesceEventsOptions (uiautomationclient.h)
description: Contains possible values for the CoalesceEvents property, which indicates whether an accessible technology client receives all events, or a subset where duplicate events are detected and filtered.
old-location: winauto\uiauto_coalesceeventsoptions_enum.htm
tech.root: WinAuto
ms.assetid: 2CE5A02A-40B4-43BE-863E-08AD9B2A9F75
ms.date: 12/05/2018
ms.keywords: CoalesceEventsOptions, CoalesceEventsOptions enumeration [Windows Accessibility], CoalesceEventsOptions_Disabled, CoalesceEventsOptions_Enabled, uiautomationclient/CoalesceEventsOptions, uiautomationclient/CoalesceEventsOptions_Disabled, uiautomationclient/CoalesceEventsOptions_Enabled, winauto.uiauto_coalesceeventsoptions_enum
f1_keywords:
- uiautomationclient/CoalesceEventsOptions
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1607 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationClient.h
api_name:
- CoalesceEventsOptions
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CoalesceEventsOptions enumeration


## -description


Contains possible values for the <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomation6-get_coalesceevents">CoalesceEvents</a> property, which indicates whether an accessible technology client receives all events, or a subset where duplicate events are detected and filtered.


## -enum-fields




### -field CoalesceEventsOptions_Disabled

Event coalescing is disabled.


### -field CoalesceEventsOptions_Enabled

Event coalescing is enabled.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomation6-get_coalesceevents">CoalesceEvents</a>
 

 

