---
UID: NE:uiautomationclient.ConnectionRecoveryBehaviorOptions
title: ConnectionRecoveryBehaviorOptions (uiautomationclient.h)
description: Contains possible values for the ConnectionRecoveryBehavior property, which indicates whether an accessible technology client adjusts provider request timeouts when the provider is non-responsive.
old-location: winauto\uiauto_connectionrecoverybehavioroptions.htm
tech.root: WinAuto
ms.assetid: B731C970-49AF-4BD7-9D30-DFBB76120499
ms.date: 12/05/2018
ms.keywords: ConnectionRecoveryBehaviorOptions, ConnectionRecoveryBehaviorOptions enumeration [Windows Accessibility], ConnectionRecoveryBehaviorOptions_Disabled, ConnectionRecoveryBehaviorOptions_Enabled, uiautomationclient/ConnectionRecoveryBehaviorOptions, uiautomationclient/ConnectionRecoveryBehaviorOptions_Disabled, uiautomationclient/ConnectionRecoveryBehaviorOptions_Enabled, winauto.uiauto_connectionrecoverybehavioroptions
f1_keywords:
- uiautomationclient/ConnectionRecoveryBehaviorOptions
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1607 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationClient.h
api_name:
- ConnectionRecoveryBehaviorOptions
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ConnectionRecoveryBehaviorOptions enumeration


## -description


Contains possible values for the <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomation6-get_connectionrecoverybehavior">ConnectionRecoveryBehavior</a> property, which indicates whether an accessible technology client adjusts provider request timeouts when the provider is non-responsive.


## -enum-fields




### -field ConnectionRecoveryBehaviorOptions_Disabled

Connection recovery is disabled.


### -field ConnectionRecoveryBehaviorOptions_Enabled

Connection recovery is enabled.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomation6-get_connectionrecoverybehavior">ConnectionRecoveryBehavior</a>
 

 

