---
UID: NF:uiautomationclient.IUIAutomationElement.get_CachedIsContentElement
title: IUIAutomationElement::get_CachedIsContentElement (uiautomationclient.h)
description: A cached value that indicates whether the element is a content element.
old-location: winauto\uiauto_IUIAutomationElement_CachedIsContentElement.htm
tech.root: WinAuto
ms.assetid: 3e06c0dd-0cdd-4193-9353-5a71d08ec17d
ms.date: 12/05/2018
ms.keywords: CachedIsContentElement property [Windows Accessibility], CachedIsContentElement property [Windows Accessibility],IUIAutomationElement interface, IUIAutomationElement interface [Windows Accessibility],CachedIsContentElement property, IUIAutomationElement.CachedIsContentElement, IUIAutomationElement.get_CachedIsContentElement, IUIAutomationElement::CachedIsContentElement, IUIAutomationElement::get_CachedIsContentElement, get_CachedIsContentElement, uiauto.uiauto_IUIAutomationElement_CachedIsContentElement, uiauto_IUIAutomationElement_CachedIsContentElement, uiautomationclient/IUIAutomationElement::CachedIsContentElement, uiautomationclient/IUIAutomationElement::get_CachedIsContentElement, winauto.uiauto_IUIAutomationElement_CachedIsContentElement
f1_keywords:
- uiautomationclient/IUIAutomationElement.CachedIsContentElement
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista, Windows XP with SP3 and Platform Update for Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008, Windows Server 2003 with SP2 and Platform Update for Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationClient.h
api_name:
- IUIAutomationElement.CachedIsContentElement
- IUIAutomationElement.get_CachedIsContentElement
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUIAutomationElement::get_CachedIsContentElement


## -description


A cached value that indicates whether the element is a content element.

This property is read-only.


## -parameters


## -remarks



A content element contains data that is presented to the user. Examples of content elements are the items in a list box or a button in a dialog box. Non-content elements, also called peripheral elements, are typically used to manipulate the content in a composite control; for example, the button on a drop-down control.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-automation-element-propids">Automation Element Property IDs</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_cachediscontrolelement">CachedIsControlElement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_currentiscontentelement">CurrentIsContentElement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a>



<b>Reference</b>
 

 

