---
UID: NF:uiautomationclient.IUIAutomationElement.get_CachedIsControlElement
title: IUIAutomationElement::get_CachedIsControlElement (uiautomationclient.h)
description: Retrieves a cached value that indicates whether the element is a control element.
old-location: winauto\uiauto_IUIAutomationElement_CachedIsControlElement.htm
tech.root: WinAuto
ms.assetid: 3d8b1b5e-4e68-454a-9cfc-dd742a5fa760
ms.date: 12/05/2018
ms.keywords: CachedIsControlElement property [Windows Accessibility], CachedIsControlElement property [Windows Accessibility],IUIAutomationElement interface, IUIAutomationElement interface [Windows Accessibility],CachedIsControlElement property, IUIAutomationElement.CachedIsControlElement, IUIAutomationElement.get_CachedIsControlElement, IUIAutomationElement::CachedIsControlElement, IUIAutomationElement::get_CachedIsControlElement, get_CachedIsControlElement, uiauto.uiauto_IUIAutomationElement_CachedIsControlElement, uiauto_IUIAutomationElement_CachedIsControlElement, uiautomationclient/IUIAutomationElement::CachedIsControlElement, uiautomationclient/IUIAutomationElement::get_CachedIsControlElement, winauto.uiauto_IUIAutomationElement_CachedIsControlElement
f1_keywords:
- uiautomationclient/IUIAutomationElement.CachedIsControlElement
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista, Windows XP with SP3 and Platform Update for Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008, Windows Server 2003 with SP2 and Platform Update for Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationClient.h
api_name:
- IUIAutomationElement.CachedIsControlElement
- IUIAutomationElement.get_CachedIsControlElement
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUIAutomationElement::get_CachedIsControlElement


## -description


Retrieves a cached value that indicates whether the element is a control element.

This property is read-only.


## -parameters


## -remarks



Controls are elements in the UI that display information, or that can be manipulated by the user to perform an action.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-automation-element-propids">Automation Element Property IDs</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_cachediscontentelement">CachedIsContentElement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_currentiscontrolelement">CurrentIsControlElement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a>



<b>Reference</b>
 

 

