---
UID: NF:uiautomationclient.IUIAutomationElement.get_CachedItemStatus
title: IUIAutomationElement::get_CachedItemStatus (uiautomationclient.h)
description: Retrieves a cached description of the status of an item within an element.
old-location: winauto\uiauto_IUIAutomationElement_CachedItemStatus.htm
tech.root: WinAuto
ms.assetid: 29a7e815-9d86-49e3-81b0-bf9398f27cad
ms.date: 12/05/2018
ms.keywords: CachedItemStatus property [Windows Accessibility], CachedItemStatus property [Windows Accessibility],IUIAutomationElement interface, IUIAutomationElement interface [Windows Accessibility],CachedItemStatus property, IUIAutomationElement.CachedItemStatus, IUIAutomationElement.get_CachedItemStatus, IUIAutomationElement::CachedItemStatus, IUIAutomationElement::get_CachedItemStatus, get_CachedItemStatus, uiauto.uiauto_IUIAutomationElement_CachedItemStatus, uiauto_IUIAutomationElement_CachedItemStatus, uiautomationclient/IUIAutomationElement::CachedItemStatus, uiautomationclient/IUIAutomationElement::get_CachedItemStatus, winauto.uiauto_IUIAutomationElement_CachedItemStatus
f1_keywords:
- uiautomationclient/IUIAutomationElement.CachedItemStatus
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista, Windows XP with SP3 and Platform Update for Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008, Windows Server 2003 with SP2 and Platform Update for Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationClient.h
api_name:
- IUIAutomationElement.CachedItemStatus
- IUIAutomationElement.get_CachedItemStatus
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUIAutomationElement::get_CachedItemStatus


## -description


Retrieves a cached description of the status of an item within an element.

This property is read-only.


## -parameters


## -remarks



This property enables a client to ascertain whether an element is conveying status about an item. For example, an item associated with a contact in a messaging application might be "Busy" or "Connected".




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-automation-element-propids">Automation Element Property IDs</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_currentitemstatus">CurrentItemStatus</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a>



<b>Reference</b>
 

 

