---
UID: NF:uiautomationclient.IUIAutomationElement.get_CurrentIsContentElement
title: IUIAutomationElement::get_CurrentIsContentElement (uiautomationclient.h)
description: Indicates whether the element is a content element.
old-location: winauto\uiauto_IUIAutomationElement_CurrentIsContentElement.htm
tech.root: WinAuto
ms.assetid: 9fc8aada-cb6e-497e-b915-a22117788012
ms.date: 12/05/2018
ms.keywords: CurrentIsContentElement property [Windows Accessibility], CurrentIsContentElement property [Windows Accessibility],IUIAutomationElement interface, IUIAutomationElement interface [Windows Accessibility],CurrentIsContentElement property, IUIAutomationElement.CurrentIsContentElement, IUIAutomationElement.get_CurrentIsContentElement, IUIAutomationElement::CurrentIsContentElement, IUIAutomationElement::get_CurrentIsContentElement, get_CurrentIsContentElement, uiauto.uiauto_IUIAutomationElement_CurrentIsContentElement, uiauto_IUIAutomationElement_CurrentIsContentElement, uiautomationclient/IUIAutomationElement::CurrentIsContentElement, uiautomationclient/IUIAutomationElement::get_CurrentIsContentElement, winauto.uiauto_IUIAutomationElement_CurrentIsContentElement
f1_keywords:
- uiautomationclient/IUIAutomationElement.CurrentIsContentElement
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista, Windows XP with SP3 and Platform Update for Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008, Windows Server 2003 with SP2 and Platform Update for Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationClient.h
api_name:
- IUIAutomationElement.CurrentIsContentElement
- IUIAutomationElement.get_CurrentIsContentElement
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUIAutomationElement::get_CurrentIsContentElement


## -description


Indicates whether the element is a content element.

This property is read-only.


## -parameters


## -remarks



A content element contains data that is presented to the user. Examples of content elements are the items in a list box or a button in a dialog box. Non-content elements, also called peripheral elements, are typically used to manipulate the content in a composite control; for example, the button on a drop-down control.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-automation-element-propids">Automation Element Property IDs</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_cachediscontentelement">CachedIsContentElement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement-get_currentiscontrolelement">CurrentIsControlElement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a>



<b>Reference</b>
 

 

