---
UID: NF:uiautomationclient.IUIAutomationElement2.get_CachedOptimizeForVisualContent
title: IUIAutomationElement2::get_CachedOptimizeForVisualContent (uiautomationclient.h)
description: Retrieves a cached value that indicates whether the provider exposes only elements that are visible.
old-location: winauto\uiauto_IUIAutomationElement_CachedOptimizeForVisualContent.htm
tech.root: WinAuto
ms.assetid: FB1484D0-BF83-431B-A90B-B5F1757C4928
ms.date: 12/05/2018
ms.keywords: CachedOptimizeForVisualContent property [Windows Accessibility], CachedOptimizeForVisualContent property [Windows Accessibility],IUIAutomationElement2 interface, IUIAutomationElement2 interface [Windows Accessibility],CachedOptimizeForVisualContent property, IUIAutomationElement2.CachedOptimizeForVisualContent, IUIAutomationElement2.get_CachedOptimizeForVisualContent, IUIAutomationElement2::CachedOptimizeForVisualContent, IUIAutomationElement2::get_CachedOptimizeForVisualContent, get_CachedOptimizeForVisualContent, uiautomationclient/IUIAutomationElement2::CachedOptimizeForVisualContent, uiautomationclient/IUIAutomationElement2::get_CachedOptimizeForVisualContent, winauto.uiauto_IUIAutomationElement_CachedOptimizeForVisualContent
f1_keywords:
- uiautomationclient/IUIAutomationElement2.CachedOptimizeForVisualContent
dev_langs:
- c++
req.header: uiautomationclient.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationClient.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationClient.h
api_name:
- IUIAutomationElement2.CachedOptimizeForVisualContent
- IUIAutomationElement2.get_CachedOptimizeForVisualContent
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUIAutomationElement2::get_CachedOptimizeForVisualContent


## -description


Retrieves a cached value that indicates whether the provider exposes only elements that are visible.

This property is read-only.


## -parameters


## -remarks



A value of TRUE indicates that the provider optimizes for visual content, while FALSE indicates that the provider optimizes for virtual content. For more information, see <a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-workingwithvirtualizeditems">Working with Virtualized Items</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-automation-element-propids">Automation Element Property IDs</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationelement2-get_currentoptimizeforvisualcontent">CurrentOptimizeForVisualContent</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement2">IUIAutomationElement2</a>



<b>Reference</b>
 

 

