---
UID: NE:uiautomationcore.CaretBidiMode
title: CaretBidiMode (uiautomationcore.h)
description: Contains possible values for the CaretBidiMode text attribute, which indicates whether the caret is in text that flows from left to right, or from right to left.
old-location: winauto\uiauto_CaretBidiMode.htm
tech.root: WinAuto
ms.assetid: F11B7A18-E9C2-43FA-ABEB-00C61C1C7A83
ms.date: 12/05/2018
ms.keywords: CaretBidiMode, CaretBidiMode enumeration [Windows Accessibility], CaretBidiMode_LTR, CaretBidiMode_RTL, uiautomationcore/CaretBidiMode, uiautomationcore/CaretBidiMode_LTR, uiautomationcore/CaretBidiMode_RTL, winauto.uiauto_CaretBidiMode
f1_keywords:
- uiautomationcore/CaretBidiMode
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationCore.h
api_name:
- CaretBidiMode
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CaretBidiMode enumeration


## -description


Contains possible values for the <a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-textattribute-ids">CaretBidiMode</a> text attribute, which indicates whether the caret is in text that flows from left to right, or from right to left.


## -enum-fields




### -field CaretBidiMode_LTR

The caret is in text that flows from left to right.


### -field CaretBidiMode_RTL

The caret is in text that flows from right to left.

