---
UID: NE:uiautomationcore.TextDecorationLineStyle
title: TextDecorationLineStyle (uiautomationcore.h)
description: Contains values that specify the OverlineStyle, StrikethroughStyle, and UnderlineStyle text attributes.
old-location: winauto\uiauto_TextDecLineStyle.htm
tech.root: WinAuto
ms.assetid: e9f618d6-656f-41e2-8ca5-32d7209e8058
ms.date: 12/05/2018
ms.keywords: TextDecorationLineStyle, TextDecorationLineStyle enumeration [Windows Accessibility], TextDecorationLineStyle_Dash, TextDecorationLineStyle_DashDot, TextDecorationLineStyle_DashDotDot, TextDecorationLineStyle_Dot, TextDecorationLineStyle_Double, TextDecorationLineStyle_DoubleWavy, TextDecorationLineStyle_LongDash, TextDecorationLineStyle_None, TextDecorationLineStyle_Other, TextDecorationLineStyle_Single, TextDecorationLineStyle_ThickDash, TextDecorationLineStyle_ThickDashDot, TextDecorationLineStyle_ThickDashDotDot, TextDecorationLineStyle_ThickDot, TextDecorationLineStyle_ThickLongDash, TextDecorationLineStyle_ThickSingle, TextDecorationLineStyle_ThickWavy, TextDecorationLineStyle_Wavy, TextDecorationLineStyle_WordsOnly, uiauto.uiauto_TextDecLineStyle, uiauto_TextDecLineStyle, uiautomationcore/TextDecorationLineStyle, uiautomationcore/TextDecorationLineStyle_Dash, uiautomationcore/TextDecorationLineStyle_DashDot, uiautomationcore/TextDecorationLineStyle_DashDotDot, uiautomationcore/TextDecorationLineStyle_Dot, uiautomationcore/TextDecorationLineStyle_Double, uiautomationcore/TextDecorationLineStyle_DoubleWavy, uiautomationcore/TextDecorationLineStyle_LongDash, uiautomationcore/TextDecorationLineStyle_None, uiautomationcore/TextDecorationLineStyle_Other, uiautomationcore/TextDecorationLineStyle_Single, uiautomationcore/TextDecorationLineStyle_ThickDash, uiautomationcore/TextDecorationLineStyle_ThickDashDot, uiautomationcore/TextDecorationLineStyle_ThickDashDotDot, uiautomationcore/TextDecorationLineStyle_ThickDot, uiautomationcore/TextDecorationLineStyle_ThickLongDash, uiautomationcore/TextDecorationLineStyle_ThickSingle, uiautomationcore/TextDecorationLineStyle_ThickWavy, uiautomationcore/TextDecorationLineStyle_Wavy, uiautomationcore/TextDecorationLineStyle_WordsOnly, winauto.uiauto_TextDecLineStyle
f1_keywords:
- uiautomationcore/TextDecorationLineStyle
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationCore.h
api_name:
- TextDecorationLineStyle
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# TextDecorationLineStyle enumeration


## -description


Contains values that specify the OverlineStyle, StrikethroughStyle, and UnderlineStyle text attributes.


## -enum-fields




### -field TextDecorationLineStyle_None

No line style.


### -field TextDecorationLineStyle_Single

A single solid line.


### -field TextDecorationLineStyle_WordsOnly

Only words (not spaces) are underlined.


### -field TextDecorationLineStyle_Double

A double line.


### -field TextDecorationLineStyle_Dot

A dotted line.


### -field TextDecorationLineStyle_Dash

A dashed line.


### -field TextDecorationLineStyle_DashDot

Alternating dashes and dots.


### -field TextDecorationLineStyle_DashDotDot

A dash followed by two dots.


### -field TextDecorationLineStyle_Wavy

A wavy line.


### -field TextDecorationLineStyle_ThickSingle

A thick single line.


### -field TextDecorationLineStyle_DoubleWavy

A double wavy line.


### -field TextDecorationLineStyle_ThickWavy

A thick wavy line.


### -field TextDecorationLineStyle_LongDash

Long dashes.


### -field TextDecorationLineStyle_ThickDash

A thick dashed line.


### -field TextDecorationLineStyle_ThickDashDot

Thick dashes alternating with thick dots.


### -field TextDecorationLineStyle_ThickDashDotDot

A thick dash followed by two thick dots.


### -field TextDecorationLineStyle_ThickDot

A thick dotted line.


### -field TextDecorationLineStyle_ThickLongDash

Thick long dashes.


### -field TextDecorationLineStyle_Other

A line style not represented by another value.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-textattribute-ids">Text Attribute Identifiers</a>
 

 

