---
UID: NE:uiautomationcore.UIAutomationType
title: UIAutomationType (uiautomationcore.h)
description: Contains values used to indicate Microsoft UI Automation data types.
old-location: winauto\uiauto_UIAutomationTypeEnum.htm
tech.root: WinAuto
ms.assetid: 6090d5b5-2376-43ce-bef2-49bb3515107a
ms.date: 12/05/2018
ms.keywords: UIAutomationType, UIAutomationType enumeration [Windows Accessibility], UIAutomationType_Array, UIAutomationType_Bool, UIAutomationType_BoolArray, UIAutomationType_Double, UIAutomationType_DoubleArray, UIAutomationType_Element, UIAutomationType_ElementArray, UIAutomationType_Int, UIAutomationType_IntArray, UIAutomationType_Out, UIAutomationType_OutBool, UIAutomationType_OutBoolArray, UIAutomationType_OutDouble, UIAutomationType_OutDoubleArray, UIAutomationType_OutElement, UIAutomationType_OutElementArray, UIAutomationType_OutInt, UIAutomationType_OutIntArray, UIAutomationType_OutPoint, UIAutomationType_OutPointArray, UIAutomationType_OutRect, UIAutomationType_OutRectArray, UIAutomationType_OutString, UIAutomationType_OutStringArray, UIAutomationType_Point, UIAutomationType_PointArray, UIAutomationType_Rect, UIAutomationType_RectArray, UIAutomationType_String, UIAutomationType_StringArray, uiauto.uiauto_UIAutomationTypeEnum, uiauto_UIAutomationTypeEnum, uiautomationcore/UIAutomationType, uiautomationcore/UIAutomationType_Array, uiautomationcore/UIAutomationType_Bool, uiautomationcore/UIAutomationType_BoolArray, uiautomationcore/UIAutomationType_Double, uiautomationcore/UIAutomationType_DoubleArray, uiautomationcore/UIAutomationType_Element, uiautomationcore/UIAutomationType_ElementArray, uiautomationcore/UIAutomationType_Int, uiautomationcore/UIAutomationType_IntArray, uiautomationcore/UIAutomationType_Out, uiautomationcore/UIAutomationType_OutBool, uiautomationcore/UIAutomationType_OutBoolArray, uiautomationcore/UIAutomationType_OutDouble, uiautomationcore/UIAutomationType_OutDoubleArray, uiautomationcore/UIAutomationType_OutElement, uiautomationcore/UIAutomationType_OutElementArray, uiautomationcore/UIAutomationType_OutInt, uiautomationcore/UIAutomationType_OutIntArray, uiautomationcore/UIAutomationType_OutPoint, uiautomationcore/UIAutomationType_OutPointArray, uiautomationcore/UIAutomationType_OutRect, uiautomationcore/UIAutomationType_OutRectArray, uiautomationcore/UIAutomationType_OutString, uiautomationcore/UIAutomationType_OutStringArray, uiautomationcore/UIAutomationType_Point, uiautomationcore/UIAutomationType_PointArray, uiautomationcore/UIAutomationType_Rect, uiautomationcore/UIAutomationType_RectArray, uiautomationcore/UIAutomationType_String, uiautomationcore/UIAutomationType_StringArray, winauto.uiauto_UIAutomationTypeEnum
f1_keywords:
- uiautomationcore/UIAutomationType
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista, Windows XP with SP3 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008, Windows Server 2003 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationCore.h
api_name:
- UIAutomationType
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# UIAutomationType enumeration


## -description


Contains values used to indicate Microsoft UI Automation data types.


## -enum-fields




### -field UIAutomationType_Int

An integer.


### -field UIAutomationType_Bool

An Boolean value.


### -field UIAutomationType_String

A null-terminated character string.


### -field UIAutomationType_Double

A double-precision floating-point number.


### -field UIAutomationType_Point

A <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structure containing the x- and y-coordinates of a point.


### -field UIAutomationType_Rect

A <a href="/windows/desktop/api/windef/ns-windef-rect">RECT</a> structure containing the coordinates of the upper-left and lower-right corners of a rectangle. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_Element

The address of the <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a> interface of a UI Automation element.


### -field UIAutomationType_Array

An array of an unspecified type.


### -field UIAutomationType_Out

The address of a variable that receives a value retrieved by a function.


### -field UIAutomationType_IntArray

An array of integers. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_BoolArray

An array of Boolean values. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_StringArray

An array of null-terminated character strings. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_DoubleArray

An array of double-precision floating-point numbers. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_PointArray

An array of <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structures, each containing the x- and y-coordinates of a point. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_RectArray

An array of <a href="/windows/desktop/api/windef/ns-windef-rect">RECT</a> structures, each containing the coordinates of the upper-left and lower-right corners of a rectangle. This type is not supported for a custom UI Automation property.


### -field UIAutomationType_ElementArray

An array of pointers to <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a> interfaces, each for a UI Automation element.


### -field UIAutomationType_OutInt

The address of a variable that receives an integer value.


### -field UIAutomationType_OutBool

The address of a variable that receives a Boolean value.


### -field UIAutomationType_OutString

The address of a variable that receives a null-terminated character string.


### -field UIAutomationType_OutDouble

The address of a variable that receives a double-precision floating-point number.


### -field UIAutomationType_OutPoint

The address of a variable that receives a <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structure.


### -field UIAutomationType_OutRect

The address of a variable that receives a <a href="/windows/desktop/api/windef/ns-windef-rect">RECT</a> structure.


### -field UIAutomationType_OutElement

The address of a variable that receives a pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a> interface of a UI Automation element.


### -field UIAutomationType_OutIntArray

The address of a variable that receives an array of integer values.


### -field UIAutomationType_OutBoolArray

The address of a variable that receives an array of Boolean values.


### -field UIAutomationType_OutStringArray

The address of a variable that receives an array of null-terminated character strings.


### -field UIAutomationType_OutDoubleArray

The address of a variable that receives an array of double-precision floating-point numbers.


### -field UIAutomationType_OutPointArray

The address of a variable that receives an array of <a href="https://docs.microsoft.com/previous-versions/dd162805(v=vs.85)">POINT</a> structures.


### -field UIAutomationType_OutRectArray

The address of a variable that receives an array of <a href="/windows/desktop/api/windef/ns-windef-rect">RECT</a> structures.


### -field UIAutomationType_OutElementArray

The address of a variable that receives an array of pointers to the <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nn-uiautomationclient-iuiautomationelement">IUIAutomationElement</a> interfaces of UI Automation elements.

