---
UID: NE:uiautomationcore.WindowVisualState
title: WindowVisualState (uiautomationcore.h)
description: Contains values that specify the visual state of a window.
old-location: winauto\uiauto_WindowVisualStateEnum.htm
tech.root: WinAuto
ms.assetid: 5912551c-2745-434b-98de-bf24212f7eef
ms.date: 12/05/2018
ms.keywords: WindowVisualState, WindowVisualState enumeration [Windows Accessibility], WindowVisualState_Maximized, WindowVisualState_Minimized, WindowVisualState_Normal, uiauto.uiauto_WindowVisualStateEnum, uiauto_WindowVisualStateEnum, uiautomationcore/WindowVisualState, uiautomationcore/WindowVisualState_Maximized, uiautomationcore/WindowVisualState_Minimized, uiautomationcore/WindowVisualState_Normal, winauto.uiauto_WindowVisualStateEnum
f1_keywords:
- uiautomationcore/WindowVisualState
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationCore.h
api_name:
- WindowVisualState
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# WindowVisualState enumeration


## -description


Contains values that specify the visual state of a window.


## -enum-fields




### -field WindowVisualState_Normal

The window is normal (restored).


### -field WindowVisualState_Maximized

The window is maximized.


### -field WindowVisualState_Minimized

The window is minimized.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nn-uiautomationcore-iwindowprovider">IWindowProvider</a>
 

 

