---
UID: NE:uiautomationcore.ZoomUnit
title: ZoomUnit (uiautomationcore.h)
description: Contains possible values for the IUIAutomationTransformPattern2::ZoomByUnit method, which zooms the viewport of a control by the specified unit.
old-location: winauto\uiauto_zoomunit.htm
tech.root: WinAuto
ms.assetid: 3ECDFCD7-2FBD-42C4-8863-4B5A557F56AE
ms.date: 12/05/2018
ms.keywords: ZoomUnit, ZoomUnit enumeration [Windows Accessibility], ZoomUnit_LargeDecrement, ZoomUnit_LargeIncrement, ZoomUnit_NoAmount, ZoomUnit_SmallDecrement, ZoomUnit_SmallIncrement, uiautomationcore/ ZoomUnit_NoAmount, uiautomationcore/ZoomUnit, uiautomationcore/ZoomUnit_LargeDecrement, uiautomationcore/ZoomUnit_LargeIncrement, uiautomationcore/ZoomUnit_SmallDecrement, uiautomationcore/ZoomUnit_SmallIncrement, winauto.uiauto_zoomunit
f1_keywords:
- uiautomationcore/ZoomUnit
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- UIAutomationCore.h
api_name:
- ZoomUnit
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ZoomUnit enumeration


## -description


Contains possible values for the <a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationtransformpattern2-zoombyunit">IUIAutomationTransformPattern2::ZoomByUnit</a> method, which zooms the viewport of a control by the specified unit.


## -enum-fields




### -field ZoomUnit_NoAmount

No increase or decrease in zoom.


### -field ZoomUnit_LargeDecrement

Decrease zoom by a large decrement.


### -field ZoomUnit_SmallDecrement

Decrease zoom by a small decrement.


### -field ZoomUnit_LargeIncrement

Increase zoom by a large increment.


### -field ZoomUnit_SmallIncrement

Increase zoom by a small increment.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationclient/nf-uiautomationclient-iuiautomationtransformpattern2-zoombyunit">IUIAutomationTransformPattern2::ZoomByUnit</a>
 

 

