---
UID: NF:uiautomationcore.IScrollProvider.get_HorizontalScrollPercent
title: IScrollProvider::get_HorizontalScrollPercent (uiautomationcore.h)
description: Specifies the horizontal scroll position.
old-location: winauto\uiauto_IScrollProvider_HorizontalScrollPercent.htm
tech.root: WinAuto
ms.assetid: 02affb6c-cacb-4305-beb3-7ccef8f0662a
ms.date: 12/05/2018
ms.keywords: HorizontalScrollPercent property [Windows Accessibility], HorizontalScrollPercent property [Windows Accessibility],IScrollProvider interface, IScrollProvider interface [Windows Accessibility],HorizontalScrollPercent property, IScrollProvider.HorizontalScrollPercent, IScrollProvider.get_HorizontalScrollPercent, IScrollProvider::HorizontalScrollPercent, IScrollProvider::get_HorizontalScrollPercent, get_HorizontalScrollPercent, uiauto.uiauto_IScrollProvider_HorizontalScrollPercent, uiauto_IScrollProvider_HorizontalScrollPercent, uiautomationcore/IScrollProvider::HorizontalScrollPercent, uiautomationcore/IScrollProvider::get_HorizontalScrollPercent, winauto.uiauto_IScrollProvider_HorizontalScrollPercent
f1_keywords:
- uiautomationcore/IScrollProvider.HorizontalScrollPercent
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2003 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationCore.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationCore.h
api_name:
- IScrollProvider.HorizontalScrollPercent
- IScrollProvider.get_HorizontalScrollPercent
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IScrollProvider::get_HorizontalScrollPercent


## -description


Specifies the horizontal scroll position.

This property is read-only.


## -parameters


## -remarks



The horizontal scroll position can be reported as <b>UIA_ScrollPatternNoScroll</b> if no valid position is available; for example, if the window does not have a horizontal scroll bar.




## -see-also




<b>Conceptual</b>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nn-uiautomationcore-iscrollprovider">IScrollProvider</a>



<b>Reference</b>



<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-providersoverview">UI Automation Providers Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nf-uiautomationcore-iscrollprovider-get_verticalscrollpercent">VerticalScrollPercent</a>
 

 

