---
UID: NF:uiautomationcore.IScrollProvider.get_VerticalScrollPercent
title: IScrollProvider::get_VerticalScrollPercent (uiautomationcore.h)
description: Specifies the vertical scroll position.
old-location: winauto\uiauto_IScrollProvider_VerticalScrollPercent.htm
tech.root: WinAuto
ms.assetid: 1bc153bf-1d8f-4ca6-88e0-882e063fe6a0
ms.date: 12/05/2018
ms.keywords: IScrollProvider interface [Windows Accessibility],VerticalScrollPercent property, IScrollProvider.VerticalScrollPercent, IScrollProvider.get_VerticalScrollPercent, IScrollProvider::VerticalScrollPercent, IScrollProvider::get_VerticalScrollPercent, VerticalScrollPercent property [Windows Accessibility], VerticalScrollPercent property [Windows Accessibility],IScrollProvider interface, get_VerticalScrollPercent, uiauto.uiauto_IScrollProvider_VerticalScrollPercent, uiauto_IScrollProvider_VerticalScrollPercent, uiautomationcore/IScrollProvider::VerticalScrollPercent, uiautomationcore/IScrollProvider::get_VerticalScrollPercent, winauto.uiauto_IScrollProvider_VerticalScrollPercent
f1_keywords:
- uiautomationcore/IScrollProvider.VerticalScrollPercent
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2003 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationCore.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationCore.h
api_name:
- IScrollProvider.VerticalScrollPercent
- IScrollProvider.get_VerticalScrollPercent
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IScrollProvider::get_VerticalScrollPercent


## -description


Specifies the vertical scroll position.

This property is read-only.


## -parameters


## -remarks



The vertical scroll position can be reported as <b>UIA_ScrollPatternNoScroll</b> if no valid position is available; for example, if the window does not have a vertical scroll bar.




## -see-also




<b>Conceptual</b>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nf-uiautomationcore-iscrollprovider-get_horizontalscrollpercent">HorizontalScrollPercent</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nn-uiautomationcore-iscrollprovider">IScrollProvider</a>



<b>Reference</b>



<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-providersoverview">UI Automation Providers Overview</a>
 

 

