---
UID: NF:uiautomationcore.ITextProvider.get_DocumentRange
title: ITextProvider::get_DocumentRange (uiautomationcore.h)
description: Retrieves a text range that encloses the main text of a document.
old-location: winauto\uiauto_ITextProvider_DocumentRange.htm
tech.root: WinAuto
ms.assetid: 38892548-7c1f-4bac-8eac-29d7b4d190d3
ms.date: 12/05/2018
ms.keywords: DocumentRange property [Windows Accessibility], DocumentRange property [Windows Accessibility],ITextProvider interface, ITextProvider interface [Windows Accessibility],DocumentRange property, ITextProvider.DocumentRange, ITextProvider.get_DocumentRange, ITextProvider::DocumentRange, ITextProvider::get_DocumentRange, get_DocumentRange, uiauto.uiauto_ITextProvider_DocumentRange, uiauto_ITextProvider_DocumentRange, uiautomationcore/ITextProvider::DocumentRange, uiautomationcore/ITextProvider::get_DocumentRange, winauto.uiauto_ITextProvider_DocumentRange
f1_keywords:
- uiautomationcore/ITextProvider.DocumentRange
dev_langs:
- c++
req.header: uiautomationcore.h
req.include-header: UIAutomation.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2003 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: UIAutomationCore.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- UIAutomationCore.h
api_name:
- ITextProvider.DocumentRange
- ITextProvider.get_DocumentRange
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ITextProvider::get_DocumentRange


## -description


Retrieves a text range that encloses the main text of a document. 

This property is read-only.


## -parameters


## -remarks



Some auxiliary text such as headers, footnotes, or annotations may not be included.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nn-uiautomationcore-itextprovider">ITextProvider</a>



<a href="https://docs.microsoft.com/windows/desktop/api/uiautomationcore/nn-uiautomationcore-itextrangeprovider">ITextRangeProvider</a>



<b>Reference</b>



<a href="https://docs.microsoft.com/windows/desktop/WinAuto/uiauto-providersoverview">UI Automation Providers Overview</a>
 

 

