---
UID: NE:uiribbon.UI_VIEWVERB
title: UI_VIEWVERB (uiribbon.h)
description: Specifies values that identify the type of action to complete on a Ribbon framework View.
old-location: windowsribbon\windowsribbon_ui_viewverb.htm
tech.root: windowsribbon
ms.assetid: VS|scenicintent|~\scenicintent\reference\enums\ui_view_verb.htm
ms.date: 12/05/2018
ms.keywords: UI_VIEWVERB, UI_VIEWVERB enumeration [Windows Ribbon], UI_VIEWVERB_CREATE, UI_VIEWVERB_DESTROY, UI_VIEWVERB_ERROR, UI_VIEWVERB_SIZE, scenicintent_UI_VIEWVERB, uiribbon/UI_VIEWVERB, uiribbon/UI_VIEWVERB_CREATE, uiribbon/UI_VIEWVERB_DESTROY, uiribbon/UI_VIEWVERB_ERROR, uiribbon/UI_VIEWVERB_SIZE, windowsribbon.windowsribbon_ui_viewverb
f1_keywords:
- uiribbon/UI_VIEWVERB
dev_langs:
- c++
req.header: uiribbon.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Uiribbon.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Uiribbon.h
api_name:
- UI_VIEWVERB
targetos: Windows
req.typenames: UI_VIEWVERB
req.redist: 
ms.custom: 19H1
---

# UI_VIEWVERB enumeration


## -description


Specifies values that identify the type of action to complete on a Ribbon framework View.


## -enum-fields




### -field UI_VIEWVERB_CREATE

Create a View.


### -field UI_VIEWVERB_DESTROY

Destroy a View.


### -field UI_VIEWVERB_SIZE

Resize a View.


### -field UI_VIEWVERB_ERROR

Unable to complete the action.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/windowsribbon/windowsribbon-reference-enumerations">Constants and Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/windowsribbon/windowsribbon-element-contextpopup">ContextPopup</a>



<a href="https://docs.microsoft.com/windows/desktop/windowsribbon/windowsribbon-element-ribbon">Ribbon</a>
 

 

