---
UID: NF:unknwnbase.IUnknown_QueryInterface_Proxy
title: IUnknown_QueryInterface_Proxy function (unknwnbase.h)
description: The IUnknown_QueryInterface_Proxy function implements the QueryInterface method for all interface proxies.
old-location: rpc\iunknown_queryinterface_proxy.htm
tech.root: Rpc
ms.assetid: 4f266740-e33a-4dc1-8ade-720308bb82fe
ms.date: 12/05/2018
ms.keywords: IUnknown_QueryInterface_Proxy, IUnknown_QueryInterface_Proxy function [RPC], rpc.iunknown_queryinterface_proxy, unknwnbase/IUnknown_QueryInterface_Proxy
f1_keywords:
- unknwnbase/IUnknown_QueryInterface_Proxy
dev_langs:
- c++
req.header: unknwnbase.h
req.include-header: Unknwn.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: RpcRT4.lib
req.dll: RpcRT4.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- RpcRT4.dll
api_name:
- IUnknown_QueryInterface_Proxy
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUnknown_QueryInterface_Proxy function


## -description


<p class="CCE_Message">[IUnknown_QueryInterface_Proxy is not supported and may be altered or unavailable in the future.]

The <b>IUnknown_QueryInterface_Proxy</b> function implements the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nf-unknwn-iunknown-queryinterface(q)">QueryInterface</a> method for all interface proxies.


## -parameters




### -param This [in]

Pointer to  the proxy object. 


### -param riid [in]

IID of the interface to be queried.


### -param ppvObject [out]

Address to a pointer whose interface is queried or null when an interface is not supported.


## -returns



Returns S_OK on success. 




## -remarks



This function is used internally by proxies that are generated by MIDL.



