---
UID: NF:upnphost.IUPnPRegistrar.GetUniqueDeviceName
title: IUPnPRegistrar::GetUniqueDeviceName (upnphost.h)
description: The GetUniqueDeviceName method retrieves the UDN for the specified device.
old-location: upnp\iupnpregistrar_getuniquedevicename.htm
tech.root: upnp
ms.assetid: dcffee59-8b2f-443c-915f-6d823018eadd
ms.date: 12/05/2018
ms.keywords: GetUniqueDeviceName, GetUniqueDeviceName method [UPnP APIs], GetUniqueDeviceName method [UPnP APIs],IUPnPRegistrar interface, IUPnPRegistrar interface [UPnP APIs],GetUniqueDeviceName method, IUPnPRegistrar.GetUniqueDeviceName, IUPnPRegistrar::GetUniqueDeviceName, _upnp_iupnpregistrar_getuniquedevicename, upnp.iupnpregistrar_getuniquedevicename, upnphost/IUPnPRegistrar::GetUniqueDeviceName
f1_keywords:
- upnphost/IUPnPRegistrar.GetUniqueDeviceName
dev_langs:
- c++
req.header: upnphost.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Upnphost.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Upnphost.dll
api_name:
- IUPnPRegistrar.GetUniqueDeviceName
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUPnPRegistrar::GetUniqueDeviceName


## -description


The 
<b>GetUniqueDeviceName</b> method retrieves the UDN for the specified device. The UDN has been generated by the device host for each embedded device. The template UDN in the device description is replaced by this generated UDN for each embedded device when the device is registered. This method is re-entrant.


## -parameters




### -param bstrDeviceIdentifier [in]

Specifies the identifier returned by 
<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerdevice">RegisterDevice</a> or 
<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerrunningdevice">RegisterRunningDevice</a>.


### -param bstrTemplateUDN [in]

Specifies the UDN from the device description template.


### -param pbstrUDN [out]

Receives the device's UDN that was generated by the device host.


## -returns



If the method succeeds, the return value is S_OK. Otherwise, the method returns one of the COM error codes defined in WinError.h.




## -remarks



Each UDN specified for a device in the device description template is replaced during registration. The device host replaces each UDN with a globally unique one.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nn-upnphost-iupnpregistrar">IUPnPRegistrar</a>
 

 

