---
UID: NF:upnphost.IUPnPRegistrar.UnregisterDevice
title: IUPnPRegistrar::UnregisterDevice (upnphost.h)
description: The UnregisterDevice method unregisters the device from the device host. A device is either temporarily or permanently unregistered.
old-location: upnp\iupnpregistrar_unregisterdevice.htm
tech.root: upnp
ms.assetid: 76fca00c-8638-4e2f-8dd1-20b24cde0108
ms.date: 12/05/2018
ms.keywords: IUPnPRegistrar interface [UPnP APIs],UnregisterDevice method, IUPnPRegistrar.UnregisterDevice, IUPnPRegistrar::UnregisterDevice, UnregisterDevice, UnregisterDevice method [UPnP APIs], UnregisterDevice method [UPnP APIs],IUPnPRegistrar interface, _upnp_iupnpregistrar_unregisterdevice, upnp.iupnpregistrar_unregisterdevice, upnphost/IUPnPRegistrar::UnregisterDevice
f1_keywords:
- upnphost/IUPnPRegistrar.UnregisterDevice
dev_langs:
- c++
req.header: upnphost.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Upnphost.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Upnphost.dll
api_name:
- IUPnPRegistrar.UnregisterDevice
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IUPnPRegistrar::UnregisterDevice


## -description


The 
<b>UnregisterDevice</b> method unregisters the device from the device host. A device is either temporarily or permanently unregistered.


## -parameters




### -param bstrDeviceIdentifier [in]

Specifies the device identifier of the device to unregister. The device identifier was returned from a previous call to 
<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerdevice">RegisterDevice</a> or 
<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerrunningdevice">RegisterRunningDevice</a>.


### -param fPermanent [in]

Specifies whether to permanently or temporarily unregister the device. Specify <b>TRUE</b> to unregister the device permanently from the device host. Specify <b>FALSE</b> to unregister it temporarily.


## -returns



If the method succeeds, the return value is S_OK. Otherwise, the method returns one of the COM error codes defined in WinError.h.




## -remarks



This method removes a device from the device host. If <i>fPermanent</i> is <b>TRUE</b>, then the device is permanently unregistered. Otherwise, the device persists in the device host's mapping of the device identifier (returned from 
<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerdevice">RegisterDevice</a> or 
<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerrunningdevice">RegisterRunningDevice</a>) to the UDN generated by the device host. If a device is unregistered temporarily, when the device is re-registered, use the previous UDN associated with the device.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nn-upnphost-iupnpregistrar">IUPnPRegistrar</a>



<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nn-upnphost-iupnpreregistrar">IUPnPReregistrar</a>



<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerdevice">IUPnPReregistrar::RegisterDevice</a>



<a href="https://docs.microsoft.com/windows/desktop/api/upnphost/nf-upnphost-iupnpregistrar-registerrunningdevice">IUPnPReregistrar::RegisterRunningDevice</a>
 

 

