---
UID: NF:usp10.ScriptStringOut
title: ScriptStringOut function (usp10.h)
description: Displays a string generated by a prior call to ScriptStringAnalyse and optionally adds highlighting.
old-location: intl\scriptstringout.htm
tech.root: Intl
ms.assetid: f9b188d4-00d3-461b-ae7d-bf12e7717748
ms.date: 12/05/2018
ms.keywords: ETO_CLIPPED, ETO_OPAQUE, ScriptStringOut, ScriptStringOut function [Internationalization for Windows Applications], _win32_ScriptStringOut, intl.scriptstringout, usp10/ScriptStringOut
f1_keywords:
- usp10/ScriptStringOut
dev_langs:
- c++
req.header: usp10.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Usp10.lib
req.dll: Usp10.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- usp10.dll
- Ext-MS-Win-GDI-Internal-Desktop-L1-1-0.dll
- GDI32.dll
- GDI32Full.dll
api_name:
- ScriptStringOut
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ScriptStringOut function


## -description


Displays a string generated by a prior call to <a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptstringanalyse">ScriptStringAnalyse</a> and optionally adds highlighting.


## -parameters




### -param ssa [in]

A <a href="https://docs.microsoft.com/windows/desktop/Intl/script-string-analysis">SCRIPT_STRING_ANALYSIS</a> structure for the string.


### -param iX [in]

The x-coordinate of the reference point used to position the string.


### -param iY [in]

The y-coordinate of the reference point used to position the string.


### -param uOptions [in]

Options specifying the use of the application-defined rectangle. This parameter can be set to 0 or to any of the following values. The values can be combined with binary OR.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="ETO_CLIPPED"></a><a id="eto_clipped"></a><dl>
<dt><b>ETO_CLIPPED</b></dt>
</dl>
</td>
<td width="60%">
Clip text to the rectangle.

</td>
</tr>
<tr>
<td width="40%"><a id="ETO_OPAQUE"></a><a id="eto_opaque"></a><dl>
<dt><b>ETO_OPAQUE</b></dt>
</dl>
</td>
<td width="60%">
Use current background color to fill the rectangle.

</td>
</tr>
</table>
 


### -param prc [in, optional]

Pointer to a <a href="/windows/desktop/api/windef/ns-windef-rect">RECT</a> structure that defines the rectangle to use. If <i>uOptions</i> is set to ETO_OPAQUE and <b>NULL</b> is provided for <i>prc</i>, the function succeeds and returns S_OK. However, if the application sets <i>uOptions</i> to ETO_CLIPPING and provides <b>NULL</b> for <i>prc</i>, the function returns E_INVALIDARG. The application can set this parameter to <b>NULL</b> to indicate that no option is needed.


### -param iMinSel [in]

Zero-based index specifying the starting position in the string. For no selection, the application should set <i>iMinSel</i> &gt;= <i>iMaxSel</i>.


### -param iMaxSel [in]

Zero-based index specifying the ending position in the string.


### -param fDisabled [in]

<b>TRUE</b> if the operating system applies disabled-text highlighting by setting the background color to COLOR_HIGHLIGHT behind all selected characters. The application can set this parameter to <b>FALSE</b> if the operating system applies enabled-text highlighting by setting the background color to COLOR_HIGHLIGHT and the text color to COLOR_HIGHLIGHTTEXT for each selected character.


## -returns



Returns S_OK if successful. The function returns a nonzero <b>HRESULT</b> value if it does not succeed. The application can't test the return value with the <b>SUCCEEDED</b> and <b>FAILED</b> macros.




## -remarks



To use this function, the application needs to specify SSA_GLYPHS in its original call to <a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptstringanalyse">ScriptStringAnalyse</a>.

The application should not use <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-settextalign">SetTextAlign</a> with TA_UPDATECP when using <b>ScriptStringOut</b> because selected text cannot be rendered correctly. If the application must use this flag, it can unset and reset the flag as necessary to avoid the problem.

<div class="alert"><b>Important</b>  Starting with Windows 8: To maintain the ability to run on Windows 7, a module that uses Uniscribe must specify Usp10.lib before gdi32.lib in its library list.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Intl/script-string-analysis">SCRIPT_STRING_ANALYSIS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptstringanalyse">ScriptStringAnalyse</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/uniscribe">Uniscribe</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/uniscribe-functions">Uniscribe Functions</a>
 

 

