---
UID: NS:usp10.script_glyphprop
title: SCRIPT_GLYPHPROP (usp10.h)
description: Contains information about a glyph that is part of an output glyph array.
old-location: intl\script_glyphprop.htm
tech.root: Intl
ms.assetid: 5d68c8b6-77dd-48f7-b05a-0c02c9271097
ms.date: 12/05/2018
ms.keywords: SCRIPT_GLYPHPROP, SCRIPT_GLYPHPROP structure [Internationalization for Windows Applications], _win32_SCRIPT_GLYPHPROP, intl.script_glyphprop, usp10/SCRIPT_GLYPHPROP
f1_keywords:
- usp10/SCRIPT_GLYPHPROP
dev_langs:
- c++
req.header: usp10.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Usp10.h
api_name:
- SCRIPT_GLYPHPROP
targetos: Windows
req.typenames: SCRIPT_GLYPHPROP
req.redist: Usp10.dll version 1.600 or greater onWindows XP
ms.custom: 19H1
---

# SCRIPT_GLYPHPROP structure


## -description



Contains information about a glyph that is part of an output glyph array.




## -struct-fields




### -field sva

A buffer of <a href="https://docs.microsoft.com/windows/win32/api/usp10/ns-usp10-script_visattr">SCRIPT_VISATTR</a> structures defining visual (glyph) attributes identifying clusters and justification points. The buffer is generated by <a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptshape">ScriptShape</a> or <a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptshapeopentype">ScriptShapeOpenType</a>.


### -field reserved

Reserved.


## -see-also




<a href="https://docs.microsoft.com/windows/win32/api/usp10/ns-usp10-script_visattr">SCRIPT_VISATTR</a>



<a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptplaceopentype">ScriptPlaceOpenType</a>



<a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptshape">ScriptShape</a>



<a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptshapeopentype">ScriptShapeOpenType</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/uniscribe">Uniscribe</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/uniscribe-structures">Uniscribe Structures</a>
 

 

