---
UID: NS:usp10.tag_SCRIPT_VISATTR
title: SCRIPT_VISATTR (usp10.h)
description: Contains the visual (glyph) attributes that identify clusters and justification points, as generated by ScriptShape.
old-location: intl\script_visattr.htm
tech.root: Intl
ms.assetid: 83b77f60-2520-49ee-bc7f-27cb3db02ac8
ms.date: 12/05/2018
ms.keywords: FALSE, SCRIPT_VISATTR, SCRIPT_VISATTR structure [Internationalization for Windows Applications], TRUE, _win32_SCRIPT_VISATTR_str, intl.script_visattr, usp10/SCRIPT_VISATTR
f1_keywords:
- usp10/SCRIPT_VISATTR
dev_langs:
- c++
req.header: usp10.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Usp10.h
api_name:
- SCRIPT_VISATTR
targetos: Windows
req.typenames: SCRIPT_VISATTR
req.redist: Internet Explorer 5 or later onWindows Me/98/95
ms.custom: 19H1
---

# SCRIPT_VISATTR structure


## -description



Contains the visual (glyph) attributes that identify clusters and justification points, as generated by <a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptshape">ScriptShape</a>.




## -struct-fields




### -field uJustification

Justification class for the glyph. See <a href="https://docs.microsoft.com/windows/win32/api/usp10/ne-usp10-script_justify">SCRIPT_JUSTIFY</a>.


### -field fClusterStart

Value indicating the logical first glyph in every cluster, even for clusters containing just one glyph. Possible values are defined in the following table.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TRUE"></a><a id="true"></a><dl>
<dt><b>TRUE</b></dt>
</dl>
</td>
<td width="60%">
The glyph is the logical first glyph of the cluster.

</td>
</tr>
<tr>
<td width="40%"><a id="FALSE"></a><a id="false"></a><dl>
<dt><b>FALSE</b></dt>
</dl>
</td>
<td width="60%">
The glyph is not the logical first glyph of the cluster.

</td>
</tr>
</table>
 


### -field fDiacritic

Value indicating if a glyph combines with base characters. Possible values are defined in the following table.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TRUE"></a><a id="true"></a><dl>
<dt><b>TRUE</b></dt>
</dl>
</td>
<td width="60%">
The glyph does combine with base characters.

</td>
</tr>
<tr>
<td width="40%"><a id="FALSE"></a><a id="false"></a><dl>
<dt><b>FALSE</b></dt>
</dl>
</td>
<td width="60%">
The glyph does not combine with base characters.

</td>
</tr>
</table>
 


### -field fZeroWidth

Value set by the shaping engine to indicate a zero-width character, such as ZWJ and ZWNJ. This value is set for some, but not all, zero-width characters. Possible values are defined in the following table.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="TRUE"></a><a id="true"></a><dl>
<dt><b>TRUE</b></dt>
</dl>
</td>
<td width="60%">
The glyph indicates a zero-width character.

</td>
</tr>
<tr>
<td width="40%"><a id="FALSE"></a><a id="false"></a><dl>
<dt><b>FALSE</b></dt>
</dl>
</td>
<td width="60%">
The glyph does not indicate a zero-width character.

</td>
</tr>
</table>
 


### -field fReserved

Reserved; always initialize to 0.


### -field fShapeReserved

Reserved; for use by shaping engines.


## -see-also




<a href="https://docs.microsoft.com/windows/win32/api/usp10/ne-usp10-script_justify">SCRIPT_JUSTIFY</a>



<a href="https://docs.microsoft.com/windows/desktop/api/usp10/nf-usp10-scriptshape">ScriptShape</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/uniscribe">Uniscribe</a>



<a href="https://docs.microsoft.com/windows/desktop/Intl/uniscribe-structures">Uniscribe Structures</a>
 

 

