---
UID: NF:uxtheme.BufferedPaintRenderAnimation
title: BufferedPaintRenderAnimation function (uxtheme.h)
description: Paints the next frame of a buffered paint animation.
old-location: controls\BufferedPaintRenderAnimation.htm
tech.root: Controls
ms.assetid: VS|Controls|~\controls\userex\functions\bufferedpaintrenderanimation.htm
ms.date: 12/05/2018
ms.keywords: BufferedPaintRenderAnimation, BufferedPaintRenderAnimation function [Windows Controls], _shell_BufferedPaintRenderAnimation, _shell_BufferedPaintRenderAnimation_cpp, controls.BufferedPaintRenderAnimation, controls._shell_BufferedPaintRenderAnimation, uxtheme/BufferedPaintRenderAnimation
f1_keywords:
- uxtheme/BufferedPaintRenderAnimation
dev_langs:
- c++
req.header: uxtheme.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: UxTheme.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- UxTheme.dll
api_name:
- BufferedPaintRenderAnimation
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# BufferedPaintRenderAnimation function


## -description


Paints the next frame of a buffered paint animation.


## -parameters




### -param hwnd

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HWND</a></b>

Handle to the window in which the animations play.


### -param hdcTarget

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HDC</a></b>

Handle of the target DC on which the buffer is animated.


## -returns



Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BOOL</a></b>

Returns <b>TRUE</b> if the frame has been painted, or <b>FALSE</b> otherwise.




## -remarks



If this function returns <b>TRUE</b>, the application should do no further painting. If this function returns <b>FALSE</b>, the application should paint normally.

An application calls this function within its <a href="https://docs.microsoft.com/windows/desktop/gdi/wm-paint">WM_PAINT</a> handler.  After <b>BufferedPaintRenderAnimation</b> paints an animation frame, an application will typically continue without performing its usual painting operations.  If appropriate, an application may choose to render additional user interface (UI) over the top of the animation. The following code example, to be included as part of a larger body of code, shows how to use the animation painting functions.


```cpp
    if (!_fBufferedPaintInit)
    {
        BufferedPaintInit();
        _fBufferedPaintInit = TRUE;
    }

    // Determine whether the paint message was generated by a softfade animation.
    if (!BufferedPaintRenderAnimation(hWnd, hdc))
    {
        // Initialize buffered paint parameters.
        BP_ANIMATIONPARAMS animParams = {sizeof(BP_ANIMATIONPARAMS)};
        animParams.style = BPAS_LINEAR; 
        animParams.dwDuration = 0;
        GetThemeTransitionDuration(hTheme, iPartId, iStateIdFrom, 
                iStateIdTo, TMT_TRANSITIONDURATIONS, &animParams.dwDuration);

        HDC hdcFrom, hdcTo;
        HANIMATIONBUFFER hbpAnimation = BeginBufferedAnimation(hWnd, hdc, &rc, 
                BPBF_COMPATIBLEBITMAP, NULL, &animParams, &hdcFrom, &hdcTo);
        if (hbpAnimation)
        {
            if (hdcFrom)
            {
                PaintImpl(hdcFrom, iPartId, iStateIdFrom /*, ...*/);
            }
            if (hdcTo)
            {
                PaintImpl(hdcTo, iPartId, iStateIdTo/*, ...*/);
            }

            EndBufferedAnimation(hbpAnimation, TRUE);
        }
        else
        {
            // Default to unbuffered paint
            PaintImpl(hdc, iPartId, iStateIdTo/*, ...*/);
       
        }
    }
    // Else do not paint because the BufferedPaintRenderAnimation function 
    // already did.
}

```




