---
UID: NE:vds._VDS_ISCSI_LOGIN_FLAG
title: VDS_ISCSI_LOGIN_FLAG (vds.h)
description: Defines the set of valid flags for specifying iSCSI target login options.
old-location: base\vds_iscsi_login_flag.htm
tech.root: VDS
ms.assetid: c315f5cc-2b15-4185-8d22-7114950273e7
ms.date: 12/05/2018
ms.keywords: VDS_ILF_MULTIPATH_ENABLED, VDS_ILF_REQUIRE_IPSEC, VDS_ISCSI_LOGIN_FLAG, VDS_ISCSI_LOGIN_FLAG enumeration [VDS], base.vds_iscsi_login_flag, vds/VDS_ILF_MULTIPATH_ENABLED, vds/VDS_ILF_REQUIRE_IPSEC, vds/VDS_ISCSI_LOGIN_FLAG, vdshwprv/VDS_ILF_MULTIPATH_ENABLED, vdshwprv/VDS_ILF_REQUIRE_IPSEC, vdshwprv/VDS_ISCSI_LOGIN_FLAG
f1_keywords:
- vds/VDS_ISCSI_LOGIN_FLAG
dev_langs:
- c++
req.header: vds.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_ISCSI_LOGIN_FLAG
targetos: Windows
req.typenames: VDS_ISCSI_LOGIN_FLAG
req.redist: VDS 1.1
ms.custom: 19H1
---

# VDS_ISCSI_LOGIN_FLAG enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of valid flags for specifying iSCSI target login options.
   


## -enum-fields




### -field VDS_ILF_REQUIRE_IPSEC

Reserved for future use.
      


### -field VDS_ILF_MULTIPATH_ENABLED

If this flag is set, the login is allowed to proceed and create a new login session even if there is already a login session to the target.
      

<div class="alert"><b>Note</b>  Multipathing software must be present or else data corruption may occur.</div>
<div> </div>

## -remarks



<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_ISCSI_LOGIN_FLAG</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_ISCSI_LOGIN_FLAG</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsiscsiinitiatoradapter-logintotarget">IVdsIscsiInitiatorAdapter::LoginToTarget</a>



<a href="https://docs.microsoft.com/windows/desktop/VDS/vds-enumerations">VDS Enumerations</a>
 

 

