---
UID: NE:vds._VDS_LUN_PLEX_TYPE
title: VDS_LUN_PLEX_TYPE (vds.h)
description: Defines the set of valid types for a LUN plex.
old-location: base\vds_lun_plex_type.htm
tech.root: VDS
ms.assetid: 06aefde9-429b-4a58-923e-c3db6028eeb5
ms.date: 12/05/2018
ms.keywords: VDS_LPT_PARITY, VDS_LPT_RAID03, VDS_LPT_RAID05, VDS_LPT_RAID10, VDS_LPT_RAID15, VDS_LPT_RAID2, VDS_LPT_RAID3, VDS_LPT_RAID30, VDS_LPT_RAID4, VDS_LPT_RAID5, VDS_LPT_RAID50, VDS_LPT_RAID53, VDS_LPT_RAID6, VDS_LPT_RAID60, VDS_LPT_SIMPLE, VDS_LPT_SPAN, VDS_LPT_STRIPE, VDS_LPT_UNKNOWN, VDS_LUN_PLEX_TYPE, VDS_LUN_PLEX_TYPE enumeration [VDS], base.vds_lun_plex_type, vds/VDS_LPT_PARITY, vds/VDS_LPT_RAID03, vds/VDS_LPT_RAID05, vds/VDS_LPT_RAID10, vds/VDS_LPT_RAID15, vds/VDS_LPT_RAID2, vds/VDS_LPT_RAID3, vds/VDS_LPT_RAID30, vds/VDS_LPT_RAID4, vds/VDS_LPT_RAID5, vds/VDS_LPT_RAID50, vds/VDS_LPT_RAID53, vds/VDS_LPT_RAID6, vds/VDS_LPT_RAID60, vds/VDS_LPT_SIMPLE, vds/VDS_LPT_SPAN, vds/VDS_LPT_STRIPE, vds/VDS_LPT_UNKNOWN, vds/VDS_LUN_PLEX_TYPE, vdshwprv/VDS_LPT_PARITY, vdshwprv/VDS_LPT_RAID03, vdshwprv/VDS_LPT_RAID05, vdshwprv/VDS_LPT_RAID10, vdshwprv/VDS_LPT_RAID15, vdshwprv/VDS_LPT_RAID2, vdshwprv/VDS_LPT_RAID3, vdshwprv/VDS_LPT_RAID30, vdshwprv/VDS_LPT_RAID4, vdshwprv/VDS_LPT_RAID5, vdshwprv/VDS_LPT_RAID50, vdshwprv/VDS_LPT_RAID53, vdshwprv/VDS_LPT_RAID6, vdshwprv/VDS_LPT_RAID60, vdshwprv/VDS_LPT_SIMPLE, vdshwprv/VDS_LPT_SPAN, vdshwprv/VDS_LPT_STRIPE, vdshwprv/VDS_LPT_UNKNOWN, vdshwprv/VDS_LUN_PLEX_TYPE
f1_keywords:
- vds/VDS_LUN_PLEX_TYPE
dev_langs:
- c++
req.header: vds.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_LUN_PLEX_TYPE
targetos: Windows
req.typenames: VDS_LUN_PLEX_TYPE
req.redist: 
ms.custom: 19H1
---

# VDS_LUN_PLEX_TYPE enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of valid types for a LUN plex.


## -enum-fields




### -field VDS_LPT_UNKNOWN

This value is reserved.


### -field VDS_LPT_SIMPLE

The plex type is simple—it is composed of extents from exactly one drive.


### -field VDS_LPT_SPAN

The plex type is spanned—it is composed of extents from more than one drive.


### -field VDS_LPT_STRIPE

The plex type is striped, which is equivalent to RAID 0.


### -field VDS_LPT_PARITY

The plex type is striped with parity, which accounts for RAID levels 3, 4, 5, and 6.


### -field VDS_LPT_RAID2

The plex type is RAID level 2.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID3

The plex type is RAID level 3.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID4

The plex type is RAID level 4.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID5

The plex type is RAID level 5.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID6

The plex type is RAID level 6.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID03

The plex type is RAID level 0+3.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID05

The plex type is RAID level 0+5.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID10

The plex type is RAID level 1+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID15

The plex type is RAID level 1+5.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID30

The plex type is RAID level 3+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID50

The plex type is RAID level 5+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID53

The plex type is RAID level 5+3.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LPT_RAID60

The plex type is RAID level 6+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


## -remarks



The  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_lun_plex_prop">VDS_LUN_PLEX_PROP</a>structure includes a <b>VDS_LUN_PLEX_TYPE</b> value as a member to indicate the existing plex type.

If your application encounters a <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_hwprovider_type">VDS_HWPROVIDER_TYPE</a> value that it does not recognize, it should display the provider type as unknown. It should not attempt to map the unrecognized provider type to another provider type.

<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_LUN_PLEX_TYPE</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_LUN_PLEX_TYPE</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/VDS/vds-enumerations">VDS Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_lun_plex_prop">VDS_LUN_PLEX_PROP</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_lun_type">VDS_LUN_TYPE</a>
 

 

