---
UID: NE:vdshwprv._VDS_ASYNC_OUTPUT_TYPE
title: VDS_ASYNC_OUTPUT_TYPE (vdshwprv.h)
description: Defines the set of operations that objects can process.
old-location: base\vds_async_output_type.htm
tech.root: VDS
ms.assetid: c2c0403a-30b9-4619-8bcb-3b73b637509e
ms.date: 12/05/2018
ms.keywords: VDS_ASYNCOUT_ADDLUNPLEX, VDS_ASYNCOUT_ADDPORTAL, VDS_ASYNCOUT_ADDVOLUMEPLEX, VDS_ASYNCOUT_ATTACH_VDISK, VDS_ASYNCOUT_BREAKVOLUMEPLEX, VDS_ASYNCOUT_CLEAN, VDS_ASYNCOUT_COMPACT_VDISK, VDS_ASYNCOUT_CREATELUN, VDS_ASYNCOUT_CREATEPARTITION, VDS_ASYNCOUT_CREATEPORTALGROUP, VDS_ASYNCOUT_CREATETARGET, VDS_ASYNCOUT_CREATEVOLUME, VDS_ASYNCOUT_CREATE_VDISK, VDS_ASYNCOUT_DELETEPORTALGROUP, VDS_ASYNCOUT_DELETETARGET, VDS_ASYNCOUT_EXPAND_VDISK, VDS_ASYNCOUT_EXTENDLUN, VDS_ASYNCOUT_EXTENDVOLUME, VDS_ASYNCOUT_FORMAT, VDS_ASYNCOUT_LOGINTOTARGET, VDS_ASYNCOUT_LOGOUTFROMTARGET, VDS_ASYNCOUT_MERGE_VDISK, VDS_ASYNCOUT_RECOVERLUN, VDS_ASYNCOUT_RECOVERPACK, VDS_ASYNCOUT_REMOVELUNPLEX, VDS_ASYNCOUT_REMOVEPORTAL, VDS_ASYNCOUT_REMOVEVOLUMEPLEX, VDS_ASYNCOUT_REPAIRVOLUMEPLEX, VDS_ASYNCOUT_REPLACEDISK, VDS_ASYNCOUT_SHRINKLUN, VDS_ASYNCOUT_SHRINKVOLUME, VDS_ASYNCOUT_UNKNOWN, VDS_ASYNC_OUTPUT_TYPE, VDS_ASYNC_OUTPUT_TYPE enumeration [VDS], base.vds_async_output_type, vds/VDS_ASYNCOUT_ADDLUNPLEX, vds/VDS_ASYNCOUT_ADDPORTAL, vds/VDS_ASYNCOUT_ADDVOLUMEPLEX, vds/VDS_ASYNCOUT_ATTACH_VDISK, vds/VDS_ASYNCOUT_BREAKVOLUMEPLEX, vds/VDS_ASYNCOUT_CLEAN, vds/VDS_ASYNCOUT_COMPACT_VDISK, vds/VDS_ASYNCOUT_CREATELUN, vds/VDS_ASYNCOUT_CREATEPARTITION, vds/VDS_ASYNCOUT_CREATEPORTALGROUP, vds/VDS_ASYNCOUT_CREATETARGET, vds/VDS_ASYNCOUT_CREATEVOLUME, vds/VDS_ASYNCOUT_CREATE_VDISK, vds/VDS_ASYNCOUT_DELETEPORTALGROUP, vds/VDS_ASYNCOUT_DELETETARGET, vds/VDS_ASYNCOUT_EXPAND_VDISK, vds/VDS_ASYNCOUT_EXTENDLUN, vds/VDS_ASYNCOUT_EXTENDVOLUME, vds/VDS_ASYNCOUT_FORMAT, vds/VDS_ASYNCOUT_LOGINTOTARGET, vds/VDS_ASYNCOUT_LOGOUTFROMTARGET, vds/VDS_ASYNCOUT_MERGE_VDISK, vds/VDS_ASYNCOUT_RECOVERLUN, vds/VDS_ASYNCOUT_RECOVERPACK, vds/VDS_ASYNCOUT_REMOVELUNPLEX, vds/VDS_ASYNCOUT_REMOVEPORTAL, vds/VDS_ASYNCOUT_REMOVEVOLUMEPLEX, vds/VDS_ASYNCOUT_REPAIRVOLUMEPLEX, vds/VDS_ASYNCOUT_REPLACEDISK, vds/VDS_ASYNCOUT_SHRINKLUN, vds/VDS_ASYNCOUT_SHRINKVOLUME, vds/VDS_ASYNCOUT_UNKNOWN, vds/VDS_ASYNC_OUTPUT_TYPE, vdshwprv/VDS_ASYNCOUT_ADDLUNPLEX, vdshwprv/VDS_ASYNCOUT_ADDPORTAL, vdshwprv/VDS_ASYNCOUT_ADDVOLUMEPLEX, vdshwprv/VDS_ASYNCOUT_ATTACH_VDISK, vdshwprv/VDS_ASYNCOUT_BREAKVOLUMEPLEX, vdshwprv/VDS_ASYNCOUT_CLEAN, vdshwprv/VDS_ASYNCOUT_COMPACT_VDISK, vdshwprv/VDS_ASYNCOUT_CREATELUN, vdshwprv/VDS_ASYNCOUT_CREATEPARTITION, vdshwprv/VDS_ASYNCOUT_CREATEPORTALGROUP, vdshwprv/VDS_ASYNCOUT_CREATETARGET, vdshwprv/VDS_ASYNCOUT_CREATEVOLUME, vdshwprv/VDS_ASYNCOUT_CREATE_VDISK, vdshwprv/VDS_ASYNCOUT_DELETEPORTALGROUP, vdshwprv/VDS_ASYNCOUT_DELETETARGET, vdshwprv/VDS_ASYNCOUT_EXPAND_VDISK, vdshwprv/VDS_ASYNCOUT_EXTENDLUN, vdshwprv/VDS_ASYNCOUT_EXTENDVOLUME, vdshwprv/VDS_ASYNCOUT_FORMAT, vdshwprv/VDS_ASYNCOUT_LOGINTOTARGET, vdshwprv/VDS_ASYNCOUT_LOGOUTFROMTARGET, vdshwprv/VDS_ASYNCOUT_MERGE_VDISK, vdshwprv/VDS_ASYNCOUT_RECOVERLUN, vdshwprv/VDS_ASYNCOUT_RECOVERPACK, vdshwprv/VDS_ASYNCOUT_REMOVELUNPLEX, vdshwprv/VDS_ASYNCOUT_REMOVEPORTAL, vdshwprv/VDS_ASYNCOUT_REMOVEVOLUMEPLEX, vdshwprv/VDS_ASYNCOUT_REPAIRVOLUMEPLEX, vdshwprv/VDS_ASYNCOUT_REPLACEDISK, vdshwprv/VDS_ASYNCOUT_SHRINKLUN, vdshwprv/VDS_ASYNCOUT_SHRINKVOLUME, vdshwprv/VDS_ASYNCOUT_UNKNOWN, vdshwprv/VDS_ASYNC_OUTPUT_TYPE
f1_keywords:
- vdshwprv/VDS_ASYNC_OUTPUT_TYPE
dev_langs:
- c++
req.header: vdshwprv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_ASYNC_OUTPUT_TYPE
targetos: Windows
req.typenames: VDS_ASYNC_OUTPUT_TYPE
req.redist: 
ms.custom: 19H1
---

# VDS_ASYNC_OUTPUT_TYPE enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of operations that objects can process.


## -enum-fields




### -field VDS_ASYNCOUT_UNKNOWN

The value is reserved.


### -field VDS_ASYNCOUT_CREATEVOLUME

The operation returns the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> pointer for the newly 
      created <a href="https://docs.microsoft.com/windows/desktop/VDS/volume-object">volume object</a>. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdspack-createvolume">IVdsPack::CreateVolume</a> method.


### -field VDS_ASYNCOUT_EXTENDVOLUME

The operation expands the size of the current volume by adding disk extents to each member of each plex. 
      For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolume-extend">IVdsVolume::Extend</a> method.


### -field VDS_ASYNCOUT_SHRINKVOLUME

The operation reduces the size of the volume and all plexes and returns the released extents to free 
      space. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolume-shrink">IVdsVolume::Shrink</a> method.


### -field VDS_ASYNCOUT_ADDVOLUMEPLEX

The operation adds a volume as a plex to the current volume. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolume-addplex">IVdsVolume::AddPlex</a> method.


### -field VDS_ASYNCOUT_BREAKVOLUMEPLEX

The operation returns the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> pointer for the 
      hidden <a href="https://docs.microsoft.com/windows/desktop/VDS/volume-object">volume object</a>. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolume-breakplex">IVdsVolume::BreakPlex</a> method.


### -field VDS_ASYNCOUT_REMOVEVOLUMEPLEX

The operation removes one or more specified plexes from the current volume, releasing the extents. For 
      operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolume-removeplex">IVdsVolume::RemovePlex</a> method.


### -field VDS_ASYNCOUT_REPAIRVOLUMEPLEX

The operation repairs a fault-tolerant volume plex by moving bad members to good disks. For operation 
      details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolumeplex-repair">IVdsVolumePlex::Repair</a> method.


### -field VDS_ASYNCOUT_RECOVERPACK

The operation returns a failing or failed pack to a healthy state, if possible. For operation details, see 
      the <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdspack-recover">IVdsPack::Recover</a> method.


### -field VDS_ASYNCOUT_REPLACEDISK

This value is reserved for future use.


### -field VDS_ASYNCOUT_CREATEPARTITION

The operation creates a new partition on a basic disk. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsadvanceddisk-createpartition">IVdsAdvancedDisk::CreatePartition</a> 
      method.


### -field VDS_ASYNCOUT_CLEAN

<a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsadvanceddisk-clean">IVdsAdvancedDisk::Clean</a>

### -field VDS_ASYNCOUT_CREATELUN

The operation returns the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> pointer for the newly 
      created <a href="https://docs.microsoft.com/windows/desktop/VDS/lun-object">LUN object</a>. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystem-createlun">IVdsSubSystem::CreateLun</a> method.


### -field VDS_ASYNCOUT_ADDLUNPLEX

The operation adds a LUN to the target LUN as a new plex. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdslun-addplex">IVdsLun::AddPlex</a> method.


### -field VDS_ASYNCOUT_REMOVELUNPLEX

The operation returns the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> pointer for the 
      removed <a href="https://docs.microsoft.com/windows/desktop/VDS/lun-object">LUN object</a>. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdslun-removeplex">IVdsLun::RemovePlex</a> method.


### -field VDS_ASYNCOUT_EXTENDLUN

The operation extends a LUN by a specified number of bytes. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdslun-extend">IVdsLun::Extend</a> method.


### -field VDS_ASYNCOUT_SHRINKLUN

The operation shrinks a LUN by a specified number of bytes. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdslun-shrink">IVdsLun::Shrink</a> method.


### -field VDS_ASYNCOUT_RECOVERLUN

The operation starts a recovery operation on a LUN. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdslun-recover">IVdsLun::Recover</a> method.


### -field VDS_ASYNCOUT_LOGINTOTARGET

The operation logs in to a target. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsiscsiinitiatoradapter-logintotarget">IVdsIscsiInitiatorAdapter::LoginToTarget</a> 
      method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_LOGOUTFROMTARGET

The operation logs out from a target. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsiscsiinitiatoradapter-logoutfromtarget">IVdsIscsiInitiatorAdapter::LogoutFromTarget</a> 
      method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_CREATETARGET

The operation returns the  <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface pointer 
      for the newly created target object. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystemiscsi-createtarget">IVdsSubSystemIscsi::CreateTarget</a> method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_CREATEPORTALGROUP

The operation returns the  <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface pointer 
      for the newly created portal group object. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsiscsitarget-createportalgroup">IVdsIscsiTarget::CreatePortalGroup</a> method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_DELETETARGET

The operation deletes a target. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsiscsitarget-delete">IVdsIscsiTarget::Delete</a> method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_ADDPORTAL

The operation adds a portal to a portal group. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsiscsiportalgroup-addportal">IVdsIscsiPortalGroup::AddPortal</a> method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_REMOVEPORTAL

The operation removes a portal from a portal group. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsiscsiportalgroup-removeportal">IVdsIscsiPortalGroup::RemovePortal</a> method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_DELETEPORTALGROUP

The operation deletes a portal group. For operation details, see the 
      <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdsiscsiportalgroup-delete">IVdsIscsiPortalGroup::Delete</a> method.

<b>Windows Server 2003:  </b>This flag is not supported before Windows Server 2003 R2.


### -field VDS_ASYNCOUT_FORMAT

The operation formats a volume. For operation details, see the
      <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvolumemf-format">IVdsVolumeMF::Format</a> method.


### -field VDS_ASYNCOUT_CREATE_VDISK

The operation creates a virtual disk. For operation details, see the <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsvdprovider-createvdisk">IVdsVdProvider::CreateVDisk</a> method.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


### -field VDS_ASYNCOUT_ATTACH_VDISK

The operation attaches a virtual disk. For operation details, see the <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsopenvdisk-attach">IVdsOpenVDisk::Attach</a> method.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


### -field VDS_ASYNCOUT_COMPACT_VDISK

The operation compacts a virtual disk to reduce the physical size of the backing file. For operation details, see the <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsopenvdisk-compact">IVdsOpenVDisk::Compact</a> method.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


### -field VDS_ASYNCOUT_MERGE_VDISK

The operation merges a child virtual disk with its parents in the differencing chain. For operation details, see the <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsopenvdisk-merge">IVdsOpenVDisk::Merge</a> method.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


### -field VDS_ASYNCOUT_EXPAND_VDISK

The operation increases the size of a virtual disk to the maximum available on a fixed-size or expandable disk. For operation details, see the <a href="https://docs.microsoft.com/windows/desktop/api/vds/nf-vds-ivdsopenvdisk-expand">IVdsOpenVDisk::Expand</a> method.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>Not supported.


## -remarks



The <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_async_output">VDS_ASYNC_OUTPUT</a> structure includes a <b>VDS_ASYNC_OUTPUT_TYPE</b> 
    value as a member to indicate an operation type.

<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_ASYNC_OUTPUT_TYPE</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_ASYNC_OUTPUT_TYPE</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/vds/nn-vds-ivdsadvanceddisk">IVdsAdvancedDisk</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vds/nn-vds-ivdsiscsiinitiatoradapter">IVdsIscsiInitiatorAdapter</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nn-vdshwprv-ivdsiscsiportalgroup">IVdsIscsiPortalGroup</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nn-vdshwprv-ivdsiscsitarget">IVdsIscsiTarget</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nn-vdshwprv-ivdslun">IVdsLun</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vds/nn-vds-ivdspack">IVdsPack</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nn-vdshwprv-ivdssubsystem">IVdsSubSystem</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nn-vdshwprv-ivdssubsystemiscsi">IVdsSubSystemIscsi</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vds/nn-vds-ivdsvolume">IVdsVolume</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vds/nn-vds-ivdsvolumeplex">IVdsVolumePlex</a>



<a href="https://docs.microsoft.com/windows/desktop/VDS/vds-enumerations">VDS Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_async_output">VDS_ASYNC_OUTPUT</a>
 

 

