---
UID: NE:vdshwprv._VDS_LUN_TYPE
title: VDS_LUN_TYPE (vdshwprv.h)
description: Defines the set of valid types for a LUN.
old-location: base\vds_lun_type.htm
tech.root: VDS
ms.assetid: 0952db7d-9dd6-4602-82d4-66d773c14463
ms.date: 12/05/2018
ms.keywords: '*PVDS_LUN_TYPE, VDS_LT_DEFAULT, VDS_LT_FAULT_TOLERANT, VDS_LT_MIRROR, VDS_LT_NON_FAULT_TOLERANT, VDS_LT_PARITY, VDS_LT_RAID01, VDS_LT_RAID03, VDS_LT_RAID05, VDS_LT_RAID10, VDS_LT_RAID15, VDS_LT_RAID2, VDS_LT_RAID3, VDS_LT_RAID30, VDS_LT_RAID4, VDS_LT_RAID5, VDS_LT_RAID50, VDS_LT_RAID51, VDS_LT_RAID53, VDS_LT_RAID6, VDS_LT_RAID60, VDS_LT_RAID61, VDS_LT_SIMPLE, VDS_LT_SPAN, VDS_LT_STRIPE, VDS_LT_UNKNOWN, VDS_LUN_TYPE, VDS_LUN_TYPE enumeration [VDS], base.vds_lun_type, vds/VDS_LT_DEFAULT, vds/VDS_LT_FAULT_TOLERANT, vds/VDS_LT_MIRROR, vds/VDS_LT_NON_FAULT_TOLERANT, vds/VDS_LT_PARITY, vds/VDS_LT_RAID01, vds/VDS_LT_RAID03, vds/VDS_LT_RAID05, vds/VDS_LT_RAID10, vds/VDS_LT_RAID15, vds/VDS_LT_RAID2, vds/VDS_LT_RAID3, vds/VDS_LT_RAID30, vds/VDS_LT_RAID4, vds/VDS_LT_RAID5, vds/VDS_LT_RAID50, vds/VDS_LT_RAID51, vds/VDS_LT_RAID53, vds/VDS_LT_RAID6, vds/VDS_LT_RAID60, vds/VDS_LT_RAID61, vds/VDS_LT_SIMPLE, vds/VDS_LT_SPAN, vds/VDS_LT_STRIPE, vds/VDS_LT_UNKNOWN, vds/VDS_LUN_TYPE, vdshwprv/VDS_LT_DEFAULT, vdshwprv/VDS_LT_FAULT_TOLERANT, vdshwprv/VDS_LT_MIRROR, vdshwprv/VDS_LT_NON_FAULT_TOLERANT, vdshwprv/VDS_LT_PARITY, vdshwprv/VDS_LT_RAID01, vdshwprv/VDS_LT_RAID03, vdshwprv/VDS_LT_RAID05, vdshwprv/VDS_LT_RAID10, vdshwprv/VDS_LT_RAID15, vdshwprv/VDS_LT_RAID2, vdshwprv/VDS_LT_RAID3, vdshwprv/VDS_LT_RAID30, vdshwprv/VDS_LT_RAID4, vdshwprv/VDS_LT_RAID5, vdshwprv/VDS_LT_RAID50, vdshwprv/VDS_LT_RAID51, vdshwprv/VDS_LT_RAID53, vdshwprv/VDS_LT_RAID6, vdshwprv/VDS_LT_RAID60, vdshwprv/VDS_LT_RAID61, vdshwprv/VDS_LT_SIMPLE, vdshwprv/VDS_LT_SPAN, vdshwprv/VDS_LT_STRIPE, vdshwprv/VDS_LT_UNKNOWN, vdshwprv/VDS_LUN_TYPE'
f1_keywords:
- vdshwprv/VDS_LUN_TYPE
dev_langs:
- c++
req.header: vdshwprv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_LUN_TYPE
targetos: Windows
req.typenames: VDS_LUN_TYPE, *PVDS_LUN_TYPE
req.redist: 
ms.custom: 19H1
---

# VDS_LUN_TYPE enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of valid types for a LUN.


## -enum-fields




### -field VDS_LT_UNKNOWN

This value is reserved.


### -field VDS_LT_DEFAULT

The LUN type is default automagic—the provider configures the LUN automatically based on hints. This value is used as an input parameter only; it is not returned by queries.


### -field VDS_LT_FAULT_TOLERANT

The LUN type is fault tolerant automagic—the provider configures the LUN automatically based on hints, but with the requirement that the resulting LUN is fault tolerant. This value is used as an input parameter only; it is not returned by queries.


### -field VDS_LT_NON_FAULT_TOLERANT

The LUN type is non-fault tolerant automagic—the provider configures the LUN automatically based on hints, but with the requirement that the resulting LUN is non-fault tolerant. This value is used as an input parameter only; it is not returned by queries.


### -field VDS_LT_SIMPLE

The LUN type is simple—it is composed of extents from exactly one drive.


### -field VDS_LT_SPAN

The LUN's type is spanned—it is composed of extents from more than one drive.


### -field VDS_LT_STRIPE

The LUN type is striped, which is equivalent to RAID 0.


### -field VDS_LT_MIRROR

The LUN type is mirrored, which is equivalent to RAID 1.


### -field VDS_LT_PARITY

The LUN type is striped with parity, which accounts for RAID levels 3, 4, 5, and 6.


### -field VDS_LT_RAID2

The LUN type is RAID level 2.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID3

The LUN type is RAID level 3.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID4

The LUN type is RAID level 4.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID5

The LUN type is RAID level 5.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID6

The LUN type is RAID level 6.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID01

The LUN type is RAID level 0+1.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID03

The LUN type is RAID level 0+3.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID05

The LUN type is RAID level 0+5.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID10

The LUN type is RAID level 1+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID15

The LUN type is RAID level 1+5.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID30

The LUN type is RAID level 3+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID50

The LUN type is RAID level 5+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID51

The LUN type is RAID level 5+1.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID53

The LUN type is RAID level 5+3.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID60

The LUN type is RAID level 6+0.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


### -field VDS_LT_RAID61

The LUN type is RAID level 6+1.

<b>Windows Server 2008, Windows Vista and Windows Server 2003:  </b>This value is not supported.


## -remarks



The  
        <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystem-createlun">IVdsSubSystem::CreateLun</a> method passes a <b>VDS_LUN_TYPE</b> value as a parameter to set a new LUN type, and the <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_lun_prop">VDS_LUN_PROP</a> structure includes a <b>VDS_LUN_TYPE</b> value as a member to indicate an existing LUN type.

If the <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystem-createlun">IVdsSubSystem::CreateLun</a> method returns a <b>VDS_LUN_TYPE</b> value that the caller does not recognize, the caller should display the LUN type as unknown. The caller should not attempt to map the unrecognized LUN type to another LUN type.

<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_LUN_TYPE</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_LUN_TYPE</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystem2-createlun2">IVdsHwProviderStoragePools::CreateLunInStoragePool</a>



<b>IVdsSubSystem2::CreateLun2</b>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/nf-vdshwprv-ivdssubsystem-createlun">IVdsSubSystem::CreateLun</a>



<a href="https://docs.microsoft.com/windows/desktop/VDS/vds-enumerations">VDS Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_lun_prop">VDS_LUN_PROP</a>
 

 

