---
UID: NE:vdshwprv._VDS_NOTIFICATION_TARGET_TYPE
title: VDS_NOTIFICATION_TARGET_TYPE (vdshwprv.h)
description: Defines the set of the valid target types (subjects) of a VDS notification.
old-location: base\vds_notification_target_type.htm
tech.root: VDS
ms.assetid: ce1f67b4-f7ea-4797-9073-0d80879c4a63
ms.date: 12/05/2018
ms.keywords: VDS_NOTIFICATION_TARGET_TYPE, VDS_NOTIFICATION_TARGET_TYPE enumeration [VDS], VDS_NTT_CONTROLLER, VDS_NTT_DISK, VDS_NTT_DRIVE, VDS_NTT_DRIVE_LETTER, VDS_NTT_FILE_SYSTEM, VDS_NTT_LUN, VDS_NTT_MOUNT_POINT, VDS_NTT_PACK, VDS_NTT_PARTITION, VDS_NTT_PORT, VDS_NTT_PORTAL, VDS_NTT_PORTAL_GROUP, VDS_NTT_SERVICE, VDS_NTT_SUB_SYSTEM, VDS_NTT_TARGET, VDS_NTT_UNKNOWN, VDS_NTT_VOLUME, base.vds_notification_target_type, vds/VDS_NOTIFICATION_TARGET_TYPE, vds/VDS_NTT_CONTROLLER, vds/VDS_NTT_DISK, vds/VDS_NTT_DRIVE, vds/VDS_NTT_DRIVE_LETTER, vds/VDS_NTT_FILE_SYSTEM, vds/VDS_NTT_LUN, vds/VDS_NTT_MOUNT_POINT, vds/VDS_NTT_PACK, vds/VDS_NTT_PARTITION, vds/VDS_NTT_PORT, vds/VDS_NTT_PORTAL, vds/VDS_NTT_PORTAL_GROUP, vds/VDS_NTT_SERVICE, vds/VDS_NTT_SUB_SYSTEM, vds/VDS_NTT_TARGET, vds/VDS_NTT_UNKNOWN, vds/VDS_NTT_VOLUME, vdshwprv/VDS_NOTIFICATION_TARGET_TYPE, vdshwprv/VDS_NTT_CONTROLLER, vdshwprv/VDS_NTT_DISK, vdshwprv/VDS_NTT_DRIVE, vdshwprv/VDS_NTT_DRIVE_LETTER, vdshwprv/VDS_NTT_FILE_SYSTEM, vdshwprv/VDS_NTT_LUN, vdshwprv/VDS_NTT_MOUNT_POINT, vdshwprv/VDS_NTT_PACK, vdshwprv/VDS_NTT_PARTITION, vdshwprv/VDS_NTT_PORT, vdshwprv/VDS_NTT_PORTAL, vdshwprv/VDS_NTT_PORTAL_GROUP, vdshwprv/VDS_NTT_SERVICE, vdshwprv/VDS_NTT_SUB_SYSTEM, vdshwprv/VDS_NTT_TARGET, vdshwprv/VDS_NTT_UNKNOWN, vdshwprv/VDS_NTT_VOLUME
f1_keywords:
- vdshwprv/VDS_NOTIFICATION_TARGET_TYPE
dev_langs:
- c++
req.header: vdshwprv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Vds.h
- VdsHwPrv.h
api_name:
- VDS_NOTIFICATION_TARGET_TYPE
targetos: Windows
req.typenames: VDS_NOTIFICATION_TARGET_TYPE
req.redist: 
ms.custom: 19H1
---

# VDS_NOTIFICATION_TARGET_TYPE enumeration


## -description


<p class="CCE_Message">[Beginning with Windows 8 and Windows Server 2012, the <a href="https://docs.microsoft.com/windows/desktop/VDS/virtual-disk-service-portal">Virtual Disk Service</a> COM interface is superseded by the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/stormgmt/windows-storage-management-api-portal">Windows Storage Management API</a>.]

Defines the set of the valid target types (subjects) of a VDS notification.


## -enum-fields




### -field VDS_NTT_UNKNOWN

This value is reserved.


### -field VDS_NTT_PACK

The target is a disk pack. This value corresponds to the <b>VDS_OT_PACK</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_VOLUME

The target is a volume. This value corresponds to the <b>VDS_OT_VOLUME</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_DISK

The target is a disk. This value corresponds to the <b>VDS_OT_DISK</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_PARTITION

The target is a partition.


### -field VDS_NTT_DRIVE_LETTER

The target is a drive letter.


### -field VDS_NTT_FILE_SYSTEM

The target is a file system.


### -field VDS_NTT_MOUNT_POINT

The target is a drive letter  or volume GUID path.


### -field VDS_NTT_SUB_SYSTEM

The target is a subsystem. This value corresponds to the <b>VDS_OT_SUB_SYSTEM</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_CONTROLLER

The target is a controller. This value corresponds to the <b>VDS_OT_CONTROLLER</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_DRIVE

The target is a drive. This value corresponds to the <b>VDS_OT_DRIVE</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_LUN

The target is a LUN. This value corresponds to the <b>VDS_OT_LUN</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.


### -field VDS_NTT_PORT

The target is a controller port.
       This value corresponds to the <b>VDS_OT_PORT</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.

<div class="alert"><b>Note</b>  This value is not supported on VDS 1.0.</div>
<div> </div>

### -field VDS_NTT_PORTAL

The target is an iSCSI portal.
       This value corresponds to the <b>VDS_OT_PORTAL</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.

<div class="alert"><b>Note</b>  This value is not supported on VDS 1.0.</div>
<div> </div>

### -field VDS_NTT_TARGET

The target is a target.
       This value corresponds to the <b>VDS_OT_TARGET</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.

<div class="alert"><b>Note</b>  This value is not supported on VDS 1.0.</div>
<div> </div>

### -field VDS_NTT_PORTAL_GROUP

The target is an iSCSI portal group.
       This value corresponds to the <b>VDS_PORTAL_GROUP</b> value in the  <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.

<div class="alert"><b>Note</b>  This value is not supported on VDS 1.0.</div>
<div> </div>

### -field VDS_NTT_SERVICE

This member is not currently used.


## -remarks



The <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_notification">VDS_NOTIFICATION</a> structure includes a <b>VDS_NOTIFICATION_TARGET_TYPE</b> 
    value as a member to indicate a notification type. Some values in the <b>VDS_NOTIFICATION_TARGET_TYPE</b> correspond to values in the <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration. For the integer value of a VDS object type, 
    such as a volume or LUN object, see the 
    <a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a> enumeration.

<div class="alert"><b>Note</b>  Additional constants might be added to the <b>VDS_NOTIFICATION_TARGET_TYPE</b> enumeration in future Windows versions. For this reason, your application must be designed to gracefully handle an unrecognized <b>VDS_NOTIFICATION_TARGET_TYPE</b> enumeration constant.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/VDS/vds-enumerations">VDS Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ns-vdshwprv-vds_notification">VDS_NOTIFICATION</a>



<a href="https://docs.microsoft.com/windows/desktop/api/vdshwprv/ne-vdshwprv-vds_object_type">VDS_OBJECT_TYPE</a>
 

 

